/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.leito.sqlformatter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import org.bitbucket.leito.sqlformatter.ColumnFormatter;

public class InsertStatementFormatter {
    private String tableName;
    private Map<String, ColumnFormatter> columns = new LinkedHashMap<String, ColumnFormatter>();
    private int rowCount = 0;

    public InsertStatementFormatter(String tableName) {
        this.tableName = tableName;
    }

    public void addRowValues(List<Column> columnsForValues, ExpressionList values) {
        columnsForValues.forEach(c -> this.addColumn(c.getColumnName()));
        List expressions = values.getExpressions();
        for (int i = 0; i < columnsForValues.size(); ++i) {
            Column columnForValue = columnsForValues.get(i);
            ColumnFormatter columnFormatter = this.columns.get(columnForValue.getColumnName());
            columnFormatter.addValueForRow(this.rowCount, ((Expression)expressions.get(i)).toString());
        }
        ++this.rowCount;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        this.printHeader(sb);
        this.printInsertWithColumns(sb);
        this.printRows(sb);
        return sb.toString();
    }

    private void printHeader(StringBuilder sb) {
        sb.append("-- -----------------------------------------------------------------------------\n");
        sb.append("-- ").append(this.tableName).append("\n");
        sb.append("-- -----------------------------------------------------------------------------\n");
    }

    private void printInsertWithColumns(StringBuilder sb) {
        sb.append("INSERT INTO ").append(this.tableName).append("\n(");
        String columnNames = this.columns.values().stream().map(c -> c.formatHeader()).collect(Collectors.joining(", "));
        sb.append(columnNames);
        sb.append(") VALUES\n");
    }

    private void printRows(StringBuilder sb) {
        ArrayList<String> rows = new ArrayList<String>();
        for (int i = 0; i < this.rowCount; ++i) {
            StringBuilder rowBuilder = new StringBuilder();
            rowBuilder.append("(");
            ArrayList<String> rowValues = new ArrayList<String>();
            for (ColumnFormatter columnFormatter : this.columns.values()) {
                rowValues.add(columnFormatter.formatValue(i));
            }
            String formattedRowValues = rowValues.stream().collect(Collectors.joining(", "));
            rowBuilder.append(formattedRowValues);
            rowBuilder.append(")");
            rows.add(rowBuilder.toString());
        }
        String formattedRows = rows.stream().collect(Collectors.joining(",\n"));
        sb.append(formattedRows);
        sb.append(";\n");
    }

    private void addColumn(String columnName) {
        this.columns.putIfAbsent(columnName, new ColumnFormatter(columnName));
    }
}

