/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.leito.sqlformatter;

import java.util.LinkedHashMap;
import java.util.Map;

public class ColumnFormatter {
    private static final String UNKNOWN_VALUE = "NULL";
    private String name;
    private Map<Integer, String> values = new LinkedHashMap<Integer, String>();
    private int maxColumnLength;

    public ColumnFormatter(String name) {
        this.name = name;
        this.maxColumnLength = name.length() > UNKNOWN_VALUE.length() ? name.length() : UNKNOWN_VALUE.length();
    }

    public String formatHeader() {
        return this.padRight(this.name);
    }

    public String formatValue(int row) {
        StringBuilder sb = new StringBuilder();
        String value = this.values.get(row);
        if (value == null) {
            value = UNKNOWN_VALUE;
        }
        sb.append(this.padRight(value));
        return sb.toString();
    }

    public void addValueForRow(int row, String value) {
        this.values.putIfAbsent(row, value);
        this.maxColumnLength = value.length() > this.maxColumnLength ? value.length() : this.maxColumnLength;
    }

    private String padRight(String s) {
        return String.format("%1$-" + this.maxColumnLength + "s", s);
    }
}

