/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.leito.sqlformatter;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.bitbucket.leito.sqlformatter.SqlFormatter;

public class App {
    public static void main(String[] args) throws Exception {
        if (!App.argsAreValid(args)) {
            System.exit(-1);
        }
        String inputFile = args[0];
        String sql = App.fileToString(inputFile);
        SqlFormatter formatter = new SqlFormatter();
        String output = formatter.format(sql);
        System.out.println(output);
        System.exit(0);
    }

    private static String fileToString(String path) throws IOException {
        return new String(Files.readAllBytes(Paths.get(path, new String[0])));
    }

    private static boolean argsAreValid(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java -jar sqlformatter.jar inputFile");
            return false;
        }
        return true;
    }
}

