/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.seunjeon.elasticsearch.index.analysis;

import java.nio.file.Path;
import org.apache.lucene.analysis.Tokenizer;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.SeunjeonTokenizer;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.TokenizerOptions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class SeunjeonTokenizerFactory
extends AbstractTokenizerFactory {
    private TokenizerOptions options;

    public SeunjeonTokenizerFactory(IndexSettings indexSettings, Environment environment, String string, Settings settings) {
        super(indexSettings, string, settings);
        this.options = TokenizerOptions.create(string).setUserDictPath(this.getFullPath(environment, settings.get("user_dict_path", null))).setUserWords(settings.getAsArray("user_words", new String[0])).setDeCompound(settings.getAsBoolean("decompound", Boolean.valueOf(true))).setDeInflect(settings.getAsBoolean("deinflect", Boolean.valueOf(true))).setIndexEojeol(settings.getAsBoolean("index_eojeol", Boolean.valueOf(true))).setIndexPoses(settings.getAsArray("index_poses", TokenizerOptions.INDEX_POSES)).setPosTagging(settings.getAsBoolean("pos_tagging", Boolean.valueOf(true))).setMaxUnkLength(settings.getAsInt("max_unk_length", Integer.valueOf(8)));
    }

    private String getFullPath(Environment environment, String string) {
        if (string == null) {
            return null;
        }
        Path path = environment.configFile().resolve(string);
        String string2 = path.toString();
        return string2;
    }

    public Tokenizer create() {
        return new SeunjeonTokenizer(this.options);
    }
}

