/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.seunjeon.elasticsearch;

import java.io.IOException;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.util.RollingCharBuffer;
import org.apache.lucene.util.AttributeFactory;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.LuceneToken;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.TokenizerHelper;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.TokenizerOptions;
import org.elasticsearch.common.logging.ESLoggerFactory;

public class SeunjeonTokenizer
extends Tokenizer {
    private CharTermAttribute charTermAtt;
    private PositionIncrementAttribute posIncrAtt;
    private PositionLengthAttribute posLenAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;
    private Queue<LuceneToken> tokensQueue;
    private TokenizerHelper tokenizerHelper;
    private final RollingCharBuffer buffer = new RollingCharBuffer();
    private int finalOffset;
    Logger logger = null;

    public SeunjeonTokenizer(TokenizerOptions tokenizerOptions) {
        super(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
        this.logger = ESLoggerFactory.getLogger((String)tokenizerOptions.getName());
        this.initAttribute();
        this.tokenizerHelper = new TokenizerHelper(tokenizerOptions.getDeCompound(), tokenizerOptions.getDeInflect(), tokenizerOptions.getIndexEojeol(), tokenizerOptions.getPosTagging(), TokenizerHelper.convertPos(tokenizerOptions.getIndexPoses()));
        this.tokenizerHelper.setMaxUnkLength(tokenizerOptions.getMaxUnkLength());
        if (tokenizerOptions.getUserDictPath() != null) {
            this.tokenizerHelper.setUserDict(tokenizerOptions.getUserDictPath());
            this.logger.info(tokenizerOptions.getUserDictPath() + " loading was successful.");
            if (tokenizerOptions.getUserWords().length > 0) {
                this.logger.warn("ignored \"user_words\". because settings of \"user_dict_path\"");
            }
        } else {
            this.tokenizerHelper.setUserDict(tokenizerOptions.getUserWords());
        }
    }

    private void initAttribute() {
        this.charTermAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        if (this.tokensQueue.isEmpty()) {
            return false;
        }
        LuceneToken luceneToken = this.tokensQueue.poll();
        this.posIncrAtt.setPositionIncrement(luceneToken.positionIncr());
        this.posLenAtt.setPositionLength(luceneToken.positionLength());
        this.finalOffset = this.correctOffset(luceneToken.endOffset());
        this.offsetAtt.setOffset(this.correctOffset(luceneToken.beginOffset()), this.finalOffset);
        String string = luceneToken.charTerm();
        this.charTermAtt.copyBuffer(string.toCharArray(), 0, string.length());
        this.typeAtt.setType(luceneToken.poses());
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.tokensQueue = new LinkedList<LuceneToken>(this.tokenizerHelper.tokenize(this.getDocument()));
    }

    public final void end() throws IOException {
        super.end();
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    private String getDocument() throws IOException {
        int n;
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[4096];
        while (-1 != (n = this.input.read(cArray))) {
            stringWriter.write(cArray, 0, n);
        }
        String string = stringWriter.toString().toLowerCase();
        return string;
    }
}

