/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.seunjeon.elasticsearch;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeFactory;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.LuceneToken;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.TokenBuilder;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.TokenizerOptions;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class SeunjeonTokenizer
extends Tokenizer {
    private CharTermAttribute charTermAtt;
    private PositionIncrementAttribute posIncrAtt;
    private PositionLengthAttribute posLenAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;
    private Queue<LuceneToken> tokensQueue;
    private TokenBuilder tokenBuilder;
    ESLogger logger = null;

    public SeunjeonTokenizer(TokenizerOptions tokenizerOptions) {
        super(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
        this.logger = Loggers.getLogger((String)tokenizerOptions.getName());
        this.initAttribute();
        TokenBuilder.setMaxUnkLength(tokenizerOptions.getMaxUnkLength());
        if (tokenizerOptions.getUserDictPath() != null) {
            TokenBuilder.setUserDict(tokenizerOptions.getUserDictPath());
            this.logger.info(tokenizerOptions.getUserDictPath() + " loading was successful.", new Object[0]);
            if (tokenizerOptions.getUserWords().length > 0) {
                this.logger.warn("ignored \"user_words\". because settings of \"user_dict_path\"", new Object[0]);
            }
        } else {
            TokenBuilder.setUserDict(Arrays.asList(tokenizerOptions.getUserWords()).iterator());
        }
        this.tokenBuilder = new TokenBuilder(tokenizerOptions.getDeCompound(), tokenizerOptions.getDeInflect(), tokenizerOptions.getIndexEojeol(), tokenizerOptions.getPosTagging(), TokenBuilder.convertPos(tokenizerOptions.getIndexPoses()));
    }

    private void initAttribute() {
        this.charTermAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public void reset() throws IOException {
        super.reset();
        this.tokensQueue = new LinkedList<LuceneToken>(this.tokenBuilder.tokenize(this.getDocument()));
    }

    public final boolean incrementToken() throws IOException {
        if (this.tokensQueue.isEmpty()) {
            return false;
        }
        LuceneToken luceneToken = this.tokensQueue.poll();
        this.posIncrAtt.setPositionIncrement(luceneToken.positionIncr());
        this.posLenAtt.setPositionLength(luceneToken.positionLength());
        this.offsetAtt.setOffset(this.correctOffset(luceneToken.startOffset()), this.correctOffset(luceneToken.endOffset()));
        String string2 = luceneToken.charTerm();
        this.charTermAtt.copyBuffer(string2.toCharArray(), 0, string2.length());
        this.typeAtt.setType(luceneToken.poses());
        return true;
    }

    private String getDocument() throws IOException {
        int n;
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[4096];
        while (-1 != (n = this.input.read(cArray))) {
            stringWriter.write(cArray, 0, n);
        }
        return stringWriter.toString().toLowerCase();
    }
}

