/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.tail.index.TailIndex;

public class SBVTailIndex
implements Externalizable,
TailIndex {
    private SuccinctBitVector sbv;
    private int size;
    private static final long serialVersionUID = 8843853578097509573L;

    public SBVTailIndex() {
        this.sbv = new BytesSuccinctBitVector();
    }

    public SBVTailIndex(SuccinctBitVector sbv, int size2) {
        this.sbv = sbv;
        this.size = size2;
    }

    public SBVTailIndex(byte[] bits2, int bitSize, int size2) {
        this.sbv = new BytesSuccinctBitVector(bits2, bitSize);
        this.size = size2;
    }

    public SuccinctBitVector getSbv() {
        return this.sbv;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int nodeId) {
        if (nodeId == 0) {
            if (this.sbv.isZero(0)) {
                return -1;
            }
            return 0;
        }
        int s2 = this.sbv.select0(nodeId);
        if (this.sbv.isZero(s2 + 1)) {
            return -1;
        }
        return this.sbv.rank1(s2);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.sbv = (SuccinctBitVector)in.readObject();
        this.size = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sbv);
        out.writeInt(this.size);
    }
}

