/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail.builder;

import java.io.Serializable;
import org.trie4j.tail.builder.TailBuilder;
import org.trie4j.util.CharsCharSequence;

public class SuffixTrieTailBuilder
implements Serializable,
TailBuilder {
    private Node root;
    private StringBuilder tails = new StringBuilder();
    private static final long serialVersionUID = 2700592335145146376L;

    public SuffixTrieTailBuilder() {
        this.tails = new StringBuilder();
    }

    public SuffixTrieTailBuilder(StringBuilder tails2) {
        this.tails = tails2;
    }

    public Node getRoot() {
        return this.root;
    }

    @Override
    public CharSequence getTails() {
        return this.tails;
    }

    @Override
    public int insert(CharSequence letters) {
        return this.insert(letters, 0, letters.length());
    }

    @Override
    public int insert(CharSequence letters, int offset, int len) {
        if (this.root == null) {
            this.tails.append(letters, offset, offset + len).append('\u0000');
            this.root = new Node(0, len - 1);
            return 0;
        }
        Node responsibleNode = this.root.insertChild(this.tails, 0, letters, offset, offset + len - 1);
        if (this.root.getParent() != null) {
            this.root = this.root.getParent();
        }
        return responsibleNode.getFirst();
    }

    @Override
    public int insert(char[] letters) {
        return this.insert(letters, 0, letters.length);
    }

    @Override
    public int insert(char[] letters, int offset, int len) {
        CharsCharSequence lettersSeq = new CharsCharSequence(letters, offset, offset + len);
        if (this.root == null) {
            this.tails.append(lettersSeq).append('\u0000');
            this.root = new Node(0, lettersSeq.length() - 1);
            return 0;
        }
        Node responsibleNode = this.root.insertChild(this.tails, 0, lettersSeq, 0, lettersSeq.length() - 1);
        if (this.root.getParent() != null) {
            this.root = this.root.getParent();
        }
        return responsibleNode.getFirst();
    }

    public static class Node
    implements Serializable {
        public final char[] emptyChars = new char[0];
        private int first;
        private int last;
        private Node parent;
        private Node[] children;
        private static final long serialVersionUID = 6049322543029754258L;

        public Node(int first, int last2) {
            this.first = first;
            this.last = last2;
        }

        public Node(int first, int last2, Node parent) {
            this.first = first;
            this.last = last2;
            this.parent = parent;
        }

        public Node(int first, int last2, Node parent, Node[] children2) {
            this.first = first;
            this.last = last2;
            this.parent = parent;
            this.children = children2;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public int getFirst() {
            return this.first;
        }

        public int getLast() {
            return this.last;
        }

        public CharSequence getLetters(CharSequence tails2) {
            return tails2.subSequence(this.first, this.last + 1);
        }

        public void setLetters(int first, int last2) {
            this.first = first;
            this.last = last2;
        }

        public Node insertChild(StringBuilder tails2, int childIndex, CharSequence letters, int begin, int offset) {
            int cont;
            int matchedCount;
            int lettersRest = offset + 1 - begin;
            int thisLettersLength = this.last - this.first + 1;
            int n = Math.min(lettersRest, thisLettersLength);
            int c = 0;
            for (matchedCount = 0; matchedCount < n && (c = letters.charAt(offset - matchedCount) - tails2.charAt(this.last - matchedCount)) == 0; ++matchedCount) {
            }
            if (matchedCount == n) {
                if (matchedCount != 0 && lettersRest == thisLettersLength) {
                    return this;
                }
                if (lettersRest < thisLettersLength) {
                    Node parent = new Node(this.last - matchedCount + 1, this.last, this.parent, new Node[]{this});
                    if (this.parent != null) {
                        this.parent.getChildren()[childIndex] = parent;
                    }
                    this.last -= matchedCount;
                    this.parent = parent;
                    return parent;
                }
                if (this.children != null) {
                    int index = 0;
                    int end = this.getChildren().length;
                    if (end > 16) {
                        int start = 0;
                        while (start < end) {
                            index = (start + end) / 2;
                            Node child = this.children[index];
                            c = letters.charAt(offset - matchedCount) - tails2.charAt(child.last);
                            if (c == 0) {
                                return child.insertChild(tails2, index, letters, begin, offset - matchedCount);
                            }
                            if (c < 0) {
                                end = index;
                                continue;
                            }
                            if (start == index) {
                                index = end;
                                break;
                            }
                            start = index;
                        }
                    } else {
                        for (index = 0; index < end; ++index) {
                            Node child = this.getChildren()[index];
                            int idx = offset - matchedCount;
                            if (idx < 0) {
                                throw new RuntimeException("???");
                            }
                            c = letters.charAt(offset - matchedCount) - tails2.charAt(child.last);
                            if (c >= 0) {
                                if (c != 0) continue;
                                return child.insertChild(tails2, index, letters, begin, offset - matchedCount);
                            }
                            break;
                        }
                    }
                    return this.addChild(tails2, index, letters, begin, offset, matchedCount);
                }
                return this.addChild(tails2, 0, letters, begin, offset, matchedCount);
            }
            Node[] newParentsChildren = new Node[2];
            Node newParent = new Node(this.last - matchedCount + 1, this.last, this.parent, newParentsChildren);
            int newChildFirst = tails2.length();
            tails2.append(letters, begin, begin + lettersRest - matchedCount);
            int newChildLast = tails2.length() - 1;
            if (matchedCount == 0) {
                tails2.append('\u0000');
            } else if (matchedCount < 3) {
                tails2.append(letters, begin + lettersRest - matchedCount, begin + lettersRest);
                cont = this.last + 1;
                if (tails2.charAt(cont) == '\u0000') {
                    tails2.append('\u0000');
                } else if (tails2.charAt(cont) == '\u0001') {
                    tails2.append('\u0001').append(tails2.charAt(cont + 1)).append(tails2.charAt(cont + 2));
                } else {
                    tails2.append('\u0001').append((char)(cont & 0xFFFF)).append((char)((cont & 0xFFFF0000) >> 16));
                }
            } else {
                cont = this.last - matchedCount + 1;
                tails2.append('\u0001').append((char)(cont & 0xFFFF)).append((char)((cont & 0xFFFF0000) >> 16));
            }
            Node newChild = new Node(newChildFirst, newChildLast, newParent, null);
            if (tails2.charAt(this.last - matchedCount) < letters.charAt(lettersRest - matchedCount - 1)) {
                newParentsChildren[0] = this;
                newParentsChildren[1] = newChild;
            } else {
                newParentsChildren[0] = newChild;
                newParentsChildren[1] = this;
            }
            this.last -= matchedCount;
            if (this.parent != null) {
                this.parent.getChildren()[childIndex] = newParent;
            }
            this.parent = newParent;
            return newChild;
        }

        public Node[] getChildren() {
            return this.children;
        }

        public void setChildren(Node[] children2) {
            this.children = children2;
        }

        private Node addChild(StringBuilder tails2, int index, CharSequence letters, int min2, int offset, int matchedCount) {
            int cont;
            int newFirst = tails2.length();
            tails2.append(letters, min2, offset - matchedCount + 1);
            int newLast = tails2.length() - 1;
            if (matchedCount == 0) {
                tails2.append('\u0000');
            } else if (matchedCount < 3) {
                tails2.append(letters, offset - matchedCount + 1, offset + 1);
                cont = this.last + 1;
                if (tails2.charAt(cont) == '\u0000') {
                    tails2.append('\u0000');
                } else if (tails2.charAt(cont) == '\u0001') {
                    tails2.append('\u0001').append(tails2.charAt(cont + 1)).append(tails2.charAt(cont + 2));
                } else {
                    tails2.append('\u0001').append((char)(cont & 0xFFFF)).append((char)((cont & 0xFFFF0000) >> 16));
                }
            } else {
                cont = this.last - matchedCount + 1;
                tails2.append('\u0001').append((char)(cont & 0xFFFF)).append((char)((cont & 0xFFFF0000) >> 16));
            }
            Node child = new Node(newFirst, newLast, this, null);
            if (this.children != null) {
                Node[] newc = new Node[this.children.length + 1];
                System.arraycopy(this.children, 0, newc, 0, index);
                newc[index] = child;
                System.arraycopy(this.children, index, newc, index + 1, this.children.length - index);
                this.children = newc;
            } else {
                this.children = new Node[]{child};
            }
            return child;
        }
    }
}

