/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.patricia.multilayer.node;

import org.trie4j.NodeVisitor;
import org.trie4j.patricia.multilayer.Node;
import org.trie4j.patricia.multilayer.labeltrie.LabelNode;
import org.trie4j.patricia.multilayer.node.CharsNode;
import org.trie4j.patricia.multilayer.node.InternalCharsNode;
import org.trie4j.patricia.multilayer.node.LabelTrieNode;
import org.trie4j.patricia.multilayer.node.SingleChildInternalLabelTrieNode;

public class SingleChildInternalCharsNode
extends CharsNode {
    private Node child;

    public SingleChildInternalCharsNode(char[] letters, Node child) {
        super(letters);
        this.child = child;
    }

    @Override
    public Node[] getChildren() {
        return new Node[]{this.child};
    }

    @Override
    public void setChildren(Node[] children2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setChild(int index, Node child) {
        if (index != 0) {
            throw new IllegalStateException();
        }
        this.child = child;
    }

    @Override
    public Node getChild(char c) {
        if (this.child.getFirstLetter() == c) {
            return this.child;
        }
        return null;
    }

    @Override
    public Node addChild(int index, Node n) {
        if (index == 0) {
            return new InternalCharsNode(this.getLetters(), new Node[]{n, this.child});
        }
        return new InternalCharsNode(this.getLetters(), new Node[]{this.child, n});
    }

    @Override
    public void visit(NodeVisitor visitor, int nest) {
        super.visit(visitor, nest);
        this.child.visit(visitor, ++nest);
    }

    @Override
    protected Node cloneWithLetters(char[] letters) {
        return new SingleChildInternalCharsNode(letters, this.child);
    }

    @Override
    protected Node newLabelTrieNode(LabelNode ln, Node[] children2) {
        if (children2 != null) {
            if (children2.length != 1) {
                throw new IllegalArgumentException();
            }
            return new SingleChildInternalLabelTrieNode(ln, children2[0]);
        }
        return new LabelTrieNode(ln);
    }
}

