/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.patricia.multilayer.labeltrie;

import java.util.Arrays;
import org.trie4j.Node;
import org.trie4j.NodeVisitor;
import org.trie4j.patricia.multilayer.labeltrie.InternalLabelNode;
import org.trie4j.patricia.multilayer.node.LabelTrieNode;
import org.trie4j.util.Pair;

public class LabelNode
implements Node {
    public static final char[] emptyChars = new char[0];
    private char[] letters;
    private LabelNode parent;

    public LabelNode(char[] letters) {
        this.letters = letters;
    }

    public LabelNode(char[] letters, LabelNode parent) {
        this.letters = letters;
        this.parent = parent;
    }

    @Override
    public char[] getLetters() {
        return this.letters;
    }

    public void setLetters(char[] letters) {
        this.letters = letters;
    }

    @Override
    public boolean isTerminate() {
        return false;
    }

    public LabelNode getParent() {
        return this.parent;
    }

    public void setParent(LabelNode parent) {
        this.parent = parent;
    }

    public LabelNode[] getChildren() {
        return null;
    }

    public void setChildren(LabelNode[] children2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LabelNode getChild(char c) {
        return null;
    }

    public LabelNode insertChild(int childIndex, char[] letters, int offset) {
        if (this.letters == null) {
            this.letters = Arrays.copyOfRange(letters, offset, letters.length);
            return this;
        }
        int i = 0;
        int lettersRest = letters.length - offset;
        int thisLettersLength = this.letters.length;
        int n = Math.min(lettersRest, thisLettersLength);
        int c = 0;
        while (i < n && (c = letters[i + offset] - this.letters[i]) == 0) {
            ++i;
        }
        if (i == n) {
            if (lettersRest == thisLettersLength) {
                return this;
            }
            if (lettersRest < thisLettersLength) {
                InternalLabelNode parent = new InternalLabelNode(Arrays.copyOf(this.letters, i), this.parent, new LabelNode[]{this});
                if (this.parent != null) {
                    this.parent.getChildren()[childIndex] = parent;
                }
                this.letters = Arrays.copyOfRange(this.letters, i, this.letters.length);
                this.parent = parent;
                return parent;
            }
            if (this.getChildren() != null) {
                int index = 0;
                int end = this.getChildren().length;
                if (end > 16) {
                    int start = 0;
                    while (start < end) {
                        index = (start + end) / 2;
                        LabelNode child = this.getChildren()[index];
                        c = letters[i + offset] - child.letters[0];
                        if (c == 0) {
                            return child.insertChild(index, letters, i + offset);
                        }
                        if (c < 0) {
                            end = index;
                            continue;
                        }
                        if (start == index) {
                            index = end;
                            break;
                        }
                        start = index;
                    }
                } else {
                    index = 0;
                    while (index < end) {
                        LabelNode child = this.getChildren()[index];
                        c = letters[i + offset] - child.letters[0];
                        if (c >= 0) {
                            if (c == 0) {
                                return child.insertChild(index, letters, i + offset);
                            }
                            ++index;
                            continue;
                        }
                        break;
                    }
                }
                InternalLabelNode child = new InternalLabelNode(Arrays.copyOfRange(letters, i + offset, letters.length), this, null);
                this.addChild(index, child);
                return child;
            }
            InternalLabelNode child = new InternalLabelNode(Arrays.copyOfRange(letters, i + offset, letters.length), this, null);
            this.setChildren(new LabelNode[]{child});
            return child;
        }
        char[] newParentsLetter = Arrays.copyOfRange(this.letters, 0, i);
        char[] newThisLetter = Arrays.copyOfRange(this.letters, i, this.letters.length);
        char[] newChildsLetter = Arrays.copyOfRange(letters, i + offset, letters.length);
        LabelNode[] newParentsChildren = new LabelNode[2];
        InternalLabelNode newParent = new InternalLabelNode(newParentsLetter, this.parent, newParentsChildren);
        InternalLabelNode newChild = new InternalLabelNode(newChildsLetter, newParent, null);
        if (newThisLetter[0] < newChildsLetter[0]) {
            newParentsChildren[0] = this;
            newParentsChildren[1] = newChild;
        } else {
            newParentsChildren[0] = newChild;
            newParentsChildren[1] = this;
        }
        this.letters = newThisLetter;
        if (this.parent != null) {
            this.parent.getChildren()[childIndex] = newParent;
        }
        this.parent = newParent;
        return newChild;
    }

    boolean contains(char[] letters, int offset) {
        int tll = this.letters.length;
        int rest = letters.length - offset;
        if (tll > rest) {
            return false;
        }
        int i = 0;
        while (i < tll) {
            if (this.letters[i] != letters[i + offset]) {
                return false;
            }
            ++i;
        }
        if (tll == rest) {
            return true;
        }
        char c = letters[offset += tll];
        LabelNode n = this.getChild(c);
        if (n != null) {
            return n.contains(letters, offset);
        }
        return false;
    }

    public Pair<Integer, Boolean> containsBottomup(char[] letters, int offset) {
        int rest = letters.length - offset;
        int n = this.letters.length;
        int ttlm1 = n - 1;
        if (n > rest) {
            return Pair.create(0, false);
        }
        int i = 0;
        while (i < n) {
            if (this.letters[ttlm1 - i] != letters[offset]) {
                return Pair.create(i, false);
            }
            ++offset;
            ++i;
        }
        if (n == rest) {
            return Pair.create(n, true);
        }
        if (this.parent != null) {
            Pair<Integer, Boolean> ret = this.parent.containsBottomup(letters, offset);
            return Pair.create(ret.getFirst() + n, ret.getSecond());
        }
        return Pair.create(n, true);
    }

    public void pargeChildren() {
    }

    public void visit(NodeVisitor visitor, int nest) {
        visitor.visit(this, nest);
    }

    public void addChild(int index, LabelNode n) {
        throw new UnsupportedOperationException();
    }

    public void addReferer(LabelTrieNode l) {
        throw new UnsupportedOperationException();
    }

    public void removeReferer(LabelTrieNode l) {
    }
}

