/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.patricia.multilayer.labeltrie;

import org.trie4j.NodeVisitor;
import org.trie4j.patricia.multilayer.labeltrie.LabelNode;
import org.trie4j.patricia.multilayer.node.LabelTrieNode;

public class InternalLabelNode
extends LabelNode {
    private LabelNode[] children;
    private LabelTrieNode[] referers;

    public InternalLabelNode(char[] letters, LabelNode parent, LabelNode[] children2) {
        super(letters, parent);
        this.children = children2;
    }

    @Override
    public LabelNode[] getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(LabelNode[] children2) {
        this.children = children2;
    }

    @Override
    public LabelNode getChild(char c) {
        block8: {
            if (this.children == null) break block8;
            int end = this.children.length;
            if (end > 16) {
                int start = 0;
                while (start < end) {
                    int i = (start + end) / 2;
                    LabelNode n = this.children[i];
                    int d = c - n.getLetters()[0];
                    if (d == 0) {
                        return n;
                    }
                    if (d < 0) {
                        end = i;
                        continue;
                    }
                    if (start != i) {
                        start = i;
                        continue;
                    }
                    break;
                }
            } else {
                int i = 0;
                while (i < end) {
                    LabelNode n = this.children[i];
                    if (n.getLetters() != null && n.getLetters().length > 0 && n.getLetters()[0] == c) {
                        return n;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    @Override
    public void pargeChildren() {
        LabelNode newNode = new LabelNode(this.getLetters(), this.getParent());
        this.fireReplace(newNode);
        if (this.children != null) {
            LabelNode[] labelNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                LabelNode child = labelNodeArray[n2];
                child.setParent(newNode);
                child.pargeChildren();
                ++n2;
            }
        }
        this.children = null;
    }

    @Override
    public void addChild(int index, LabelNode n) {
        LabelNode[] newc = new LabelNode[this.children.length + 1];
        System.arraycopy(this.children, 0, newc, 0, index);
        newc[index] = n;
        System.arraycopy(this.children, index, newc, index + 1, this.children.length - index);
        this.children = newc;
    }

    @Override
    public void visit(NodeVisitor visitor, int nest) {
        super.visit(visitor, nest);
        if (this.children != null) {
            ++nest;
            LabelNode[] labelNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                LabelNode n3 = labelNodeArray[n2];
                n3.visit(visitor, nest);
                ++n2;
            }
        }
    }

    @Override
    public void addReferer(LabelTrieNode r) {
        if (this.referers == null) {
            this.referers = new LabelTrieNode[]{r};
        } else {
            LabelTrieNode[] ls = new LabelTrieNode[this.referers.length + 1];
            System.arraycopy(this.referers, 0, ls, 0, this.referers.length);
            ls[ls.length - 1] = r;
            this.referers = ls;
        }
    }

    @Override
    public void removeReferer(LabelTrieNode l) {
    }

    protected void fireReplace(LabelNode newLabelNode) {
        if (this.referers == null) {
            return;
        }
        LabelTrieNode[] labelTrieNodeArray = this.referers;
        int n = this.referers.length;
        int n2 = 0;
        while (n2 < n) {
            LabelTrieNode l = labelTrieNodeArray[n2];
            l.setLettersNode(newLabelNode);
            ++n2;
        }
    }
}

