/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.patricia.multilayer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.trie4j.AbstractTrie;
import org.trie4j.NodeVisitor;
import org.trie4j.Trie;
import org.trie4j.patricia.multilayer.Node;
import org.trie4j.patricia.multilayer.labeltrie.LabelTrie;
import org.trie4j.patricia.multilayer.node.CharsNode;
import org.trie4j.patricia.multilayer.node.TerminalCharsNode;

public class MultilayerPatriciaTrie
extends AbstractTrie
implements Trie {
    private int size;
    private Node root = new CharsNode(new char[0]);
    private LabelTrie labelTrie;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int nodeSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    public LabelTrie getLabelTrie() {
        return this.labelTrie;
    }

    @Override
    public boolean contains(String word) {
        return this.root.contains(word.toCharArray(), 0);
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        if (query.length() == 0) {
            return new ArrayList<String>(0);
        }
        return new Iterable<String>(query){
            private char[] queryChars;
            {
                this.queryChars = string2.toCharArray();
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int cur;
                    private StringBuilder currentChars = new StringBuilder();
                    private Node current;
                    private String next;
                    {
                        this.current = MultilayerPatriciaTrie.this.root;
                        this.cur = 0;
                        if (MultilayerPatriciaTrie.this.root != null) {
                            this.findNext();
                        }
                    }

                    private void findNext() {
                        this.next = null;
                        do {
                            char[] letters;
                            int len;
                            if (queryChars.length <= this.cur) {
                                return;
                            }
                            Node child = this.current.getChild(queryChars[this.cur]);
                            if (child == null) {
                                return;
                            }
                            int rest = queryChars.length - this.cur;
                            if (rest < (len = (letters = child.getLetters()).length)) {
                                return;
                            }
                            int i = 1;
                            while (i < len) {
                                int c = letters[i] - queryChars[this.cur + i];
                                if (c != 0) {
                                    return;
                                }
                                ++i;
                            }
                            String b = new String(queryChars, this.cur, len);
                            if (child.isTerminate()) {
                                this.next = this.currentChars + b;
                            }
                            this.cur += len;
                            this.currentChars.append(b);
                            this.current = child;
                        } while (this.next == null);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public String next() {
                        String ret = this.next;
                        if (ret == null) {
                            throw new NoSuchElementException();
                        }
                        this.findNext();
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static void enumLetters(org.trie4j.Node node, String prefix, List<String> letters) {
        org.trie4j.Node[] children2 = node.getChildren();
        if (children2 == null) {
            return;
        }
        org.trie4j.Node[] nodeArray = children2;
        int n = children2.length;
        int n2 = 0;
        while (n2 < n) {
            org.trie4j.Node child = nodeArray[n2];
            String text = String.valueOf(prefix) + new String(child.getLetters());
            if (child.isTerminate()) {
                letters.add(text);
            }
            MultilayerPatriciaTrie.enumLetters(child, text, letters);
            ++n2;
        }
    }

    @Override
    public Iterable<String> predictiveSearch(String prefix) {
        char[] queryChars = prefix.toCharArray();
        int cur = 0;
        Node node = this.root;
        while (node != null) {
            char[] letters = node.getLetters();
            int n = Math.min(letters.length, queryChars.length - cur);
            int i = 0;
            while (i < n) {
                if (letters[i] != queryChars[cur + i]) {
                    return Collections.emptyList();
                }
                ++i;
            }
            if (queryChars.length == (cur += n)) {
                ArrayList<String> ret = new ArrayList<String>();
                prefix = String.valueOf(prefix) + new String(letters, n, letters.length - n);
                if (node.isTerminate()) {
                    ret.add(prefix);
                }
                MultilayerPatriciaTrie.enumLetters(node, prefix, ret);
                return ret;
            }
            node = node.getChild(queryChars[cur]);
        }
        return Collections.emptyList();
    }

    @Override
    public void insert(String text) {
        if (this.labelTrie != null) {
            throw new IllegalStateException("insert after pack is not supported.");
        }
        char[] letters = text.toCharArray();
        if (this.root == null) {
            this.root = new TerminalCharsNode(letters);
        } else {
            Node newRoot = this.root.insertChild(letters, 0);
            if (newRoot != null) {
                this.root = newRoot;
            }
        }
        ++this.size;
    }

    public void pack() {
        if (this.labelTrie != null) {
            return;
        }
        this.labelTrie = new LabelTrie();
        this.root.pushLabel(this.labelTrie);
        this.labelTrie.pargeChildren();
    }

    public void visit(NodeVisitor visitor) {
        this.root.visit(visitor, 0);
    }
}

