/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.patricia;

import java.io.Serializable;
import java.util.ArrayList;
import org.trie4j.NodeVisitor;
import org.trie4j.patricia.TailPatriciaTrieNodeAdapter;
import org.trie4j.tail.TailCharIterator;
import org.trie4j.util.Pair;

public class TailPatriciaTrieNode
implements Serializable {
    private char firstChar;
    private int tailIndex;
    private boolean terminate;
    private TailPatriciaTrieNode[] children;
    private static final long serialVersionUID = -4622654571874519425L;

    public TailPatriciaTrieNode(char firstChar, int tailIndex, boolean terminate, TailPatriciaTrieNode[] children2) {
        this.firstChar = firstChar;
        this.tailIndex = tailIndex;
        this.terminate = terminate;
        this.children = children2;
    }

    public char[] getLetters(CharSequence tails2) {
        ArrayList<Character> letters = new ArrayList<Character>();
        if (this.firstChar != '\uffff') {
            letters.add(Character.valueOf(this.firstChar));
        }
        TailCharIterator it = new TailCharIterator(tails2, this.tailIndex);
        while (it.hasNext()) {
            letters.add(Character.valueOf(it.next()));
        }
        char[] ret = new char[letters.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((Character)letters.get(i)).charValue();
        }
        return ret;
    }

    public boolean isTerminate() {
        return this.terminate;
    }

    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    public char getFirstLetter() {
        return this.firstChar;
    }

    public int getTailIndex() {
        return this.tailIndex;
    }

    public void setTailIndex(int tailIndex) {
        this.tailIndex = tailIndex;
    }

    public TailCharIterator getSecondLetters(CharSequence tails2) {
        return new TailCharIterator(tails2, this.tailIndex);
    }

    public TailPatriciaTrieNode getChild(char c) {
        if (this.children == null) {
            return null;
        }
        return this.findNodeOnly(c);
    }

    public TailPatriciaTrieNode[] getChildren() {
        return this.children;
    }

    public void setChildren(TailPatriciaTrieNode[] children2) {
        this.children = children2;
    }

    public void visit(NodeVisitor visitor, int nest, CharSequence tails2) {
        visitor.visit(new TailPatriciaTrieNodeAdapter(this, tails2), nest);
        if (this.children != null) {
            ++nest;
            for (TailPatriciaTrieNode n : this.children) {
                n.visit(visitor, nest, tails2);
            }
        }
    }

    public TailPatriciaTrieNode addChild(int index, TailPatriciaTrieNode n) {
        TailPatriciaTrieNode[] newc = new TailPatriciaTrieNode[this.children.length + 1];
        System.arraycopy(this.children, 0, newc, 0, index);
        newc[index] = n;
        System.arraycopy(this.children, index, newc, index + 1, this.children.length - index);
        this.children = newc;
        return this;
    }

    public Pair<TailPatriciaTrieNode, Integer> findNode(char firstChar) {
        int end = this.children.length;
        if (end > 16) {
            int start = 0;
            while (start < end) {
                int i = (start + end) / 2;
                TailPatriciaTrieNode child = this.children[i];
                int d = firstChar - child.getFirstLetter();
                if (d == 0) {
                    return Pair.create(child, i);
                }
                if (d < 0) {
                    end = i;
                    continue;
                }
                if (start == i) {
                    return Pair.create(null, i + 1);
                }
                start = i;
            }
        } else {
            for (int i = 0; i < end; ++i) {
                TailPatriciaTrieNode child = this.children[i];
                int c = firstChar - child.getFirstLetter();
                if (c < 0) {
                    return Pair.create(null, i);
                }
                if (c != 0) continue;
                return Pair.create(child, i);
            }
        }
        return Pair.create(null, end);
    }

    private TailPatriciaTrieNode findNodeOnly(char firstChar) {
        int end = this.children.length;
        if (end > 16) {
            int start = 0;
            while (start < end) {
                int i = (start + end) / 2;
                TailPatriciaTrieNode child = this.children[i];
                int d = firstChar - child.getFirstLetter();
                if (d == 0) {
                    return child;
                }
                if (d < 0) {
                    end = i;
                    continue;
                }
                if (start == i) {
                    return null;
                }
                start = i;
            }
        } else {
            for (int i = 0; i < end; ++i) {
                TailPatriciaTrieNode child = this.children[i];
                int c = firstChar - child.getFirstLetter();
                if (c < 0) {
                    return null;
                }
                if (c != 0) continue;
                return child;
            }
        }
        return null;
    }
}

