/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.patricia;

import java.io.Serializable;
import org.trie4j.Node;
import org.trie4j.NodeVisitor;

public class PatriciaTrieNode
implements Serializable,
Node {
    private char[] letters;
    private boolean terminate;
    private PatriciaTrieNode[] children;
    private static PatriciaTrieNode[] emptyChildren = new PatriciaTrieNode[0];
    private static final long serialVersionUID = -1625115329685564809L;

    public PatriciaTrieNode() {
        this(new char[0], false);
    }

    public PatriciaTrieNode(char[] letters, boolean terminated) {
        this(letters, terminated, emptyChildren);
    }

    public PatriciaTrieNode(char[] letters, boolean terminated, PatriciaTrieNode[] children2) {
        this.letters = letters;
        this.terminate = terminated;
        this.children = children2;
    }

    public PatriciaTrieNode[] getChildren() {
        return this.children;
    }

    public void setChildren(PatriciaTrieNode[] children2) {
        this.children = children2;
    }

    @Override
    public char[] getLetters() {
        return this.letters;
    }

    public void setLetters(char[] letters) {
        this.letters = letters;
    }

    @Override
    public boolean isTerminate() {
        return this.terminate;
    }

    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    @Override
    public PatriciaTrieNode getChild(char c) {
        int end = this.children.length;
        if (end > 16) {
            int start = 0;
            while (start < end) {
                int i = (start + end) / 2;
                PatriciaTrieNode n = this.children[i];
                int d = c - n.letters[0];
                if (d == 0) {
                    return n;
                }
                if (d < 0) {
                    end = i;
                    continue;
                }
                if (start != i) {
                    start = i;
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < end; ++i) {
                PatriciaTrieNode n = this.children[i];
                if (n.letters[0] != c) continue;
                return n;
            }
        }
        return null;
    }

    public void visit(NodeVisitor visitor, int nest) {
        if (!visitor.visit(this, nest)) {
            return;
        }
        ++nest;
        for (PatriciaTrieNode n : this.children) {
            n.visit(visitor, nest);
        }
    }

    public PatriciaTrieNode addChild(int index, PatriciaTrieNode n) {
        PatriciaTrieNode[] newc = new PatriciaTrieNode[this.children.length + 1];
        System.arraycopy(this.children, 0, newc, 0, index);
        newc[index] = n;
        System.arraycopy(this.children, index, newc, index + 1, this.children.length - index);
        this.children = newc;
        return this;
    }
}

