/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.lz;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.trie4j.test.LapTimer;

public class LZSS {
    public static void main(String[] args) throws Exception {
        LapTimer lt = new LapTimer();
        String src = "abcabdrz";
        src = LZSS.read("data/jawiki-20120220-tail");
        int windowSize = 8192;
        lt.reset();
        LZSSData ret = LZSS.compress(src, windowSize);
        lt.lapMillis("compress done. %d elements, %d chars", new Object[]{ret.match.length(), ret.dest.length()});
        LZSS.dump(ret);
        StringBuilder b = new StringBuilder();
        lt.reset();
        LZSS.decompress(ret, b);
        lt.lapMillis("decompress done.", new Object[0]);
        StringBuilder dest = ret.dest;
        int sz = dest.length();
        int bsz = ret.size / 8 + (ret.size % 8 == 0 ? 0 : 1);
        boolean eq2 = src.equals(b.toString());
        System.out.println(String.format("src: %d, comp: %d(%02.1f%%) + %dbytes, decomp: %d, %b", src.length(), sz, 1.0 * (double)sz / (double)src.length() * 100.0, bsz, b.length(), eq2));
        int i = 0;
        while (i < src.length()) {
            if (src.charAt(i) != b.charAt(i)) {
                System.out.println(String.format("%dth char different [%c:%c]", i, Character.valueOf(src.charAt(i)), Character.valueOf(b.charAt(i))));
                int s2 = Math.max(i - 5, 0);
                int e = Math.min(i + 5, src.length());
                System.out.println("src: " + src.substring(s2, e));
                System.out.println("dec: " + b.substring(s2, e));
                break;
            }
            ++i;
        }
    }

    public static LZSSData compress(CharSequence src, int windowSize) throws IOException {
        BitSet match = new BitSet();
        StringBuilder out = new StringBuilder();
        int size2 = 0;
        HashMap startPoss = new HashMap();
        int n = src.length();
        int i = 0;
        while (i < n) {
            char target = src.charAt(i);
            boolean found = false;
            int start = 0;
            int matchLen = 0;
            LinkedList<Integer> poss = (LinkedList<Integer>)startPoss.get(Character.valueOf(target));
            if (poss != null) {
                Iterator it = poss.iterator();
                while (it.hasNext()) {
                    int s2 = (Integer)it.next();
                    if (i - s2 > windowSize) {
                        it.remove();
                        continue;
                    }
                    int len = LZSS.getMatchedLen(src, s2 + 1, i + 1, n) + 1;
                    if (len > matchLen) {
                        start = i - s2;
                        matchLen = len;
                    }
                    found = true;
                }
                poss.add(i);
                int jn = Math.min(i + matchLen, n);
                int j = i + 1;
                while (j < jn) {
                    LinkedList<Integer> p = (LinkedList<Integer>)startPoss.get(Character.valueOf(src.charAt(j)));
                    if (p == null) {
                        p = new LinkedList<Integer>();
                        startPoss.put(Character.valueOf(src.charAt(j)), p);
                    }
                    p.add(j);
                    ++j;
                }
            } else {
                poss = new LinkedList<Integer>();
                poss.add(i);
                startPoss.put(Character.valueOf(target), poss);
            }
            if (found && matchLen > 1) {
                match.set(size2);
                out.append((char)start).append((char)matchLen);
                i += matchLen - 1;
            } else {
                match.set(size2, false);
                out.append(target);
            }
            ++size2;
            ++i;
        }
        return new LZSSData(match, out, size2);
    }

    public static void decompress(LZSSData src, StringBuilder out) {
        int index = 0;
        int n = src.size;
        int i = 0;
        while (i < n) {
            if (src.match.get(i)) {
                char start = src.dest.charAt(index++);
                char matchedLen = src.dest.charAt(index++);
                int s2 = out.length() - start;
                int e = s2 + matchedLen;
                while (s2 < e) {
                    out.append(out.charAt(s2));
                    ++s2;
                }
            } else {
                out.append(src.dest.charAt(index++));
            }
            ++i;
        }
    }

    private static String toString(char c) {
        if (c < ' ') {
            return String.format("(0x%02x)", c);
        }
        return "" + c;
    }

    private static String read(String filename) throws IOException {
        try (FileInputStream is = new FileInputStream(filename);){
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            char[] buff = new char[((InputStream)is).available() / 2];
            int i = 0;
            while (dis.available() > 0) {
                buff[i++] = dis.readChar();
            }
            String string2 = new String(buff);
            return string2;
        }
    }

    private static void dump(LZSSData src) {
        int index = 0;
        int n = src.match.size();
        int i = 0;
        while (i < Math.min(n, 42)) {
            if (src.match.get(i)) {
                System.out.println(String.format("%02d %02d:%02d", i, (int)src.dest.charAt(index++), (int)src.dest.charAt(index++)));
            } else {
                System.out.println(String.format("%02d %s", i, LZSS.toString(src.dest.charAt(index++))));
            }
            ++i;
        }
    }

    private static int getMatchedLen(CharSequence src, int i1, int i2, int end) {
        int n = Math.min(i2 - i1, end - i2);
        int i = 0;
        while (i < n) {
            if (src.charAt(i1++) != src.charAt(i2++)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static class LZSSData {
        private BitSet match = new BitSet();
        private StringBuilder dest = new StringBuilder();
        private int size;

        public LZSSData(BitSet match, StringBuilder dest, int size2) {
            this.match = match;
            this.dest = dest;
            this.size = size2;
        }
    }
}

