/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.lz;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.trie4j.test.LapTimer;

public class LZ77 {
    public static void main(String[] args) throws Exception {
        LZ77.main1(args);
    }

    public static void main1(String[] args) throws Exception {
        LapTimer lt = new LapTimer();
        String src = "abcabdrz";
        src = LZ77.read("data/jawiki-20120220-tail");
        int windowSize = 8192;
        StringBuilder dest = new StringBuilder();
        lt.reset();
        LZ77.compress2(src, dest, windowSize);
        lt.lapMillis("compress done.", new Object[0]);
        int l = 0;
        int i = 0;
        while (i < dest.length() / 3) {
            l = Math.max(dest.charAt(i * 3 + 1), l);
            ++i;
        }
        System.out.println("max matched length: " + l);
        LZ77.dump(dest);
        StringBuilder b = new StringBuilder();
        lt.reset();
        LZ77.decompress(dest, b);
        lt.lapMillis("decompress done.", new Object[0]);
        boolean eq2 = src.equals(b.toString());
        System.out.println(String.format("src: %d, comp: %d(%02.1f%%), decomp: %d, %b", src.length(), dest.length(), 1.0 * (double)dest.length() / (double)src.length() * 100.0, b.length(), eq2));
        int i2 = 0;
        while (i2 < src.length()) {
            if (src.charAt(i2) != b.charAt(i2)) {
                System.out.println(String.format("%dth char different [%c:%c]", i2, Character.valueOf(src.charAt(i2)), Character.valueOf(b.charAt(i2))));
                int s2 = Math.max(i2 - 5, 0);
                int e = Math.min(i2 + 5, src.length());
                System.out.println("src: " + src.substring(s2, e));
                System.out.println("dec: " + b.substring(s2, e));
                break;
            }
            ++i2;
        }
    }

    public static void main2(String[] args) throws Exception {
        LapTimer lt = new LapTimer();
        String src = "abcabdrz";
        src = LZ77.read("data/jawiki-20120220-tail");
        int windowSize = 8192;
        System.out.println("total " + src.length() + " chars. windowSize: " + windowSize);
        StringBuilder dest1 = new StringBuilder();
        lt.reset();
        LZ77.compress1(src, dest1, windowSize);
        lt.lapMillis("compress1 done.", new Object[0]);
        StringBuilder dest2 = new StringBuilder();
        lt.reset();
        LZ77.compress2(src, dest2, windowSize);
        lt.lapMillis("compress2 done.", new Object[0]);
        System.out.println(String.format("src: %d, comp1: %d(%02.1f%%)", src.length(), dest1.length(), 1.0 * (double)dest1.length() / (double)src.length() * 100.0));
        System.out.println(String.format("src: %d, comp2: %d(%02.1f%%)", src.length(), dest2.length(), 1.0 * (double)dest2.length() / (double)src.length() * 100.0));
        int i = 0;
        while (i < Math.min(dest1.length(), dest2.length())) {
            if (dest1.charAt(i) != dest2.charAt(i)) {
                System.out.println(String.format("%dth char different [%s:%s]", i, LZ77.toString(dest1.charAt(i)), LZ77.toString(dest2.charAt(i))));
                LZ77.dump(dest1, dest2);
                break;
            }
            ++i;
        }
    }

    private static String toString(char c) {
        if (c < ' ') {
            return String.format("(0x%02x)", c);
        }
        return "" + c;
    }

    private static String read(String filename) throws IOException {
        try (FileInputStream is = new FileInputStream(filename);){
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            char[] buff = new char[((InputStream)is).available() / 2];
            int i = 0;
            while (dis.available() > 0) {
                buff[i++] = dis.readChar();
            }
            String string2 = new String(buff);
            return string2;
        }
    }

    private static void dump(CharSequence ... src) {
        int n = 126;
        CharSequence[] charSequenceArray = src;
        int n2 = src.length;
        int n3 = 0;
        while (n3 < n2) {
            CharSequence s2 = charSequenceArray[n3];
            n = Math.min(n, s2.length() / 3);
            ++n3;
        }
        int ns = src.length;
        int[] sumchars = new int[ns];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < ns) {
                char start = src[j].charAt(i);
                char count2 = src[j].charAt(i + 1);
                char stopchar = src[j].charAt(i + 2);
                System.out.print(String.format("%02d:%02d  %02d:%02d:%-6s  ", i / 3, i / 3 + sumchars[j], (int)start, (int)count2, LZ77.toString(stopchar)));
                int n4 = j++;
                sumchars[n4] = sumchars[n4] + count2;
            }
            System.out.println();
            i += 3;
        }
    }

    private static void compress1(CharSequence src, Appendable out, int windowSize) throws IOException {
        int n = src.length();
        int i = 0;
        while (i < n) {
            char target = src.charAt(i);
            boolean found = false;
            int start = 0;
            int matchLen = 0;
            int nonMatchChar = 255;
            int s2 = Math.max(0, i - windowSize);
            while (s2 < i) {
                if (target == src.charAt(s2)) {
                    int len = LZ77.getMatchedLen(src, s2 + 1, i + 1, n) + 1;
                    if (len > matchLen) {
                        start = i - s2;
                        matchLen = len;
                        nonMatchChar = 255;
                        if (i + matchLen < n) {
                            nonMatchChar = src.charAt(i + matchLen);
                        }
                    }
                    found = true;
                }
                ++s2;
            }
            if (found) {
                out.append((char)start).append((char)matchLen).append((char)nonMatchChar);
                i += matchLen;
            } else {
                out.append('\u0000').append('\u0000').append(target);
            }
            ++i;
        }
    }

    private static void compress2(CharSequence src, Appendable out, int windowSize) throws IOException {
        HashMap startPoss = new HashMap();
        int n = src.length();
        int i = 0;
        while (i < n) {
            char target = src.charAt(i);
            boolean found = false;
            int start = 0;
            int matchLen = 0;
            int nonMatchChar = 255;
            LinkedList<Integer> poss = (LinkedList<Integer>)startPoss.get(Character.valueOf(target));
            if (poss != null) {
                Iterator it = poss.iterator();
                while (it.hasNext()) {
                    int s2 = (Integer)it.next();
                    if (i - s2 > windowSize) {
                        it.remove();
                        continue;
                    }
                    int len = LZ77.getMatchedLen(src, s2 + 1, i + 1, n) + 1;
                    if (len > matchLen) {
                        start = i - s2;
                        matchLen = len;
                        nonMatchChar = 255;
                        if (i + matchLen < n) {
                            nonMatchChar = src.charAt(i + matchLen);
                        }
                    }
                    found = true;
                }
                poss.add(i);
                int jn = Math.min(i + matchLen + 1, n);
                int j = i + 1;
                while (j < jn) {
                    LinkedList<Integer> p = (LinkedList<Integer>)startPoss.get(Character.valueOf(src.charAt(j)));
                    if (p == null) {
                        p = new LinkedList<Integer>();
                        startPoss.put(Character.valueOf(src.charAt(j)), p);
                    }
                    p.add(j);
                    ++j;
                }
            } else {
                poss = new LinkedList<Integer>();
                poss.add(i);
                startPoss.put(Character.valueOf(target), poss);
            }
            if (found) {
                out.append((char)start).append((char)matchLen).append((char)nonMatchChar);
                i += matchLen;
            } else {
                out.append('\u0000').append('\u0000').append(target);
            }
            ++i;
        }
    }

    private static int getMatchedLen(CharSequence src, int i1, int i2, int end) {
        int n = Math.min(i2 - i1, end - i2);
        int i = 0;
        while (i < n) {
            if (src.charAt(i1++) != src.charAt(i2++)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static void decompress(CharSequence src, StringBuilder out) {
        int n = src.length();
        int i = 0;
        while (i < n) {
            char start = src.charAt(i);
            char matchedLen = src.charAt(i + 1);
            char nonMatchChar = src.charAt(i + 2);
            if (start != '\u0000') {
                int s2 = out.length() - start;
                int e = s2 + matchedLen;
                while (s2 < e) {
                    out.append(out.charAt(s2));
                    ++s2;
                }
            }
            if (nonMatchChar != '\u00ff') {
                out.append(nonMatchChar);
            }
            i += 3;
        }
    }
}

