/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.louds;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.trie4j.AbstractTermIdTrie;
import org.trie4j.Node;
import org.trie4j.TermIdNode;
import org.trie4j.TermIdTrie;
import org.trie4j.Trie;
import org.trie4j.bv.BytesRank1OnlySuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.louds.bvtree.BvTree;
import org.trie4j.louds.bvtree.LOUDSBvTree;
import org.trie4j.patricia.PatriciaTrie;
import org.trie4j.tail.ConcatTailArrayBuilder;
import org.trie4j.tail.TailArray;
import org.trie4j.tail.TailArrayBuilder;
import org.trie4j.tail.TailCharIterator;
import org.trie4j.util.FastBitSet;
import org.trie4j.util.Pair;
import org.trie4j.util.Range;

public class TailLOUDSTrie
extends AbstractTermIdTrie
implements Externalizable,
TermIdTrie {
    private BvTree bvtree;
    private int size;
    private char[] labels;
    private TailArray tailArray;
    private SuccinctBitVector term;
    private int nodeSize;

    public TailLOUDSTrie() {
        this(new PatriciaTrie());
    }

    public TailLOUDSTrie(Trie orig) {
        this(orig, new LOUDSBvTree(orig.nodeSize()));
    }

    public TailLOUDSTrie(Trie orig, BvTree bvTree) {
        this(orig, bvTree, new ConcatTailArrayBuilder(orig.size() * 4), new NodeListener(){

            @Override
            public void listen(Node node, int id) {
            }
        });
    }

    public TailLOUDSTrie(Trie orig, BvTree bvTree, TailArrayBuilder tailArrayBuilder) {
        this(orig, bvTree, tailArrayBuilder, new NodeListener(){

            @Override
            public void listen(Node node, int id) {
            }
        });
    }

    public TailLOUDSTrie(Trie orig, TailArrayBuilder tailArrayBuilder) {
        this(orig, tailArrayBuilder, new NodeListener(){

            @Override
            public void listen(Node node, int id) {
            }
        });
    }

    public TailLOUDSTrie(Trie orig, TailArrayBuilder tailArrayBuilder, NodeListener listener) {
        this(orig, new LOUDSBvTree(orig.size()), tailArrayBuilder, listener);
    }

    public TailLOUDSTrie(Trie orig, BvTree bvTree, TailArrayBuilder tailArrayBuilder, NodeListener listener) {
        FastBitSet bs = new FastBitSet(orig.size());
        this.build(orig, bvTree, tailArrayBuilder, bs, listener);
        this.term = new BytesRank1OnlySuccinctBitVector(bs.getBytes(), bs.size());
        this.tailArray = tailArrayBuilder.build();
        this.bvtree.trimToSize();
    }

    public TailLOUDSTrie(int size2, int nodeSize, BvTree bvTree, char[] labels, TailArray tailArray, SuccinctBitVector term) {
        this.size = size2;
        this.nodeSize = nodeSize;
        this.bvtree = bvTree;
        this.labels = labels;
        this.tailArray = tailArray;
        this.term = term;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    public void setNodeSize(int nodeSize) {
        this.nodeSize = nodeSize;
    }

    @Override
    public boolean contains(String text) {
        int nodeId = 0;
        Range r = new Range();
        TailCharIterator it = this.tailArray.newIterator();
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if ((nodeId = this.getChildNode(nodeId, text.charAt(i), r)) == -1) {
                return false;
            }
            it.setOffset(this.tailArray.getIteratorOffset(nodeId));
            while (it.hasNext()) {
                if (++i == n) {
                    return false;
                }
                if (text.charAt(i) == it.next()) continue;
                return false;
            }
        }
        return this.term.get(nodeId);
    }

    public int getNodeId(String text) {
        int nodeId = 0;
        Range r = new Range();
        TailCharIterator it = this.tailArray.newIterator();
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if ((nodeId = this.getChildNode(nodeId, text.charAt(i), r)) == -1) {
                return -1;
            }
            it.setOffset(this.tailArray.getIteratorOffset(nodeId));
            while (it.hasNext()) {
                if (++i == n) {
                    return -1;
                }
                if (text.charAt(i) == it.next()) continue;
                return -1;
            }
        }
        return nodeId;
    }

    @Override
    public int getTermId(String text) {
        int nodeId = this.getNodeId(text);
        if (nodeId == -1) {
            return -1;
        }
        return this.term.get(nodeId) ? this.term.rank1(nodeId) - 1 : -1;
    }

    private void build(Trie orig, BvTree bvtree, TailArrayBuilder tailArrayBuilder, FastBitSet termBs, NodeListener listener) {
        this.bvtree = bvtree;
        this.size = orig.size();
        this.labels = new char[this.size];
        LinkedList<Node> queue = new LinkedList<Node>();
        int count2 = 0;
        if (orig.getRoot() != null) {
            queue.add(orig.getRoot());
        }
        while (!queue.isEmpty()) {
            int index;
            Node node = (Node)queue.pollFirst();
            if ((index = count2++) >= this.labels.length) {
                this.extend();
            }
            listener.listen(node, index);
            if (node.isTerminate()) {
                termBs.set(index);
            } else if (termBs.size() <= index) {
                termBs.ensureCapacity(index);
            }
            for (Node c : node.getChildren()) {
                bvtree.appendChild();
                queue.offerLast(c);
            }
            bvtree.appendSelf();
            char[] letters = node.getLetters();
            if (letters.length == 0) {
                this.labels[index] = 65535;
                tailArrayBuilder.appendEmpty(index);
                continue;
            }
            this.labels[index] = letters[0];
            if (letters.length >= 2) {
                tailArrayBuilder.append(index, letters, 1, letters.length - 1);
                continue;
            }
            tailArrayBuilder.appendEmpty(index);
        }
        this.nodeSize = count2;
    }

    public BvTree getBvTree() {
        return this.bvtree;
    }

    public void setBvtree(BvTree bvtree) {
        this.bvtree = bvtree;
    }

    public char[] getLabels() {
        return this.labels;
    }

    public TailArray getTailArray() {
        return this.tailArray;
    }

    public SuccinctBitVector getTerm() {
        return this.term;
    }

    @Override
    public TermIdNode getRoot() {
        return new LOUDSNode(0);
    }

    @Override
    public void dump(Writer writer) throws IOException {
        super.dump(writer);
        writer.write(this.bvtree.toString());
        writer.write("\nlabels: ");
        int count2 = 0;
        for (char c : this.labels) {
            writer.write(c);
            if (count2++ == 99) break;
        }
        writer.write("\n");
    }

    @Override
    public Iterable<Pair<String, Integer>> commonPrefixSearchWithTermId(String query) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        TailCharIterator tci = this.tailArray.newIterator();
        Range r = new Range();
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            int child = this.getChildNode(nodeId, chars[charsIndex], r);
            if (child == -1) {
                return ret;
            }
            tci.setOffset(this.tailArray.getIteratorOffset(child));
            while (tci.hasNext()) {
                if (charsLen <= ++charsIndex) {
                    return ret;
                }
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            if (this.term.get(child)) {
                ret.add(Pair.create(new String(chars, 0, charsIndex + 1), this.term.rank1(child) - 1));
            }
            nodeId = child;
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> predictiveSearchWithTermId(String query) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        Range r = new Range();
        TailCharIterator tci = this.tailArray.newIterator();
        String pfx = null;
        int charsIndexBack = 0;
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            charsIndexBack = charsIndex;
            int child = this.getChildNode(nodeId, chars[charsIndex], r);
            if (child == -1) {
                return ret;
            }
            tci.setOffset(this.tailArray.getIteratorOffset(child));
            while (tci.hasNext() && ++charsIndex < charsLen) {
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            nodeId = child;
        }
        pfx = new String(chars, 0, charsIndexBack);
        LinkedList<Pair<Integer, String>> queue = new LinkedList<Pair<Integer, String>>();
        queue.offerLast(Pair.create(nodeId, pfx));
        while (queue.size() > 0) {
            Pair element = (Pair)queue.pollFirst();
            int nid = (Integer)element.getFirst();
            StringBuilder b = new StringBuilder((String)element.getSecond());
            if (nid > 0) {
                b.append(this.labels[nid]);
            }
            tci.setOffset(this.tailArray.getIteratorOffset(nid));
            while (tci.hasNext()) {
                b.append(tci.next());
            }
            String letter = b.toString();
            if (this.term.get(nid)) {
                ret.add(Pair.create(letter, this.term.rank1(nid) - 1));
            }
            this.bvtree.getChildNodeIds(nid, r);
            for (int i = r.getEnd() - 1; i >= r.getStart(); --i) {
                queue.offerFirst(Pair.create(i, letter));
            }
        }
        return ret;
    }

    @Override
    public void trimToSize() {
        if (this.labels.length > this.nodeSize) {
            this.labels = Arrays.copyOf(this.labels, this.nodeSize);
        }
        this.bvtree.trimToSize();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.nodeSize);
        this.trimToSize();
        out.writeObject(this.bvtree);
        out.writeObject(this.labels);
        out.writeObject(this.tailArray);
        out.writeObject(this.term);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.nodeSize = in.readInt();
        this.bvtree = (BvTree)in.readObject();
        this.labels = (char[])in.readObject();
        this.tailArray = (TailArray)in.readObject();
        this.term = (SuccinctBitVector)in.readObject();
    }

    private int getChildNode(int nodeId, char c, Range r) {
        this.bvtree.getChildNodeIds(nodeId, r);
        int start = r.getStart();
        int end = r.getEnd();
        if (end == -1) {
            return -1;
        }
        if (end - start <= 16) {
            for (int i = start; i < end; ++i) {
                if (c != this.labels[i]) continue;
                return i;
            }
            return -1;
        }
        do {
            int i;
            int d;
            if ((d = c - this.labels[i = (start + end) / 2]) < 0) {
                end = i;
                continue;
            }
            if (d > 0) {
                if (start == i) {
                    return -1;
                }
                start = i;
                continue;
            }
            return i;
        } while (start != end);
        return -1;
    }

    private void extend() {
        int nsz = (int)((double)this.labels.length * 1.2);
        if (nsz <= this.labels.length) {
            nsz = this.labels.length * 2 + 1;
        }
        this.labels = Arrays.copyOf(this.labels, nsz);
    }

    public class LOUDSNode
    implements TermIdNode {
        private int nodeId;

        public LOUDSNode(int nodeId) {
            this.nodeId = nodeId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        @Override
        public int getTermId() {
            if (!TailLOUDSTrie.this.term.get(this.nodeId)) {
                return -1;
            }
            return TailLOUDSTrie.this.term.rank1(this.nodeId) - 1;
        }

        @Override
        public char[] getLetters() {
            int ti;
            StringBuilder b = new StringBuilder();
            char h = TailLOUDSTrie.this.labels[this.nodeId];
            if (h != '\uffff') {
                b.append(h);
            }
            if ((ti = TailLOUDSTrie.this.tailArray.getIteratorOffset(this.nodeId)) != -1) {
                TailCharIterator it = TailLOUDSTrie.this.tailArray.newIterator(ti);
                it.setOffset(ti);
                while (it.hasNext()) {
                    b.append(it.next());
                }
            }
            return b.toString().toCharArray();
        }

        @Override
        public boolean isTerminate() {
            return TailLOUDSTrie.this.term.get(this.nodeId);
        }

        @Override
        public LOUDSNode getChild(char c) {
            int nid = TailLOUDSTrie.this.getChildNode(this.nodeId, c, new Range());
            if (nid == -1) {
                return null;
            }
            return new LOUDSNode(nid);
        }

        public LOUDSNode[] getChildren() {
            Range r = new Range();
            TailLOUDSTrie.this.bvtree.getChildNodeIds(this.nodeId, r);
            LOUDSNode[] children2 = new LOUDSNode[r.getLength()];
            for (int i = r.getStart(); i < r.getEnd(); ++i) {
                children2[i - r.getStart()] = new LOUDSNode(i);
            }
            return children2;
        }
    }

    protected static interface NodeListener {
        public void listen(Node var1, int var2);
    }
}

