/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.louds;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.trie4j.Trie;
import org.trie4j.louds.TailLOUDSTrie;
import org.trie4j.patricia.TailPatriciaTrie;
import org.trie4j.tail.SBVConcatTailArrayBuilder;
import org.trie4j.test.WikipediaTitles;

public class SaveLOUDSTrie {
    public static void main(String[] args) throws Exception {
        OutputStream dos;
        ObjectOutputStream oos;
        TailPatriciaTrie trie1 = new TailPatriciaTrie();
        for (String s2 : new WikipediaTitles("data/jawiki-20120220-all-titles-in-ns0.gz")) {
            trie1.insert(s2);
        }
        System.out.println(String.valueOf(trie1.size()) + "nodes.");
        SBVConcatTailArrayBuilder tailArray = new SBVConcatTailArrayBuilder(trie1.size());
        TailLOUDSTrie trie = new TailLOUDSTrie((Trie)trie1, tailArray);
        System.out.println(String.valueOf(trie.size()) + "nodes.");
        trie.freeze();
        try (FileOutputStream os = new FileOutputStream("louds.dat");){
            oos = new ObjectOutputStream(os);
            trie.writeExternal(oos);
            oos.flush();
        }
        os = new FileOutputStream("louds-bv.dat");
        try {
            oos = new ObjectOutputStream(os);
            oos.writeObject(trie.getBvTree());
            oos.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
        os = new FileOutputStream("louds-labels.dat");
        try {
            dos = new DataOutputStream(os);
            char[] cArray = trie.getLabels();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                ((DataOutputStream)dos).writeChar(c);
                ++n2;
            }
            ((DataOutputStream)dos).flush();
        }
        finally {
            ((OutputStream)os).close();
        }
        os = new FileOutputStream("louds-tails.dat");
        try {
            dos = new ObjectOutputStream(os);
            ((ObjectOutputStream)dos).writeObject(tailArray);
            ((ObjectOutputStream)dos).flush();
        }
        finally {
            ((OutputStream)os).close();
        }
        os = new FileOutputStream("louds-tailIndex.dat");
        try {
            oos = new ObjectOutputStream(os);
            oos.writeObject(tailArray);
            oos.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
        os = new FileOutputStream("louds-term.dat");
        try {
            dos = new ObjectOutputStream(os);
            ((ObjectOutputStream)dos).writeObject(trie.getTerm());
            ((ObjectOutputStream)dos).flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

