/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.louds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.trie4j.AbstractTrieTest;
import org.trie4j.Node;
import org.trie4j.Trie;
import org.trie4j.louds.LOUDSTrie;
import org.trie4j.patricia.PatriciaTrie;

public class LOUDSTrieTest
extends AbstractTrieTest {
    protected Trie buildSecondTrie(Trie firstTrie) {
        return new LOUDSTrie(firstTrie, 65536);
    }

    @Test
    public void test() throws Exception {
        Node[] children2;
        String[] words = new String[]{"\u3053\u3093\u306b\u3061\u306f", "\u3055\u3088\u3046\u306a\u3089", "\u304a\u306f\u3088\u3046", "\u304a\u304a\u304d\u306a\u304b\u3076", "\u304a\u304a\u3084\u307e\u3056\u304d"};
        PatriciaTrie trie = new PatriciaTrie(words);
        Trie lt = this.buildSecondTrie(trie);
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            Assert.assertTrue((String)w, (boolean)lt.contains(w));
            ++n2;
        }
        Assert.assertFalse((boolean)lt.contains("\u304a\u3084\u3059\u307f\u306a\u3055\u3044"));
        StringBuilder b = new StringBuilder();
        Node[] nodeArray = children2 = lt.getRoot().getChildren();
        int n3 = children2.length;
        int n4 = 0;
        while (n4 < n3) {
            Node n5 = nodeArray[n4];
            char[] letters = n5.getLetters();
            b.append(letters[0]);
            ++n4;
        }
        Assert.assertEquals((Object)"\u304a\u3053\u3055", (Object)b.toString());
    }

    @Test
    public void test_save_load() throws Exception {
        Node[] children2;
        String[] words = new String[]{"\u3053\u3093\u306b\u3061\u306f", "\u3055\u3088\u3046\u306a\u3089", "\u304a\u306f\u3088\u3046", "\u304a\u304a\u304d\u306a\u304b\u3076", "\u304a\u304a\u3084\u307e\u3056\u304d"};
        PatriciaTrie trie = new PatriciaTrie(words);
        Trie lt = this.buildSecondTrie(trie);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(lt);
        }
        finally {
            oos.flush();
        }
        lt = (Trie)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            Assert.assertTrue((boolean)lt.contains(w));
            ++n2;
        }
        Assert.assertFalse((boolean)lt.contains("\u304a\u3084\u3059\u307f\u306a\u3055\u3044"));
        StringBuilder b = new StringBuilder();
        Node[] nodeArray = children2 = lt.getRoot().getChildren();
        int n3 = children2.length;
        int n4 = 0;
        while (n4 < n3) {
            Node n5 = nodeArray[n4];
            char[] letters = n5.getLetters();
            b.append(letters[0]);
            ++n4;
        }
        Assert.assertEquals((Object)"\u304a\u3053\u3055", (Object)b.toString());
    }
}

