/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.louds;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import org.trie4j.AbstractTrie;
import org.trie4j.Node;
import org.trie4j.Trie;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.util.Pair;

public class LOUDSTrie
extends AbstractTrie
implements Externalizable,
Trie {
    private int size;
    private int nodeSize;
    private SuccinctBitVector bv;
    private char[] labels;
    private char[][] tail;
    private BitSet term;
    private static final char[] emptyChars = new char[0];

    public LOUDSTrie() {
    }

    public LOUDSTrie(Trie orig) {
        this(orig, 65536);
    }

    public LOUDSTrie(Trie orig, int bitSize) {
        this.size = orig.size();
        this.bv = new BytesSuccinctBitVector(bitSize);
        this.labels = new char[bitSize / 2];
        this.tail = new char[bitSize / 2][];
        this.term = new BitSet(bitSize / 2);
        LinkedList<Node> queue = new LinkedList<Node>();
        int count2 = 0;
        if (orig.getRoot() != null) {
            queue.add(orig.getRoot());
        }
        while (!queue.isEmpty()) {
            int index;
            Node node = (Node)queue.pollFirst();
            if ((index = count2++) >= this.labels.length) {
                this.extend();
            }
            if (node.isTerminate()) {
                this.term.set(index);
            }
            Node[] nodeArray = node.getChildren();
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Node c = nodeArray[n2];
                this.bv.append1();
                queue.offerLast(c);
                ++n2;
            }
            this.bv.append0();
            char[] letters = node.getLetters();
            if (letters.length == 0) {
                this.labels[index] = 65535;
                this.tail[index] = emptyChars;
                continue;
            }
            this.labels[index] = letters[0];
            this.tail[index] = letters.length >= 2 ? Arrays.copyOfRange(letters, 1, letters.length) : emptyChars;
        }
        this.nodeSize = count2;
    }

    @Override
    public int size() {
        return this.size;
    }

    public SuccinctBitVector getBv() {
        return this.bv;
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public Node getRoot() {
        return new LOUDSNode(0);
    }

    @Override
    public void dump(Writer w) {
        PrintWriter writer = new PrintWriter(w);
        try {
            String bvs = this.bv.toString();
            writer.println("bitvec: " + (bvs.length() > 100 ? bvs.substring(0, 100) : bvs));
            writer.print("labels: ");
            int count2 = 0;
            char[] cArray = this.labels;
            int n = this.labels.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                writer.print(c);
                if (count2++ == 99) break;
                ++n2;
            }
            writer.println();
        }
        finally {
            writer.flush();
        }
    }

    @Override
    public boolean contains(String text) {
        int nodeId = 0;
        int n = text.length();
        int i = 0;
        while (i < n) {
            if ((nodeId = this.getChildNode(nodeId, text.charAt(i))) == -1) {
                return false;
            }
            char[] cArray = this.tail[nodeId];
            int n2 = cArray.length;
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n3];
                if (++i == n) {
                    return false;
                }
                if (text.charAt(i) != c) {
                    return false;
                }
                ++n3;
            }
            ++i;
        }
        return this.term.get(nodeId);
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        int charsIndex = 0;
        while (charsIndex < charsLen) {
            int child = this.getChildNode(nodeId, chars[charsIndex]);
            if (child == -1) {
                return ret;
            }
            char[] cArray = this.tail[child];
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (charsLen <= ++charsIndex) {
                    return ret;
                }
                if (chars[charsIndex] != c) {
                    return ret;
                }
                ++n2;
            }
            if (this.term.get(child)) {
                ret.add(new String(chars, 0, charsIndex + 1));
            }
            nodeId = child;
            ++charsIndex;
        }
        return ret;
    }

    @Override
    public Iterable<String> predictiveSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        String pfx = null;
        int charsIndexBack = 0;
        int charsIndex = 0;
        while (charsIndex < charsLen) {
            charsIndexBack = charsIndex;
            int child = this.getChildNode(nodeId, chars[charsIndex]);
            if (child == -1) {
                return ret;
            }
            char[] cArray = this.tail[child];
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (++charsIndex >= charsLen) break;
                if (chars[charsIndex] != c) {
                    return ret;
                }
                ++n2;
            }
            nodeId = child;
            ++charsIndex;
        }
        pfx = new String(chars, 0, charsIndexBack);
        LinkedList<Pair<Integer, String>> queue = new LinkedList<Pair<Integer, String>>();
        queue.offerLast(Pair.create(nodeId, pfx));
        while (queue.size() > 0) {
            Pair element = (Pair)queue.pollFirst();
            int nid = (Integer)element.getFirst();
            StringBuilder b = new StringBuilder((String)element.getSecond());
            b.append(this.labels[nid]).append(this.tail[nid]);
            String letter = b.toString();
            if (this.term.get(nid)) {
                ret.add(letter);
            }
            int s2 = this.bv.select0(nid) + 1;
            int e = this.bv.next0(s2);
            int lastNodeId = this.bv.rank1(s2) + e - s2 - 1;
            int i = e - 1;
            while (i >= s2) {
                queue.offerFirst(Pair.create(lastNodeId--, letter));
                --i;
            }
        }
        return ret;
    }

    @Override
    public void insert(String word) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void trimToSize() {
        if (this.labels.length > this.nodeSize) {
            char[] nl = new char[this.nodeSize];
            System.arraycopy(this.labels, 0, nl, 0, this.nodeSize);
            this.labels = nl;
            char[][] nt = new char[this.nodeSize][];
            System.arraycopy(this.tail, 0, nt, 0, this.nodeSize);
            this.tail = nt;
        }
        this.bv.trimToSize();
    }

    public void save(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        try {
            this.writeExternal(out);
        }
        finally {
            out.flush();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.nodeSize);
        this.trimToSize();
        out.writeObject(this.labels);
        out.writeObject(this.tail);
        out.writeObject(this.term);
        out.writeObject(this.bv);
    }

    public void load(InputStream is) throws IOException {
        try {
            this.readExternal(new ObjectInputStream(is));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.nodeSize = in.readInt();
        this.labels = (char[])in.readObject();
        this.tail = (char[][])in.readObject();
        this.term = (BitSet)in.readObject();
        this.bv = (SuccinctBitVector)in.readObject();
    }

    private int getChildNode(int nodeId, char c) {
        int start = this.bv.select0(nodeId) + 1;
        int end = this.bv.next0(start);
        if (end == -1) {
            return -1;
        }
        int pos2Id = this.bv.rank1(start) - start;
        if (end - start <= 16) {
            int i = start;
            while (i < end) {
                int index = i + pos2Id;
                int d = c - this.labels[index];
                if (d == 0) {
                    return index;
                }
                ++i;
            }
            return -1;
        }
        do {
            int i;
            int index;
            int d;
            if ((d = c - this.labels[index = (i = (start + end) / 2) + pos2Id]) < 0) {
                end = i;
                continue;
            }
            if (d > 0) {
                if (start == i) {
                    return -1;
                }
                start = i;
                continue;
            }
            return index;
        } while (start != end);
        return -1;
    }

    private void extend() {
        int nsz = (int)((double)this.labels.length * 1.2);
        char[] nl = new char[nsz];
        System.arraycopy(this.labels, 0, nl, 0, this.labels.length);
        this.labels = nl;
        char[][] nt = new char[nsz][];
        System.arraycopy(this.tail, 0, nt, 0, this.tail.length);
        this.tail = nt;
    }

    public class LOUDSNode
    implements Node {
        private int nodeId;

        public LOUDSNode(int nodeId) {
            this.nodeId = nodeId;
        }

        public int getId() {
            return this.nodeId;
        }

        @Override
        public char[] getLetters() {
            StringBuilder b = new StringBuilder();
            char h = LOUDSTrie.this.labels[this.nodeId];
            if (h != '\uffff') {
                b.append(h);
            }
            b.append(LOUDSTrie.this.tail[this.nodeId]);
            return b.toString().toCharArray();
        }

        @Override
        public boolean isTerminate() {
            return LOUDSTrie.this.term.get(this.nodeId);
        }

        @Override
        public Node getChild(char c) {
            int nid = LOUDSTrie.this.getChildNode(this.nodeId, c);
            if (nid == -1) {
                return null;
            }
            return new LOUDSNode(nid);
        }

        @Override
        public Node[] getChildren() {
            int start = 0;
            if (this.nodeId > 0) {
                start = LOUDSTrie.this.bv.select0(this.nodeId) + 1;
            }
            int end = LOUDSTrie.this.bv.next0(start);
            int ci = LOUDSTrie.this.bv.rank1(start);
            int n = end - start;
            Node[] children2 = new Node[n];
            int i = 0;
            while (i < n) {
                children2[i] = new LOUDSNode(ci + i);
                ++i;
            }
            return children2;
        }
    }
}

