/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.louds;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import org.trie4j.AbstractTrie;
import org.trie4j.Node;
import org.trie4j.Trie;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.tail.TailCharIterator;
import org.trie4j.tail.TailUtil;
import org.trie4j.tail.builder.SuffixTrieTailBuilder;
import org.trie4j.tail.builder.TailBuilder;
import org.trie4j.util.Pair;

public class InlinedTailLOUDSTrie
extends AbstractTrie
implements Externalizable,
Trie {
    private BytesSuccinctBitVector bv;
    private int size;
    private char[] labels;
    private int[] tail;
    private CharSequence tails;
    private BitSet term;
    private int nodeSize;

    public InlinedTailLOUDSTrie() {
        this.bv = new BytesSuccinctBitVector(0);
    }

    public InlinedTailLOUDSTrie(Trie orig) {
        this(orig, new SuffixTrieTailBuilder());
    }

    public InlinedTailLOUDSTrie(Trie orig, TailBuilder tb) {
        this(orig, tb, new BytesSuccinctBitVector(orig.size() * 2));
    }

    public InlinedTailLOUDSTrie(Trie orig, TailBuilder tb, BytesSuccinctBitVector bv) {
        this.bv = bv;
        this.size = orig.size();
        this.labels = new char[this.size];
        this.tail = new int[this.size];
        this.term = new BitSet(this.size);
        LinkedList<Node> queue = new LinkedList<Node>();
        int count2 = 0;
        if (orig.getRoot() != null) {
            queue.add(orig.getRoot());
        }
        while (!queue.isEmpty()) {
            int index;
            Node node = (Node)queue.pollFirst();
            if ((index = count2++) >= this.labels.length) {
                this.extend();
            }
            if (node.isTerminate()) {
                this.term.set(index);
            }
            for (Node c : node.getChildren()) {
                bv.append1();
                queue.offerLast(c);
            }
            bv.append0();
            char[] letters = node.getLetters();
            if (letters.length == 0) {
                this.labels[index] = 65535;
                this.tail[index] = -1;
                continue;
            }
            this.labels[index] = letters[0];
            if (letters.length >= 2) {
                this.tail[index] = tb.insert(letters, 1, letters.length - 1);
                continue;
            }
            this.tail[index] = -1;
        }
        this.nodeSize = count2;
        this.tails = tb.getTails();
    }

    public BytesSuccinctBitVector getBv() {
        return this.bv;
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public Node getRoot() {
        return new LOUDSNode(0);
    }

    @Override
    public void dump(Writer writer) throws IOException {
        super.dump(writer);
        String bvs = this.bv.toString();
        writer.write("bitvec: " + (bvs.length() > 100 ? bvs.substring(0, 100) : bvs));
        writer.write("\nlabels: ");
        int count2 = 0;
        for (char c : this.labels) {
            writer.write(c);
            if (count2++ == 99) break;
        }
        writer.write("\n");
    }

    @Override
    public boolean contains(String text) {
        int nodeId = 0;
        TailCharIterator it = new TailCharIterator(this.tails, -1);
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if ((nodeId = this.getChildNode(nodeId, text.charAt(i))) == -1) {
                return false;
            }
            it.setIndex(this.tail[nodeId]);
            while (it.hasNext()) {
                if (++i == n) {
                    return false;
                }
                if (text.charAt(i) == it.next()) continue;
                return false;
            }
        }
        return this.term.get(nodeId);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        TailCharIterator tci = new TailCharIterator(this.tails, -1);
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            int child = this.getChildNode(nodeId, chars[charsIndex]);
            if (child == -1) {
                return ret;
            }
            tci.setIndex(this.tail[child]);
            while (tci.hasNext()) {
                if (charsLen <= ++charsIndex) {
                    return ret;
                }
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            if (this.term.get(child)) {
                ret.add(new String(chars, 0, charsIndex + 1));
            }
            nodeId = child;
        }
        return ret;
    }

    @Override
    public Iterable<String> predictiveSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        TailCharIterator tci = new TailCharIterator(this.tails, -1);
        String pfx = null;
        int charsIndexBack = 0;
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            charsIndexBack = charsIndex;
            int child = this.getChildNode(nodeId, chars[charsIndex]);
            if (child == -1) {
                return ret;
            }
            tci.setIndex(this.tail[child]);
            while (tci.hasNext() && ++charsIndex < charsLen) {
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            nodeId = child;
        }
        pfx = new String(chars, 0, charsIndexBack);
        LinkedList<Pair<Integer, String>> queue = new LinkedList<Pair<Integer, String>>();
        queue.offerLast(Pair.create(nodeId, pfx));
        while (queue.size() > 0) {
            Pair element = (Pair)queue.pollFirst();
            int nid = (Integer)element.getFirst();
            StringBuilder b = new StringBuilder((String)element.getSecond());
            b.append(this.labels[nid]);
            tci.setIndex(this.tail[nid]);
            while (tci.hasNext()) {
                b.append(tci.next());
            }
            String letter = b.toString();
            if (this.term.get(nid)) {
                ret.add(letter);
            }
            int s2 = this.bv.select0(nid) + 1;
            int e = this.bv.next0(s2);
            int lastNodeId = this.bv.rank1(s2) + e - s2 - 1;
            for (int i = e - 1; i >= s2; --i) {
                queue.offerFirst(Pair.create(lastNodeId--, letter));
            }
        }
        return ret;
    }

    @Override
    public void insert(String word) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void trimToSize() {
        if (this.labels.length > this.nodeSize) {
            this.labels = Arrays.copyOf(this.labels, this.nodeSize);
            this.tail = Arrays.copyOf(this.tail, this.nodeSize);
        }
        this.bv.trimToSize();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.size = in.readInt();
        this.nodeSize = in.readInt();
        this.labels = new char[this.nodeSize];
        for (i = 0; i < this.nodeSize; ++i) {
            this.labels[i] = in.readChar();
        }
        this.tail = new int[this.nodeSize];
        for (i = 0; i < this.nodeSize; ++i) {
            this.tail[i] = in.readInt();
        }
        int ts = in.readInt();
        StringBuilder b = new StringBuilder(ts);
        for (int i2 = 0; i2 < ts; ++i2) {
            b.append(in.readChar());
        }
        this.tails = b;
        this.term = (BitSet)in.readObject();
        this.bv.readExternal(in);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        void var2_5;
        out.writeInt(this.size);
        out.writeInt(this.nodeSize);
        this.trimToSize();
        for (char c : this.labels) {
            out.writeChar(c);
        }
        for (int i : this.tail) {
            out.writeInt(i);
        }
        out.writeInt(this.tails.length());
        boolean bl = false;
        while (var2_5 < this.tails.length()) {
            out.writeChar(this.tails.charAt((int)var2_5));
            ++var2_5;
        }
        out.writeObject(this.term);
        this.bv.writeExternal(out);
    }

    private int getChildNode(int nodeId, char c) {
        int start = this.bv.select0(nodeId) + 1;
        int end = this.bv.next0(start);
        if (end == -1) {
            return -1;
        }
        int pos2Id = this.bv.rank1(start) - start;
        if (end - start <= 16) {
            for (int i = start; i < end; ++i) {
                int index = i + pos2Id;
                int d = c - this.labels[index];
                if (d != 0) continue;
                return index;
            }
            return -1;
        }
        do {
            int i;
            int index;
            int d;
            if ((d = c - this.labels[index = (i = (start + end) / 2) + pos2Id]) < 0) {
                end = i;
                continue;
            }
            if (d > 0) {
                if (start == i) {
                    return -1;
                }
                start = i;
                continue;
            }
            return index;
        } while (start != end);
        return -1;
    }

    private void extend() {
        int nsz = (int)((double)this.labels.length * 1.2);
        if (nsz <= this.labels.length) {
            nsz = this.labels.length * 2 + 1;
        }
        this.labels = Arrays.copyOf(this.labels, nsz);
        this.tail = Arrays.copyOf(this.tail, nsz);
    }

    public class LOUDSNode
    implements Node {
        private int nodeId;

        public LOUDSNode(int nodeId) {
            this.nodeId = nodeId;
        }

        public int getId() {
            return this.nodeId;
        }

        @Override
        public char[] getLetters() {
            int ti;
            StringBuilder b = new StringBuilder();
            char h = InlinedTailLOUDSTrie.this.labels[this.nodeId];
            if (h != '\uffff') {
                b.append(h);
            }
            if ((ti = InlinedTailLOUDSTrie.this.tail[this.nodeId]) != -1) {
                TailUtil.appendChars(InlinedTailLOUDSTrie.this.tails, ti, b);
            }
            return b.toString().toCharArray();
        }

        @Override
        public boolean isTerminate() {
            return InlinedTailLOUDSTrie.this.term.get(this.nodeId);
        }

        @Override
        public Node getChild(char c) {
            int nid = InlinedTailLOUDSTrie.this.getChildNode(this.nodeId, c);
            if (nid == -1) {
                return null;
            }
            return new LOUDSNode(nid);
        }

        @Override
        public Node[] getChildren() {
            int start = 0;
            if (this.nodeId > 0) {
                start = InlinedTailLOUDSTrie.this.bv.select0(this.nodeId) + 1;
            }
            int end = InlinedTailLOUDSTrie.this.bv.next0(start);
            int ci = InlinedTailLOUDSTrie.this.bv.rank1(start);
            int n = end - start;
            Node[] children2 = new Node[n];
            for (int i = 0; i < n; ++i) {
                children2[i] = new LOUDSNode(ci + i);
            }
            return children2;
        }
    }
}

