/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.louds;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import org.trie4j.AbstractTrie;
import org.trie4j.Node;
import org.trie4j.Trie;
import org.trie4j.bv.BitVector01Divider;
import org.trie4j.bv.BytesRank0OnlySuccinctBitVector;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.tail.ConcatTailArrayBuilder;
import org.trie4j.tail.TailArray;
import org.trie4j.tail.TailArrayBuilder;
import org.trie4j.tail.TailCharIterator;
import org.trie4j.util.Pair;

public class InlinedTailLOUDSPPTrie
extends AbstractTrie
implements Externalizable,
Trie {
    private BytesRank0OnlySuccinctBitVector r0;
    private BytesSuccinctBitVector r1;
    private int size;
    private char[] labels;
    private TailArray tailArray;
    private BitSet term;
    private int nodeSize;

    public InlinedTailLOUDSPPTrie() {
        this.tailArray = this.newTailArrayBuilder(0).build();
        this.r0 = new BytesRank0OnlySuccinctBitVector();
        this.r1 = new BytesSuccinctBitVector();
    }

    public InlinedTailLOUDSPPTrie(Trie orig) {
        this(orig, new BytesRank0OnlySuccinctBitVector(orig.size() + 1), new BytesSuccinctBitVector(orig.size() + 1));
    }

    public InlinedTailLOUDSPPTrie(Trie orig, BytesRank0OnlySuccinctBitVector r0, BytesSuccinctBitVector r1) {
        this.r0 = r0;
        this.r1 = r1;
        this.size = orig.size();
        TailArrayBuilder tailArrayBuilder = this.newTailArrayBuilder(this.size);
        this.labels = new char[this.size];
        this.term = new BitSet(this.size);
        LinkedList<Node> queue = new LinkedList<Node>();
        int count2 = 0;
        BitVector01Divider d = new BitVector01Divider(r0, r1);
        if (orig.getRoot() != null) {
            queue.add(orig.getRoot());
        }
        while (!queue.isEmpty()) {
            int index;
            Node node = (Node)queue.pollFirst();
            if ((index = count2++) >= this.labels.length) {
                this.extend();
            }
            if (node.isTerminate()) {
                this.term.set(index);
            }
            for (Node c : node.getChildren()) {
                d.append1();
                queue.offerLast(c);
            }
            d.append0();
            char[] letters = node.getLetters();
            if (letters.length == 0) {
                this.labels[index] = 65535;
                tailArrayBuilder.appendEmpty(index);
                continue;
            }
            this.labels[index] = letters[0];
            if (letters.length >= 2) {
                tailArrayBuilder.append(index, letters, 1, letters.length - 1);
                continue;
            }
            tailArrayBuilder.appendEmpty(index);
        }
        this.nodeSize = count2;
        this.tailArray = tailArrayBuilder.build();
    }

    public BytesRank0OnlySuccinctBitVector getR0() {
        return this.r0;
    }

    public BytesSuccinctBitVector getR1() {
        return this.r1;
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public Node getRoot() {
        return new LOUDSNode(0);
    }

    @Override
    public void dump(Writer writer) throws IOException {
        super.dump(writer);
        String r0s = this.r0.toString();
        writer.write("r0: " + (r0s.length() > 100 ? r0s.substring(0, 100) : r0s));
        String r1s = this.r1.toString();
        writer.write("\nr1: " + (r1s.length() > 100 ? r1s.substring(0, 100) : r1s));
        writer.write("\nlabels: ");
        int count2 = 0;
        for (char c : this.labels) {
            writer.write(c);
            if (count2++ == 99) break;
        }
        writer.write("\n");
    }

    @Override
    public boolean contains(String text) {
        int nodeId = 0;
        TailCharIterator it = this.tailArray.newIterator();
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if ((nodeId = this.getChildNode(nodeId, text.charAt(i))) == -1) {
                return false;
            }
            it.setOffset(this.tailArray.getIteratorOffset(nodeId));
            while (it.hasNext()) {
                if (++i == n) {
                    return false;
                }
                if (text.charAt(i) == it.next()) continue;
                return false;
            }
        }
        return this.term.get(nodeId);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        TailCharIterator tci = this.tailArray.newIterator();
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            int child = this.getChildNode(nodeId, chars[charsIndex]);
            if (child == -1) {
                return ret;
            }
            tci.setOffset(this.tailArray.getIteratorOffset(child));
            while (tci.hasNext()) {
                if (charsLen <= ++charsIndex) {
                    return ret;
                }
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            if (this.term.get(child)) {
                ret.add(new String(chars, 0, charsIndex + 1));
            }
            nodeId = child;
        }
        return ret;
    }

    @Override
    public Iterable<String> predictiveSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        TailCharIterator tci = this.tailArray.newIterator();
        String pfx = null;
        int charsIndexBack = 0;
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            charsIndexBack = charsIndex;
            int child = this.getChildNode(nodeId, chars[charsIndex]);
            if (child == -1) {
                return ret;
            }
            tci.setOffset(this.tailArray.getIteratorOffset(child));
            while (tci.hasNext() && ++charsIndex < charsLen) {
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            nodeId = child;
        }
        pfx = new String(chars, 0, charsIndexBack);
        LinkedList<Pair<Integer, String>> queue = new LinkedList<Pair<Integer, String>>();
        queue.offerLast(Pair.create(nodeId, pfx));
        while (queue.size() > 0) {
            Pair element = (Pair)queue.pollFirst();
            int nid = (Integer)element.getFirst();
            StringBuilder b = new StringBuilder((String)element.getSecond());
            b.append(this.labels[nid]);
            tci.setOffset(this.tailArray.getIteratorOffset(nid));
            while (tci.hasNext()) {
                b.append(tci.next());
            }
            String letter = b.toString();
            if (this.term.get(nid)) {
                ret.add(letter);
            }
            if (!this.r0.isZero(nid)) continue;
            int s2 = this.r1.select0(this.r0.rank0(nid)) + 1;
            int e = this.r1.next0(s2) + 1;
            for (int i = e - 1; i >= s2; --i) {
                queue.offerFirst(Pair.create(i, letter));
            }
        }
        return ret;
    }

    @Override
    public void insert(String word) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void trimToSize() {
        if (this.labels.length > this.nodeSize) {
            this.labels = Arrays.copyOf(this.labels, this.nodeSize);
        }
        this.r0.trimToSize();
        this.r1.trimToSize();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.nodeSize = in.readInt();
        this.labels = new char[this.nodeSize];
        for (int i = 0; i < this.nodeSize; ++i) {
            this.labels[i] = in.readChar();
        }
        this.tailArray = (TailArray)in.readObject();
        this.term = (BitSet)in.readObject();
        this.r0.readExternal(in);
        this.r1.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.nodeSize);
        this.trimToSize();
        for (char c : this.labels) {
            out.writeChar(c);
        }
        out.writeObject(this.tailArray);
        out.writeObject(this.term);
        this.r0.writeExternal(out);
        this.r1.writeExternal(out);
    }

    private int getChildNode(int nodeId, char c) {
        if (!this.r0.isZero(nodeId)) {
            return -1;
        }
        int start = this.r1.select0(this.r0.rank0(nodeId)) + 1;
        int end = this.r1.next0(start) + 1;
        if (end == -1) {
            return -1;
        }
        if (end - start <= 16) {
            for (int i = start; i < end; ++i) {
                int d = c - this.labels[i];
                if (d != 0) continue;
                return i;
            }
            return -1;
        }
        do {
            int i;
            int d;
            if ((d = c - this.labels[i = (start + end) / 2]) < 0) {
                end = i;
                continue;
            }
            if (d > 0) {
                if (start == i) {
                    return -1;
                }
                start = i;
                continue;
            }
            return i;
        } while (start != end);
        return -1;
    }

    private void extend() {
        int nsz = (int)((double)this.labels.length * 1.2);
        if (nsz <= this.labels.length) {
            nsz = this.labels.length * 2 + 1;
        }
        this.labels = Arrays.copyOf(this.labels, nsz);
    }

    protected TailArrayBuilder newTailArrayBuilder(int initialCapacity) {
        return new ConcatTailArrayBuilder(initialCapacity);
    }

    public class LOUDSNode
    implements Node {
        private int nodeId;

        public LOUDSNode(int nodeId) {
            this.nodeId = nodeId;
        }

        public int getId() {
            return this.nodeId;
        }

        @Override
        public char[] getLetters() {
            int ti;
            StringBuilder b = new StringBuilder();
            char h = InlinedTailLOUDSPPTrie.this.labels[this.nodeId];
            if (h != '\uffff') {
                b.append(h);
            }
            if ((ti = InlinedTailLOUDSPPTrie.this.tailArray.getIteratorOffset(this.nodeId)) != -1) {
                TailCharIterator it = InlinedTailLOUDSPPTrie.this.tailArray.newIterator();
                it.setOffset(ti);
                while (it.hasNext()) {
                    b.append(it.next());
                }
            }
            return b.toString().toCharArray();
        }

        @Override
        public boolean isTerminate() {
            return InlinedTailLOUDSPPTrie.this.term.get(this.nodeId);
        }

        @Override
        public Node getChild(char c) {
            int nid = InlinedTailLOUDSPPTrie.this.getChildNode(this.nodeId, c);
            if (nid == -1) {
                return null;
            }
            return new LOUDSNode(nid);
        }

        @Override
        public Node[] getChildren() {
            if (!InlinedTailLOUDSPPTrie.this.r0.isZero(this.nodeId)) {
                return new Node[0];
            }
            int start = InlinedTailLOUDSPPTrie.this.r1.select0(InlinedTailLOUDSPPTrie.this.r0.rank0(this.nodeId)) + 1;
            int end = InlinedTailLOUDSPPTrie.this.r1.next0(start) + 1;
            Node[] children2 = new Node[end - start];
            for (int i = start; i < end; ++i) {
                children2[i - start] = new LOUDSNode(i);
            }
            return children2;
        }
    }
}

