/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.doublearray;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.trie4j.AbstractTrie;
import org.trie4j.Node;
import org.trie4j.Trie;
import org.trie4j.tail.TailCharIterator;
import org.trie4j.tail.builder.SuffixTrieTailBuilder;
import org.trie4j.tail.builder.TailBuilder;
import org.trie4j.util.Pair;

public class OptimizedTailDoubleArray
extends AbstractTrie
implements Trie {
    private static final int BASE_EMPTY = Integer.MAX_VALUE;
    private int size;
    private int nodeSize;
    private int[] base;
    private short[] check;
    private int[] tail;
    private int last;
    private BitSet term;
    private CharSequence tails;
    private Map<Character, Integer> charCodes = new TreeMap<Character, Integer>(new Comparator<Character>(){

        @Override
        public int compare(Character arg0, Character arg1) {
            return arg1.charValue() - arg0.charValue();
        }
    });

    public OptimizedTailDoubleArray() {
    }

    public OptimizedTailDoubleArray(Trie trie) {
        this(trie, 65536);
    }

    public OptimizedTailDoubleArray(Trie trie, int arraySize) {
        this(trie, arraySize, new SuffixTrieTailBuilder());
    }

    public OptimizedTailDoubleArray(Trie trie, int arraySize, TailBuilder tb) {
        int nodeIndex;
        this.size = trie.size();
        this.nodeSize = trie.nodeSize();
        this.base = new int[arraySize];
        Arrays.fill(this.base, Integer.MAX_VALUE);
        this.check = new short[arraySize];
        Arrays.fill(this.check, (short)-1);
        this.tail = new int[arraySize];
        Arrays.fill(this.tail, -1);
        this.term = new BitSet(65536);
        this.base[0] = nodeIndex = 0;
        Node root = trie.getRoot();
        if (root == null) {
            return;
        }
        if (root.getLetters() != null) {
            if (root.getLetters().length == 0) {
                if (root.isTerminate()) {
                    this.term.set(0);
                }
            } else {
                int c = this.getCharId(root.getLetters()[0]);
                this.check[c] = (short)c;
                nodeIndex = c;
            }
        }
        this.build(root, nodeIndex, tb);
        this.tails = tb.getTails();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public Node getRoot() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(String text) {
        char[] chars = text.toCharArray();
        int charsIndex = 0;
        int nodeIndex = 0;
        TailCharIterator it = new TailCharIterator(this.tails, -1);
        while (charsIndex < chars.length) {
            int cid;
            int tailIndex = this.tail[nodeIndex];
            if (tailIndex != -1) {
                it.setIndex(tailIndex);
                while (it.hasNext()) {
                    if (chars.length <= charsIndex) {
                        return false;
                    }
                    if (chars[charsIndex] != it.next()) {
                        return false;
                    }
                    ++charsIndex;
                }
                if (chars.length == charsIndex) {
                    if (!it.hasNext()) {
                        return this.term.get(nodeIndex);
                    }
                    return false;
                }
            }
            if ((cid = this.findCharId(chars[charsIndex])) == -1) {
                return false;
            }
            int i = cid + this.base[nodeIndex];
            if (i < 0 || this.check.length <= i || i + this.check[i] != nodeIndex) {
                return false;
            }
            ++charsIndex;
            nodeIndex = i;
        }
        return this.term.get(nodeIndex);
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        TailCharIterator it;
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int ci = 0;
        int ni = 0;
        if (this.tail[0] != -1) {
            it = new TailCharIterator(this.tails, this.tail[0]);
            while (it.hasNext()) {
                if (++ci >= chars.length) {
                    return ret;
                }
                if (it.next() == chars[ci]) continue;
                return ret;
            }
            if (this.term.get(0)) {
                ret.add(new String(chars, 0, ci + 1));
            }
        }
        it = new TailCharIterator(this.tails, -1);
        while (ci < chars.length) {
            int cid = this.findCharId(chars[ci]);
            if (cid == -1) {
                return ret;
            }
            int b = this.base[ni];
            if (b == Integer.MAX_VALUE) {
                return ret;
            }
            if (b == 0x7FFFFFFE) {
                return ret;
            }
            int next2 = b + cid;
            if (this.check.length <= next2 || next2 + this.check[next2] != ni) {
                return ret;
            }
            ni = next2;
            if (this.tail[ni] != -1) {
                it.setIndex(this.tail[ni]);
                while (it.hasNext()) {
                    if (++ci >= chars.length) {
                        return ret;
                    }
                    if (it.next() == chars[ci]) continue;
                    return ret;
                }
            }
            if (this.term.get(ni)) {
                ret.add(new String(chars, 0, ci + 1));
            }
            ++ci;
        }
        return ret;
    }

    @Override
    public Iterable<String> predictiveSearch(String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        char[] chars = prefix.toCharArray();
        int nodeIndex = 0;
        TailCharIterator it = new TailCharIterator(this.tails, -1);
        int i = 0;
        while (i < chars.length) {
            int cid;
            int ti = this.tail[nodeIndex];
            if (ti != -1) {
                int first = i;
                it.setIndex(ti);
                while (it.hasNext()) {
                    if (it.next() != chars[i]) {
                        return ret;
                    }
                    if (++i < chars.length) continue;
                }
                if (i >= chars.length) break;
                current.append(chars, first, i - first);
            }
            if ((cid = this.findCharId(chars[i])) == -1) {
                return ret;
            }
            int next2 = this.base[nodeIndex] + cid;
            if (next2 < 0 || this.check.length <= next2 || next2 + this.check[next2] != nodeIndex) {
                return ret;
            }
            nodeIndex = next2;
            current.append(chars[i]);
            ++i;
        }
        LinkedList<Pair<Integer, char[]>> q = new LinkedList<Pair<Integer, char[]>>();
        q.add(Pair.create(nodeIndex, current.toString().toCharArray()));
        while (!q.isEmpty()) {
            Pair p = (Pair)q.pop();
            int ni = (Integer)p.getFirst();
            StringBuilder buff = new StringBuilder().append((char[])p.getSecond());
            int ti = this.tail[ni];
            if (ti != -1) {
                it.setIndex(ti);
                while (it.hasNext()) {
                    buff.append(it.next());
                }
            }
            if (this.term.get(ni)) {
                ret.add(buff.toString());
            }
            for (Map.Entry<Character, Integer> e : this.charCodes.entrySet()) {
                int next3;
                int b = this.base[ni];
                if (b == Integer.MAX_VALUE || b == 0x7FFFFFFE || this.check.length <= (next3 = b + e.getValue()) || next3 + this.check[next3] != ni) continue;
                StringBuilder bu = new StringBuilder(buff);
                bu.append(e.getKey());
                q.push(Pair.create(next3, bu.toString().toCharArray()));
            }
        }
        return ret;
    }

    @Override
    public void insert(String word) {
        throw new UnsupportedOperationException();
    }

    public void save(OutputStream os) throws IOException {
        int v;
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(this.size);
        dos.writeInt(this.nodeSize);
        dos.writeInt(this.base.length);
        Object[] objectArray = this.base;
        int n = this.base.length;
        int n2 = 0;
        while (n2 < n) {
            v = objectArray[n2];
            dos.writeInt(v);
            ++n2;
        }
        objectArray = this.check;
        n = this.check.length;
        n2 = 0;
        while (n2 < n) {
            v = objectArray[n2];
            dos.writeShort(v);
            ++n2;
        }
        objectArray = this.tail;
        n = this.tail.length;
        n2 = 0;
        while (n2 < n) {
            v = objectArray[n2];
            dos.writeInt(v);
            ++n2;
        }
        dos.flush();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this.term);
        oos.flush();
        dos.writeInt(this.tails.length());
        dos.writeChars(this.tails.toString());
        dos.writeInt(this.charCodes.size());
        for (Map.Entry<Character, Integer> e : this.charCodes.entrySet()) {
            dos.writeChar(e.getKey().charValue());
            dos.writeInt(e.getValue());
        }
        dos.flush();
        bos.flush();
    }

    public void load(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        this.size = dis.readInt();
        this.nodeSize = dis.readInt();
        int len = dis.readInt();
        this.base = new int[len];
        int i = 0;
        while (i < len) {
            this.base[i] = dis.readInt();
            ++i;
        }
        this.check = new short[len];
        i = 0;
        while (i < len) {
            this.check[i] = dis.readShort();
            ++i;
        }
        this.tail = new int[len];
        i = 0;
        while (i < len) {
            this.tail[i] = dis.readInt();
            ++i;
        }
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            this.term = (BitSet)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        int n = dis.readInt();
        StringBuilder b = new StringBuilder(n);
        int i2 = 0;
        while (i2 < n) {
            b.append(dis.readChar());
            ++i2;
        }
        this.tails = b;
        n = dis.readInt();
        i2 = 0;
        while (i2 < n) {
            char c = dis.readChar();
            int v = dis.readInt();
            this.charCodes.put(Character.valueOf(c), v);
            ++i2;
        }
    }

    public void dump() {
        System.out.println("array size: " + this.base.length);
        System.out.println("last index of valid element: " + this.last);
        int vc = 0;
        int i = 0;
        while (i < this.base.length) {
            if (this.base[i] != Integer.MAX_VALUE || this.check[i] >= 0) {
                ++vc;
            }
            ++i;
        }
        System.out.println("valid elements: " + vc);
        System.out.print("      |");
        i = 0;
        while (i < 16) {
            System.out.print(String.format("%3d|", i));
            ++i;
        }
        System.out.println();
        System.out.print("|base |");
        i = 0;
        while (i < 16) {
            if (this.base[i] == Integer.MAX_VALUE) {
                System.out.print("N/A|");
            } else {
                System.out.print(String.format("%3d|", this.base[i]));
            }
            ++i;
        }
        System.out.println();
        System.out.print("|check|");
        i = 0;
        while (i < 16) {
            System.out.print(String.format("%3d|", this.check[i]));
            ++i;
        }
        System.out.println();
        System.out.print("|tail |");
        i = 0;
        while (i < 16) {
            if (this.tail[i] < 0) {
                System.out.print("N/A|");
            } else {
                System.out.print(String.format("%3d|", this.tail[i]));
            }
            ++i;
        }
        System.out.println();
        System.out.print("|term |");
        i = 0;
        while (i < 16) {
            System.out.print(String.format("%3d|", this.term.get(i) ? 1 : 0));
            ++i;
        }
        System.out.println();
        int count2 = 0;
        int[] nArray = this.tail;
        int n = this.tail.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray[n2];
            if (i2 != -1) {
                ++count2;
            }
            ++n2;
        }
        System.out.println("tail count: " + count2);
        System.out.println();
        System.out.print("tails: [");
        char[] tailChars = this.tails.subSequence(0, Math.min(this.tails.length(), 64)).toString().toCharArray();
        int i3 = 0;
        while (i3 < tailChars.length) {
            char c = tailChars[i3];
            if (c == '\u0000') {
                System.out.print("\\0");
            } else if (c == '\u0001') {
                int index = tailChars[i3 + 1] + (tailChars[i3 + 2] << 16);
                i3 += 2;
                System.out.print(String.format("\\1(%d)", index));
            } else {
                System.out.print(c);
            }
            ++i3;
        }
        System.out.println("]");
        System.out.println("tailBuf size: " + this.tails.length());
        System.out.print("chars: ");
        int c = 0;
        for (Map.Entry<Character, Integer> e : this.charCodes.entrySet()) {
            System.out.print(String.format("%c:%d,", e.getKey(), e.getValue()));
            if (++c > 16) break;
        }
        System.out.println();
        System.out.println("chars count: " + this.charCodes.size());
        System.out.println("calculating max and min base.");
        int min2 = Integer.MAX_VALUE;
        int max2 = Integer.MIN_VALUE;
        int maxDelta = Integer.MIN_VALUE;
        int i4 = 0;
        while (i4 < this.base.length) {
            int b = this.base[i4];
            if (b != Integer.MAX_VALUE) {
                min2 = Math.min(min2, b);
                max2 = Math.max(max2, b);
                maxDelta = Math.max(maxDelta, Math.abs(i4 - b));
            }
            ++i4;
        }
        System.out.println("maxDelta: " + maxDelta);
        System.out.println("max: " + max2);
        System.out.println("min: " + min2);
        System.out.println("calculating min check.");
        min2 = Integer.MAX_VALUE;
        int i5 = 0;
        while (i5 < this.base.length) {
            short b = this.check[i5];
            if (b != Integer.MAX_VALUE) {
                min2 = Math.min(min2, b);
            }
            ++i5;
        }
        System.out.println("min: " + min2);
        System.out.println();
    }

    @Override
    public void trimToSize() {
        int sz = this.last + 1;
        int[] nb = new int[sz];
        System.arraycopy(this.base, 0, nb, 0, sz);
        this.base = nb;
        short[] nc = new short[sz];
        System.arraycopy(this.check, 0, nc, 0, sz);
        this.check = nc;
        int[] nt = new int[sz];
        System.arraycopy(this.tail, 0, nt, 0, sz);
        this.tail = nt;
        if (this.tails instanceof StringBuilder) {
            ((StringBuilder)this.tails).trimToSize();
        }
    }

    private void build(Node node, int nodeIndex, TailBuilder tb) {
        int cid;
        int n;
        Object object;
        Node[] children2;
        char[] letters = node.getLetters();
        if (letters != null) {
            if (letters.length > 1) {
                int tailIndex;
                this.tail[nodeIndex] = tailIndex = tb.insert(letters, 1, letters.length - 1);
            }
            if (node.isTerminate()) {
                this.term.set(nodeIndex);
            }
        }
        if ((children2 = node.getChildren()) == null || children2.length == 0) {
            return;
        }
        int[] heads = new int[children2.length];
        int maxHead = 0;
        int minHead = Integer.MAX_VALUE;
        int i = 0;
        while (i < children2.length) {
            heads[i] = this.getCharId(children2[i].getLetters()[0]);
            maxHead = Math.max(maxHead, heads[i]);
            minHead = Math.min(minHead, heads[i]);
            ++i;
        }
        int empty = this.findFirstEmptyCheck(nodeIndex);
        int offset = empty - minHead;
        while (true) {
            if (this.check.length <= offset + maxHead) {
                this.extend(offset + maxHead);
            }
            boolean found = true;
            object = heads;
            int n2 = heads.length;
            n = 0;
            while (n < n2) {
                cid = object[n];
                if (this.check[offset + cid] >= 0) {
                    found = false;
                    break;
                }
                ++n;
            }
            if (found) break;
            empty = this.findNextEmptyCheck(nodeIndex, empty);
            offset = empty - minHead;
        }
        this.base[nodeIndex] = offset;
        int[] nArray = heads;
        n = heads.length;
        cid = 0;
        while (cid < n) {
            int cid2 = nArray[cid];
            if (cid2 > Short.MAX_VALUE) {
                throw new RuntimeException("check value overflow");
            }
            this.setCheck(offset + cid2, (short)(nodeIndex - (offset + cid2)));
            ++cid;
        }
        TreeMap<Integer, ArrayList<Pair<Node, Integer>>> nodes = new TreeMap<Integer, ArrayList<Pair<Node, Integer>>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg1 - arg0;
            }
        });
        int i2 = 0;
        while (i2 < children2.length) {
            ArrayList<Pair<Node, Integer>> p;
            Node[] c = children2[i2].getChildren();
            int n3 = 0;
            if (c != null) {
                n3 = c.length;
            }
            if ((p = (ArrayList<Pair<Node, Integer>>)nodes.get(n3)) == null) {
                p = new ArrayList<Pair<Node, Integer>>();
                nodes.put(n3, p);
            }
            p.add(Pair.create(children2[i2], heads[i2]));
            ++i2;
        }
        for (Map.Entry e : nodes.entrySet()) {
            object = ((List)e.getValue()).iterator();
            while (object.hasNext()) {
                Pair e2 = (Pair)object.next();
                this.build((Node)e2.getFirst(), (Integer)e2.getSecond() + offset, tb);
            }
        }
    }

    private int getCharId(char c) {
        Integer cid = this.charCodes.get(Character.valueOf(c));
        if (cid == null) {
            cid = this.charCodes.size() + 1;
            if (cid > Short.MAX_VALUE) {
                throw new RuntimeException("too many kinds of character(max: 32767).");
            }
            this.charCodes.put(Character.valueOf(c), cid);
        }
        return cid;
    }

    private int findCharId(char c) {
        Integer cid = this.charCodes.get(Character.valueOf(c));
        if (cid == null) {
            return -1;
        }
        return cid;
    }

    private void extend(int i) {
        int sz = this.base.length;
        int nsz = Math.max(i, (int)((double)sz * 1.5));
        int[] nb = new int[nsz];
        System.arraycopy(this.base, 0, nb, 0, sz);
        Arrays.fill(nb, sz, nsz, Integer.MAX_VALUE);
        this.base = nb;
        short[] nc = new short[nsz];
        System.arraycopy(this.check, 0, nc, 0, sz);
        Arrays.fill(nc, sz, nsz, (short)-1);
        this.check = nc;
        int[] nt = new int[nsz];
        System.arraycopy(this.tail, 0, nt, 0, sz);
        Arrays.fill(nt, sz, nsz, -1);
        this.tail = nt;
    }

    private int findFirstEmptyCheck(int baseNodeIndex) {
        int i = Math.max(baseNodeIndex - Short.MAX_VALUE, 0);
        while (this.check[i] >= 0 || this.base[i] != Integer.MAX_VALUE) {
            ++i;
        }
        return i;
    }

    private int findNextEmptyCheck(int baseNodeIndex, int i) {
        int d = this.check[i] * -1;
        if (d <= 0) {
            throw new RuntimeException();
        }
        int prev = i;
        if (this.check.length <= (i += d)) {
            this.extend(i);
            return i;
        }
        if (this.check[i] < 0) {
            return i;
        }
        ++i;
        while (i < this.check.length) {
            if (this.check[i] < 0 && this.base[i] == Integer.MAX_VALUE) {
                int v = baseNodeIndex - i;
                if (v < Short.MIN_VALUE) {
                    throw new RuntimeException("check value overflow");
                }
                this.check[prev] = (short)v;
                return i;
            }
            ++i;
        }
        this.extend(i);
        int v = prev - i;
        if (v < Short.MIN_VALUE) {
            throw new RuntimeException("check value overflow");
        }
        this.check[prev] = (short)v;
        return i;
    }

    private void setCheck(int index, short value) {
        this.check[index] = value;
        this.last = Math.max(this.last, index);
        if (this.base[index] == Integer.MAX_VALUE) {
            int n = index;
            this.base[n] = this.base[n] - 1;
        }
    }
}

