/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.doublearray;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.trie4j.AbstractTermIdTrie;
import org.trie4j.Node;
import org.trie4j.TermIdNode;
import org.trie4j.TermIdTrie;
import org.trie4j.Trie;
import org.trie4j.bv.BytesRank1OnlySuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.util.BitSet;
import org.trie4j.util.FastBitSet;
import org.trie4j.util.Pair;

public class DoubleArray
extends AbstractTermIdTrie
implements Externalizable,
TermIdTrie {
    private int size;
    private int nodeSize;
    private int[] base;
    private int[] check;
    private int firstEmptyCheck = 1;
    private int last;
    private SuccinctBitVector term;
    private Set<Character> chars = new TreeSet<Character>();
    private char[] charToCode = new char[65535];
    private static final int BASE_EMPTY = Integer.MAX_VALUE;
    private static final DoubleArrayNode[] emptyNodes = new DoubleArrayNode[0];

    public DoubleArray() {
    }

    public DoubleArray(Trie trie) {
        this(trie, trie.size() * 2);
    }

    public DoubleArray(Trie trie, int arraySize) {
        this(trie, arraySize, new TermNodeListener(){

            @Override
            public void listen(Node node, int nodeIndex) {
            }
        });
    }

    public DoubleArray(Trie trie, int arraySize, TermNodeListener listener) {
        if (arraySize <= 1) {
            arraySize = 2;
        }
        this.size = trie.size();
        this.nodeSize = trie.nodeSize();
        this.base = new int[arraySize];
        Arrays.fill(this.base, Integer.MAX_VALUE);
        this.check = new int[arraySize];
        Arrays.fill(this.check, -1);
        FastBitSet bs = new FastBitSet(arraySize);
        this.build(trie.getRoot(), 0, bs, listener);
        this.term = new BytesRank1OnlySuccinctBitVector(bs.getBytes(), bs.size());
        this.base = Arrays.copyOf(this.base, this.last + 1);
        this.check = Arrays.copyOf(this.check, this.last + 1);
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public TermIdNode getRoot() {
        return this.newDoubleArrayNode(0);
    }

    public int[] getBase() {
        return this.base;
    }

    public int[] getCheck() {
        return this.check;
    }

    public BitSet getTerm() {
        return this.term;
    }

    @Override
    public boolean contains(String text) {
        int nodeIndex = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char cid = this.charToCode[text.charAt(i)];
            if (cid == '\u0000') {
                return false;
            }
            int next2 = this.base[nodeIndex] + cid;
            if (next2 < 0 || this.check[next2] != nodeIndex) {
                return false;
            }
            nodeIndex = next2;
        }
        return this.term.get(nodeIndex);
    }

    public int getNodeId(String text) {
        int nodeIndex = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char cid = this.charToCode[text.charAt(i)];
            if (cid == '\u0000') {
                return -1;
            }
            int next2 = this.base[nodeIndex] + cid;
            if (next2 < 0 || this.check[next2] != nodeIndex) {
                return -1;
            }
            nodeIndex = next2;
        }
        return nodeIndex;
    }

    @Override
    public int getTermId(String text) {
        int nid = this.getNodeId(text);
        return this.term.get(nid) ? this.term.rank1(nid) - 1 : -1;
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int checkLen = this.check.length;
        int nodeIndex = 0;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharId(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int b = this.base[nodeIndex];
            if (b == Integer.MAX_VALUE) {
                return ret;
            }
            int next2 = b + cid;
            if (next2 >= checkLen || this.check[next2] != nodeIndex) {
                return ret;
            }
            nodeIndex = next2;
            if (!this.term.get(nodeIndex)) continue;
            ret.add(new String(chars, 0, i + 1));
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> commonPrefixSearchWithTermId(String query) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int checkLen = this.check.length;
        int nodeIndex = 0;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharId(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int b = this.base[nodeIndex];
            if (b == Integer.MAX_VALUE) {
                return ret;
            }
            int next2 = b + cid;
            if (next2 >= checkLen || this.check[next2] != nodeIndex) {
                return ret;
            }
            nodeIndex = next2;
            if (!this.term.get(nodeIndex)) continue;
            ret.add(Pair.create(new String(chars, 0, i + 1), this.term.rank1(nodeIndex) - 1));
        }
        return ret;
    }

    @Override
    public int findWord(CharSequence chars, int start, int end, StringBuilder word) {
        for (int i = start; i < end; ++i) {
            int nodeIndex = 0;
            try {
                int next2;
                int b;
                int cid;
                for (int j = i; j < end && (cid = this.findCharId(chars.charAt(j))) != -1 && (b = this.base[nodeIndex]) != Integer.MAX_VALUE && nodeIndex == this.check[next2 = b + cid]; ++j) {
                    nodeIndex = next2;
                    if (!this.term.get(nodeIndex)) continue;
                    if (word != null) {
                        word.append(chars, i, j + 1);
                    }
                    return i;
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
        }
        return -1;
    }

    @Override
    public Iterable<String> predictiveSearch(String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = prefix.toCharArray();
        int charsLen = chars.length;
        int checkLen = this.check.length;
        int nodeIndex = 0;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharId(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int next2 = this.base[nodeIndex] + cid;
            if (next2 < 0 || next2 >= checkLen || this.check[next2] != nodeIndex) {
                return ret;
            }
            nodeIndex = next2;
        }
        if (this.term.get(nodeIndex)) {
            ret.add(prefix);
        }
        LinkedList<Pair<Integer, String>> q = new LinkedList<Pair<Integer, String>>();
        q.add(Pair.create(nodeIndex, prefix));
        while (!q.isEmpty()) {
            Pair p = (Pair)q.pop();
            int ni = (Integer)p.getFirst();
            int b = this.base[ni];
            if (b == Integer.MAX_VALUE) continue;
            String c = (String)p.getSecond();
            for (char v : this.chars) {
                int next3 = b + this.charToCode[v];
                if (next3 < 0 || next3 >= checkLen || this.check[next3] != ni) continue;
                String n = c + v;
                if (this.term.get(next3)) {
                    ret.add(n);
                }
                q.push(Pair.create(next3, n));
            }
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> predictiveSearchWithTermId(String prefix) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = prefix.toCharArray();
        int charsLen = chars.length;
        if (charsLen == 0) {
            return ret;
        }
        if (this.nodeSize == 0) {
            return ret;
        }
        int checkLen = this.check.length;
        int nodeIndex = 0;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharId(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int next2 = this.base[nodeIndex] + cid;
            if (next2 < 0 || next2 >= checkLen || this.check[next2] != nodeIndex) {
                return ret;
            }
            nodeIndex = next2;
        }
        if (this.term.get(nodeIndex)) {
            ret.add(Pair.create(prefix, this.term.rank1(nodeIndex) - 1));
        }
        LinkedList<Pair<Integer, String>> q = new LinkedList<Pair<Integer, String>>();
        q.add(Pair.create(nodeIndex, prefix));
        while (!q.isEmpty()) {
            Pair p = (Pair)q.pop();
            int ni = (Integer)p.getFirst();
            int b = this.base[ni];
            if (b == Integer.MAX_VALUE) continue;
            String c = (String)p.getSecond();
            for (char v : this.chars) {
                int next3 = b + this.charToCode[v];
                if (next3 < 0 || next3 >= checkLen || this.check[next3] != ni) continue;
                String n = c + v;
                if (this.term.get(next3)) {
                    ret.add(Pair.create(n, this.term.rank1(next3) - 1));
                }
                q.push(Pair.create(next3, n));
            }
        }
        return ret;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.nodeSize);
        out.writeInt(this.base.length);
        for (int v : this.base) {
            out.writeInt(v);
        }
        for (int v : this.check) {
            out.writeInt(v);
        }
        out.writeObject(this.term);
        out.writeInt(this.firstEmptyCheck);
        out.writeInt(this.chars.size());
        Object object = this.chars.iterator();
        while (object.hasNext()) {
            char c = ((Character)object.next()).charValue();
            out.writeChar(c);
            out.writeChar(this.charToCode[c]);
        }
    }

    public void save(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        try {
            this.writeExternal(out);
        }
        finally {
            out.flush();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.size = in.readInt();
        this.nodeSize = in.readInt();
        int len = in.readInt();
        this.base = new int[len];
        for (i = 0; i < len; ++i) {
            this.base[i] = in.readInt();
        }
        this.check = new int[len];
        for (i = 0; i < len; ++i) {
            this.check[i] = in.readInt();
        }
        try {
            this.term = (SuccinctBitVector)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.firstEmptyCheck = in.readInt();
        int n = in.readInt();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = in.readChar();
            char v = in.readChar();
            this.chars.add(Character.valueOf(c));
            this.charToCode[c] = v;
        }
    }

    public void load(InputStream is) throws IOException {
        try {
            this.readExternal(new ObjectInputStream(is));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void trimToSize() {
        int sz = this.last + 1 + 65535;
        this.base = Arrays.copyOf(this.base, sz);
        this.check = Arrays.copyOf(this.check, sz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Writer w) {
        PrintWriter writer = new PrintWriter(w);
        try {
            int i;
            writer.println("array size: " + this.base.length);
            writer.print("      |");
            for (i = 0; i < 16; ++i) {
                writer.print(String.format("%3d|", i));
            }
            writer.println();
            writer.print("|base |");
            for (i = 0; i < 16; ++i) {
                if (this.base[i] == Integer.MAX_VALUE) {
                    writer.print("N/A|");
                    continue;
                }
                writer.print(String.format("%3d|", this.base[i]));
            }
            writer.println();
            writer.print("|check|");
            for (i = 0; i < 16; ++i) {
                if (this.check[i] < 0) {
                    writer.print("N/A|");
                    continue;
                }
                writer.print(String.format("%3d|", this.check[i]));
            }
            writer.println();
            writer.print("|term |");
            for (i = 0; i < 16; ++i) {
                writer.print(String.format("%3d|", this.term.get(i) ? 1 : 0));
            }
            writer.println();
            writer.print("chars: ");
            int c = 0;
            for (char e : this.chars) {
                writer.print(String.format("%c:%d,", Character.valueOf(e), (int)this.charToCode[e]));
                if (++c <= 16) continue;
                break;
            }
            writer.println();
            writer.println("chars count: " + this.chars.size());
            writer.println();
        }
        finally {
            writer.flush();
        }
    }

    private void build(Node node, int nodeIndex, FastBitSet bs, TermNodeListener listener) {
        int offset;
        char[] letters = node.getLetters();
        int lettersLen = letters.length;
        for (int i = 1; i < lettersLen; ++i) {
            bs.unsetIfLE(nodeIndex);
            int cid = this.getCharId(letters[i]);
            int empty = this.findFirstEmptyCheck();
            this.setCheck(empty, nodeIndex);
            this.base[nodeIndex] = empty - cid;
            nodeIndex = empty;
        }
        if (node.isTerminate()) {
            bs.set(nodeIndex);
            listener.listen(node, nodeIndex);
        } else {
            bs.unsetIfLE(nodeIndex);
        }
        Node[] children2 = node.getChildren();
        int childrenLen = children2.length;
        if (childrenLen == 0) {
            return;
        }
        int[] heads = new int[childrenLen];
        int maxHead = 0;
        int minHead = Integer.MAX_VALUE;
        for (int i = 0; i < childrenLen; ++i) {
            heads[i] = this.getCharId(children2[i].getLetters()[0]);
            maxHead = Math.max(maxHead, heads[i]);
            minHead = Math.min(minHead, heads[i]);
        }
        this.base[nodeIndex] = offset = this.findInsertOffset(heads, minHead, maxHead);
        for (int cid : heads) {
            this.setCheck(offset + cid, nodeIndex);
        }
        TreeMap<Integer, ArrayList<Pair<Node, Integer>>> nodes = new TreeMap<Integer, ArrayList<Pair<Node, Integer>>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg1 - arg0;
            }
        });
        for (int i = 0; i < children2.length; ++i) {
            ArrayList<Pair<Node, Integer>> p;
            Node[] c = children2[i].getChildren();
            int n = 0;
            if (c != null) {
                n = c.length;
            }
            if ((p = (ArrayList<Pair<Node, Integer>>)nodes.get(n)) == null) {
                p = new ArrayList<Pair<Node, Integer>>();
                nodes.put(n, p);
            }
            p.add(Pair.create(children2[i], heads[i]));
        }
        for (Map.Entry e : nodes.entrySet()) {
            for (Pair e2 : (List)e.getValue()) {
                this.build((Node)e2.getFirst(), (Integer)e2.getSecond() + offset, bs, listener);
            }
        }
    }

    private DoubleArrayNode newDoubleArrayNode(int id) {
        return new DoubleArrayNode(id);
    }

    private DoubleArrayNode newDoubleArrayNode(int id, char s2) {
        return new DoubleArrayNode(id, s2);
    }

    private int findCharId(char c) {
        char v = this.charToCode[c];
        if (v != '\u0000') {
            return v;
        }
        return -1;
    }

    private int findInsertOffset(int[] heads, int minHead, int maxHead) {
        int empty = this.findFirstEmptyCheck();
        while (true) {
            int offset;
            if ((offset = empty - minHead) + maxHead >= this.check.length) {
                this.extend(offset + maxHead);
            }
            boolean found = true;
            for (int cid : heads) {
                if (this.check[offset + cid] < 0) continue;
                found = false;
                break;
            }
            if (found) {
                return offset;
            }
            empty = this.findNextEmptyCheck(empty);
        }
    }

    private int getCharId(char c) {
        char v = this.charToCode[c];
        if (v != '\u0000') {
            return v;
        }
        v = (char)(this.chars.size() + 1);
        this.chars.add(Character.valueOf(c));
        this.charToCode[c] = v;
        return v;
    }

    private void extend(int i) {
        int sz = this.base.length;
        int nsz = Math.max(i + 65535, (int)((double)sz * 1.5));
        this.base = Arrays.copyOf(this.base, nsz);
        Arrays.fill(this.base, sz, nsz, Integer.MAX_VALUE);
        this.check = Arrays.copyOf(this.check, nsz);
        Arrays.fill(this.check, sz, nsz, -1);
    }

    private int findFirstEmptyCheck() {
        int i = this.firstEmptyCheck;
        while (this.check[i] >= 0 || this.base[i] != Integer.MAX_VALUE) {
            ++i;
        }
        this.firstEmptyCheck = i;
        return i;
    }

    private int findNextEmptyCheck(int i) {
        int d = this.check[i] * -1;
        if (d <= 0) {
            throw new RuntimeException();
        }
        int prev = i;
        if (this.check.length <= (i += d)) {
            this.extend(i);
            return i;
        }
        if (this.check[i] < 0) {
            return i;
        }
        ++i;
        while (i < this.check.length) {
            if (this.check[i] < 0) {
                this.check[prev] = prev - i;
                return i;
            }
            ++i;
        }
        this.extend(i);
        this.check[prev] = prev - i;
        return i;
    }

    private void setCheck(int index, int id) {
        if (this.firstEmptyCheck == index) {
            this.firstEmptyCheck = this.findNextEmptyCheck(this.firstEmptyCheck);
        }
        this.check[index] = id;
        this.last = Math.max(this.last, index);
    }

    protected class DoubleArrayNode
    implements TermIdNode {
        private char firstChar = '\u0000';
        private int nodeId;

        public DoubleArrayNode(int nodeId) {
            this.nodeId = nodeId;
        }

        public DoubleArrayNode(int nodeId, char firstChar) {
            this.nodeId = nodeId;
            this.firstChar = firstChar;
        }

        @Override
        public boolean isTerminate() {
            int nid = this.nodeId;
            CharSequence children2;
            int n;
            while ((n = (children2 = this.listupChildChars(nid)).length()) != 0) {
                int b = DoubleArray.this.base[nid];
                char firstChar = children2.charAt(0);
                int firstNid = b + DoubleArray.this.charToCode[firstChar];
                if (n > 1) {
                    return DoubleArray.this.term.get(nid);
                }
                if (DoubleArray.this.term.get(firstNid)) {
                    return true;
                }
                nid = firstNid;
            }
            return DoubleArray.this.term.get(nid);
        }

        @Override
        public char[] getLetters() {
            StringBuilder ret = new StringBuilder();
            if (this.firstChar != '\u0000') {
                ret.append(this.firstChar);
            }
            return ret.toString().toCharArray();
        }

        public DoubleArrayNode[] getChildren() {
            int nid = this.nodeId;
            CharSequence children2;
            int n;
            while ((n = (children2 = this.listupChildChars(nid)).length()) != 0) {
                int b = DoubleArray.this.base[nid];
                if (n > 1 || DoubleArray.this.term.get(nid)) {
                    return this.listupChildNodes(b, children2);
                }
                nid = b + DoubleArray.this.charToCode[children2.charAt(0)];
            }
            return emptyNodes;
        }

        @Override
        public DoubleArrayNode getChild(char c) {
            char code = DoubleArray.this.charToCode[c];
            if (code == '\uffffffff') {
                return null;
            }
            int nid = DoubleArray.this.base[this.nodeId] + c;
            if (nid >= 0 && nid < DoubleArray.this.check.length && DoubleArray.this.check[nid] == this.nodeId) {
                return new DoubleArrayNode(nid, c);
            }
            return null;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        @Override
        public int getTermId() {
            if (!DoubleArray.this.term.get(this.nodeId)) {
                return -1;
            }
            return DoubleArray.this.term.rank1(this.nodeId) - 1;
        }

        private CharSequence listupChildChars(int nodeId) {
            StringBuilder b = new StringBuilder();
            int bs = DoubleArray.this.base[nodeId];
            Iterator iterator2 = DoubleArray.this.chars.iterator();
            while (iterator2.hasNext()) {
                char c = ((Character)iterator2.next()).charValue();
                int nid = bs + DoubleArray.this.charToCode[c];
                if (nid < 0 || nid >= DoubleArray.this.check.length || DoubleArray.this.check[nid] != nodeId) continue;
                b.append(c);
            }
            return b;
        }

        private DoubleArrayNode[] listupChildNodes(int base, CharSequence chars) {
            int n = chars.length();
            DoubleArrayNode[] ret = new DoubleArrayNode[n];
            for (int i = 0; i < n; ++i) {
                char c = chars.charAt(i);
                char code = DoubleArray.this.charToCode[c];
                ret[i] = DoubleArray.this.newDoubleArrayNode(base + code, c);
            }
            return ret;
        }
    }

    public static interface TermNodeListener {
        public void listen(Node var1, int var2);
    }
}

