/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bytes;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import org.trie4j.bytes.Node;
import org.trie4j.bytes.PatriciaTrie;
import org.trie4j.bytes.TrieVisitor;
import org.trie4j.util.CharsetUtil;
import org.trie4j.util.StringUtil;

public class TestWikipedia {
    private static final int maxCount = 2000000;

    public static void main(String[] args) throws Exception {
        System.out.println("--- recursive patricia trie ---");
        PatriciaTrie trie = new PatriciaTrie();
        int c = 0;
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream("enwiki-20120403-all-titles-in-ns0.gz")), CharsetUtil.newUTF8Decoder()));
        String word = null;
        System.gc();
        Thread.sleep(1000L);
        System.out.println(String.valueOf(Runtime.getRuntime().freeMemory()) + " bytes free.");
        long sum2 = 0L;
        long lap = System.currentTimeMillis();
        int charCount = 0;
        while ((word = r.readLine()) != null) {
            byte[] bytes2 = word.getBytes("UTF-8");
            long d = System.currentTimeMillis();
            trie.insert(bytes2);
            sum2 += System.currentTimeMillis() - d;
            charCount += word.length();
            if (c % 100000 == 0) {
                d = System.currentTimeMillis() - lap;
                long free = Runtime.getRuntime().freeMemory();
                System.out.println(String.valueOf(c) + "," + free + "," + Runtime.getRuntime().maxMemory() + "," + d);
                lap = System.currentTimeMillis();
            }
            if (++c == 2000000) break;
        }
        System.out.println(String.valueOf(c) + "entries in ja wikipedia titles.");
        System.out.println("insert time: " + sum2 + " millis.");
        System.out.println("-- insert done.");
        System.gc();
        Thread.sleep(1000L);
        System.out.println(String.valueOf(Runtime.getRuntime().freeMemory()) + " bytes free.");
        TestWikipedia.investigate(trie, charCount);
    }

    private static void dump(PatriciaTrie trie) {
        System.out.println("--dump--");
        trie.visit(new TrieVisitor(){

            @Override
            public void accept(Node node, int nest) {
                int i = 0;
                while (i < nest) {
                    System.out.print(" ");
                    ++i;
                }
                byte[] letters = node.getLetters();
                if (letters != null && letters.length > 0) {
                    System.out.print(StringUtil.fromUTF8(letters));
                }
                if (node.isTerminate()) {
                    System.out.print("*");
                }
                System.out.println();
            }
        });
    }

    private static void investigate(PatriciaTrie trie, int charCount) throws Exception {
        System.out.println("-- count elements.");
        final AtomicInteger count2 = new AtomicInteger();
        trie.visit(new TrieVisitor(){

            @Override
            public void accept(Node node, int nest) {
                if (node.isTerminate()) {
                    count2.incrementAndGet();
                }
            }
        });
        System.out.println(String.valueOf(count2.intValue()) + " elements.");
        System.out.println("-- list elements.");
        final AtomicInteger n = new AtomicInteger();
        final AtomicInteger l = new AtomicInteger();
        AtomicInteger ln = new AtomicInteger();
        final AtomicInteger chars = new AtomicInteger();
        trie.visit(new TrieVisitor(){

            @Override
            public void accept(Node node, int nest) {
                if (node.isTerminate()) {
                    l.incrementAndGet();
                } else {
                    n.incrementAndGet();
                }
                chars.addAndGet(node.getLetters().length);
            }
        });
        System.out.println("node: " + n.intValue());
        System.out.println("leaf: " + l.intValue());
        System.out.println("label node: " + ln.intValue());
        System.out.println("total char count: " + charCount);
        System.out.println("total char count in trie: " + chars.intValue());
        System.out.println("verifying trie...");
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream("enwiki-20120403-all-titles-in-ns0.gz")), CharsetUtil.newUTF8Decoder()));
        long lap = System.currentTimeMillis();
        int c = 0;
        int sum2 = 0;
        String word = null;
        while ((word = r.readLine()) != null) {
            if (c == 2000000) break;
            long d = System.currentTimeMillis();
            boolean found = trie.contains(word);
            sum2 = (int)((long)sum2 + (System.currentTimeMillis() - d));
            if (!found) {
                System.out.println("trie not contains [" + word + "]");
                break;
            }
            if (c % 100000 == 0) {
                System.out.println(String.valueOf(c) + " elements done.");
            }
            ++c;
        }
        System.out.println("done in " + (System.currentTimeMillis() - lap) + " millis.");
        System.out.println("contains time: " + sum2 + " millis.");
        System.out.println(String.valueOf(trie.getRoot().getChildren().length) + "children in root");
        final PatriciaTrie t = trie;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100000L);
                    t.contains("hello");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
    }
}

