/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bytes;

import java.io.UnsupportedEncodingException;
import org.trie4j.bytes.Node;
import org.trie4j.bytes.PatriciaTrie;
import org.trie4j.bytes.TrieVisitor;

public class Test {
    public static void main(String[] args) throws Exception {
        System.out.println("--- patricia trie ---");
        Test.go(new PatriciaTrie());
    }

    private static void go(PatriciaTrie trie) throws Exception {
        String[] words = new String[]{"apple", "appear", "a", "orange", "applejuice", "appletea", "appleshower", "orangejuice"};
        trie.insert("".getBytes("UTF-8"));
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            System.out.println("insert \"" + string2 + "\"");
            trie.insert(string2.getBytes("UTF-8"));
            System.out.println("--dump--");
            trie.visit(new TrieVisitor(){

                @Override
                public void accept(Node node, int nest) {
                    int i = 0;
                    while (i < nest) {
                        System.out.print(" ");
                        ++i;
                    }
                    byte[] letters = node.getLetters();
                    if (letters == null || letters.length == 0) {
                        System.out.print("<empty>");
                    } else {
                        System.out.print(Test.fromUTF8(letters));
                    }
                    if (node.isTerminate()) {
                        System.out.println("*");
                    } else {
                        System.out.println("");
                    }
                }
            });
            ++n2;
        }
        System.out.println(trie.contains(""));
        System.out.println("--test contains--");
        stringArray = words;
        n = words.length;
        n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            System.out.print(String.valueOf(string3) + ": ");
            System.out.println(trie.contains(string3));
            ++n2;
        }
        System.out.println("--test not contains--");
        stringArray = new String[]{"banana", "app", "applebeer", "applejuice2"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String string4 = stringArray[n2];
            System.out.println(String.valueOf(string4) + ": " + trie.contains(string4));
            ++n2;
        }
        System.out.println("-- test common prefix search --");
        System.out.println("query: applejuicebar");
        for (byte[] byArray : trie.commonPrefixSearch("applejuicebar".getBytes("UTF-8"))) {
            System.out.println(new String(byArray, "UTF-8"));
        }
    }

    private static String fromUTF8(byte[] bytes2) {
        try {
            return new String(bytes2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

