/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bytes;

import java.util.Arrays;
import org.trie4j.bytes.Node;
import org.trie4j.bytes.TrieVisitor;

public class PatriciaTrieNode
implements Node {
    private PatriciaTrieNode[] children;
    private byte[] letters;
    private boolean terminated;
    private static PatriciaTrieNode[] emptyChildren = new PatriciaTrieNode[0];

    public PatriciaTrieNode() {
    }

    public PatriciaTrieNode(byte[] letters, boolean terminated) {
        this.children = emptyChildren;
        this.letters = letters;
        this.terminated = terminated;
    }

    public PatriciaTrieNode(byte[] letters, PatriciaTrieNode[] children2, boolean terminated) {
        this.children = children2;
        this.letters = letters;
        this.terminated = terminated;
    }

    public PatriciaTrieNode[] getChildren() {
        return this.children;
    }

    public void setChildren(PatriciaTrieNode[] children2) {
        this.children = children2;
    }

    @Override
    public byte[] getLetters() {
        return this.letters;
    }

    public void setLetters(byte[] letters) {
        this.letters = letters;
    }

    @Override
    public boolean isTerminate() {
        return this.terminated;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    @Override
    public PatriciaTrieNode getChild(byte c) {
        block8: {
            if (this.children == null) break block8;
            int end = this.children.length;
            if (end > 16) {
                int start = 0;
                while (start < end) {
                    int i = (start + end) / 2;
                    PatriciaTrieNode n = this.children[i];
                    int d = c - n.letters[0];
                    if (d == 0) {
                        return n;
                    }
                    if (d < 0) {
                        end = i;
                        continue;
                    }
                    if (start != i) {
                        start = i;
                        continue;
                    }
                    break;
                }
            } else {
                int i = 0;
                while (i < end) {
                    PatriciaTrieNode n = this.children[i];
                    if (n.letters != null && n.letters.length > 0 && n.letters[0] == c) {
                        return n;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void insertChild(byte[] letters, int offset) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        if (this.letters == null) {
                            this.letters = Arrays.copyOfRange(letters, offset, letters.length);
                            this.terminated = true;
                            return;
                        }
                        i = 0;
                        lettersRest = letters.length - offset;
                        thisLettersLength = this.letters.length;
                        n = Math.min(lettersRest, thisLettersLength);
                        c = 0;
                        while (i < n && (c = letters[i + offset] - this.letters[i]) == 0) {
                            ++i;
                        }
                        if (i != n) break block13;
                        if (lettersRest == thisLettersLength) {
                            this.terminated = true;
                            return;
                        }
                        if (lettersRest < thisLettersLength) {
                            child = new PatriciaTrieNode(Arrays.copyOfRange(this.letters, lettersRest, this.letters.length), this.children, this.terminated);
                            this.letters = Arrays.copyOfRange(this.letters, 0, i);
                            this.children = new PatriciaTrieNode[]{child};
                            this.terminated = true;
                            return;
                        }
                        if (this.children == null) break block14;
                        index = 0;
                        end = this.children.length;
                        if (end <= 16) ** GOTO lbl51
                        start = 0;
                        while (start < end) {
                            index = (start + end) / 2;
                            child = this.children[index];
                            c = letters[i + offset] - child.letters[0];
                            if (c == 0) {
                                child.insertChild(letters, i + offset);
                                return;
                            }
                            if (c < 0) {
                                end = index;
                                continue;
                            }
                            if (start == index) {
                                index = end;
                                break block12;
                            }
                            start = index;
                        }
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            child = this.children[index];
                            c = letters[i + offset] - child.letters[0];
                            if (c < 0) break;
                            if (c == 0) {
                                child.insertChild(letters, i + offset);
                                return;
                            }
                            ++index;
lbl51:
                            // 2 sources

                            ** while (index < end)
                        }
                    }
                    this.addChild(index, new PatriciaTrieNode(Arrays.copyOfRange(letters, i + offset, letters.length), true));
                    break block15;
                }
                this.children = new PatriciaTrieNode[]{new PatriciaTrieNode(Arrays.copyOfRange(letters, i + offset, letters.length), true)};
                this.terminated = true;
            }
            return;
        }
        newLetter1 = Arrays.copyOfRange(this.letters, 0, i);
        newLetter2 = Arrays.copyOfRange(this.letters, i, this.letters.length);
        newLetter3 = Arrays.copyOfRange(letters, i + offset, letters.length);
        newChildren = new PatriciaTrieNode[2];
        if (newLetter2[0] < newLetter3[0]) {
            newChildren[0] = new PatriciaTrieNode(newLetter2, this.children, true);
            newChildren[1] = new PatriciaTrieNode(newLetter3, true);
        } else {
            newChildren[0] = new PatriciaTrieNode(newLetter3, true);
            newChildren[1] = new PatriciaTrieNode(newLetter2, this.children, true);
        }
        this.letters = newLetter1;
        this.children = newChildren;
        this.terminated = false;
    }

    public boolean contains(byte[] letters, int offset) {
        int tll = this.letters.length;
        int rest = letters.length - offset;
        if (tll > rest) {
            return false;
        }
        int i = 0;
        while (i < tll) {
            if (this.letters[i] != letters[i + offset]) {
                return false;
            }
            ++i;
        }
        if (tll == rest) {
            return this.terminated;
        }
        byte c = letters[offset += tll];
        PatriciaTrieNode n = this.getChild(c);
        if (n != null) {
            return n.contains(letters, offset);
        }
        return false;
    }

    @Override
    public void visit(TrieVisitor visitor, int nest) {
        visitor.accept(this, nest);
        ++nest;
        if (this.children != null) {
            PatriciaTrieNode[] patriciaTrieNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                PatriciaTrieNode n3 = patriciaTrieNodeArray[n2];
                n3.visit(visitor, nest);
                ++n2;
            }
        }
    }

    private void addChild(int index, PatriciaTrieNode n) {
        PatriciaTrieNode[] newc = new PatriciaTrieNode[this.children.length + 1];
        System.arraycopy(this.children, 0, newc, 0, index);
        newc[index] = n;
        System.arraycopy(this.children, index, newc, index + 1, this.children.length - index);
        this.children = newc;
    }
}

