/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.trie4j.bytes.Node;
import org.trie4j.bytes.PatriciaTrieNode;
import org.trie4j.bytes.Trie;
import org.trie4j.bytes.TrieVisitor;
import org.trie4j.util.StringUtil;

public class PatriciaTrie
implements Trie {
    private PatriciaTrieNode root;

    public boolean contains(String word) {
        return this.root.contains(StringUtil.toUTF8(word), 0);
    }

    @Override
    public boolean contains(byte[] word) {
        return this.root.contains(word, 0);
    }

    @Override
    public Iterable<byte[]> commonPrefixSearch(byte[] query) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        byte[] queryChars = query;
        int cur = 0;
        Node node = this.root;
        while (node != null) {
            byte[] letters = node.getLetters();
            if (letters.length > queryChars.length - cur) {
                return ret;
            }
            int i = 0;
            while (i < letters.length) {
                if (letters[i] != queryChars[cur + i]) {
                    return ret;
                }
                ++i;
            }
            if (node.isTerminate()) {
                ret.add(Arrays.copyOfRange(queryChars, 0, cur + letters.length));
            }
            if (queryChars.length == (cur += letters.length)) {
                return ret;
            }
            node = node.getChild(queryChars[cur]);
        }
        return ret;
    }

    private static void enumLetters(Node node, String prefix, List<String> letters) {
        Node[] children2 = node.getChildren();
        if (children2 == null) {
            return;
        }
        Node[] nodeArray = children2;
        int n = children2.length;
        int n2 = 0;
        while (n2 < n) {
            Node child = nodeArray[n2];
            String text = String.valueOf(prefix) + StringUtil.fromUTF8(child.getLetters());
            if (child.isTerminate()) {
                letters.add(text);
            }
            PatriciaTrie.enumLetters(child, text, letters);
            ++n2;
        }
    }

    public Iterable<String> predictiveSearch(String prefix) {
        byte[] queryChars = StringUtil.toUTF8(prefix);
        int cur = 0;
        Node node = this.root;
        while (node != null) {
            byte[] letters = node.getLetters();
            int n = Math.min(letters.length, queryChars.length - cur);
            int i = 0;
            while (i < n) {
                if (letters[i] != queryChars[cur + i]) {
                    return Collections.emptyList();
                }
                ++i;
            }
            if (queryChars.length == (cur += n)) {
                ArrayList<String> ret = new ArrayList<String>();
                int rest = letters.length - n;
                if (rest > 0) {
                    prefix = String.valueOf(prefix) + new String(letters, n, rest);
                }
                if (node.isTerminate()) {
                    ret.add(prefix);
                }
                PatriciaTrie.enumLetters(node, prefix, ret);
                return ret;
            }
            node = node.getChild(queryChars[cur]);
        }
        return Collections.emptyList();
    }

    @Override
    public void insert(byte[] text) {
        byte[] letters = text;
        if (this.root == null) {
            this.root = new PatriciaTrieNode(letters, true);
            return;
        }
        this.root.insertChild(letters, 0);
    }

    public void visit(TrieVisitor visitor) {
        this.root.visit(visitor, 0);
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public void freeze() {
    }

    @Override
    public void dump(Writer writer) throws IOException {
    }

    @Override
    public int findWord(byte[] chars, int start, int end, OutputStream word) throws IOException {
        return 0;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Iterable<byte[]> predictiveSearch(byte[] prefix) {
        return null;
    }

    @Override
    public void trimToSize() {
    }
}

