/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bytes;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.trie4j.bytes.Node;
import org.trie4j.bytes.Trie;
import org.trie4j.bytes.TrieVisitor;
import org.trie4j.util.Pair;

public class DoubleArray
implements Trie {
    private static final int BASE_EMPTY = Integer.MAX_VALUE;
    private int size;
    private int[] base;
    private int[] check;
    private int firstEmptyCheck = 1;
    private int last;
    private BitSet term;
    private Set<Byte> chars = new TreeSet<Byte>();
    private static final Node[] emptyNodes = new Node[0];

    public DoubleArray() {
    }

    public DoubleArray(Trie trie) {
        this(trie, trie.size() * 2);
    }

    public DoubleArray(Trie trie, int arraySize) {
        if (arraySize <= 1) {
            arraySize = 2;
        }
        this.size = trie.size();
        this.base = new int[arraySize];
        Arrays.fill(this.base, Integer.MAX_VALUE);
        this.check = new int[arraySize];
        Arrays.fill(this.check, -1);
        this.term = new BitSet(arraySize);
        this.build(trie.getRoot(), 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Node getRoot() {
        return new DoubleArrayNode(0);
    }

    public int[] getBase() {
        return this.base;
    }

    @Override
    public boolean contains(byte[] bytes2) {
        int nodeIndex = 0;
        byte[] byArray = bytes2;
        int n = bytes2.length;
        int n2 = 0;
        while (n2 < n) {
            byte cid = byArray[n2];
            if (cid == 0) {
                return false;
            }
            int next2 = this.base[nodeIndex] + cid;
            if (this.check[next2] != nodeIndex) {
                return false;
            }
            nodeIndex = next2;
            ++n2;
        }
        return this.term.get(nodeIndex);
    }

    @Override
    public Iterable<byte[]> commonPrefixSearch(byte[] query) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        byte[] chars = query;
        int charsLen = chars.length;
        int checkLen = this.check.length;
        int nodeIndex = 0;
        int i = 0;
        while (i < charsLen) {
            byte cid = chars[i];
            if (cid == 0) {
                return ret;
            }
            int b = this.base[nodeIndex];
            if (b == Integer.MAX_VALUE) {
                return ret;
            }
            int next2 = b + cid;
            if (next2 >= checkLen || this.check[next2] != nodeIndex) {
                return ret;
            }
            nodeIndex = next2;
            if (this.term.get(nodeIndex)) {
                ret.add(Arrays.copyOf(chars, i + 1));
            }
            ++i;
        }
        return ret;
    }

    @Override
    public int findWord(byte[] chars, int start, int end, OutputStream word) throws IOException {
        int i = start;
        while (i < end) {
            int nodeIndex = 0;
            try {
                int j = i;
                while (j < end) {
                    int next2;
                    int b;
                    byte cid = chars[j];
                    if (cid != 0 && (b = this.base[nodeIndex]) != Integer.MAX_VALUE && nodeIndex == this.check[next2 = b + cid]) {
                        nodeIndex = next2;
                        if (this.term.get(nodeIndex)) {
                            if (word != null) {
                                word.write(chars, i, j + 1);
                            }
                            return i;
                        }
                        ++j;
                        continue;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Iterable<byte[]> predictiveSearch(byte[] prefix) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        byte[] chars = prefix;
        int charsLen = chars.length;
        int checkLen = this.check.length;
        int nodeIndex = 0;
        int i = 0;
        while (i < charsLen) {
            byte cid = chars[i];
            if (cid == 0) {
                return ret;
            }
            int next2 = this.base[nodeIndex] + cid;
            if (next2 < 0 || next2 >= checkLen || this.check[next2] != nodeIndex) {
                return ret;
            }
            nodeIndex = next2;
            ++i;
        }
        if (this.term.get(nodeIndex)) {
            ret.add(prefix);
        }
        LinkedList<Pair<Integer, byte[]>> q = new LinkedList<Pair<Integer, byte[]>>();
        q.add(Pair.create(nodeIndex, prefix));
        while (!q.isEmpty()) {
            Pair p = (Pair)q.pop();
            int ni = (Integer)p.getFirst();
            int b = this.base[ni];
            if (b == Integer.MAX_VALUE) continue;
            byte[] c = (byte[])p.getSecond();
            for (byte v : this.chars) {
                int next3 = b + v;
                if (next3 >= checkLen || this.check[next3] != ni) continue;
                byte[] n = Arrays.copyOf(c, c.length + 1);
                n[c.length] = v;
                if (this.term.get(next3)) {
                    ret.add(n);
                }
                q.push(Pair.create(next3, n));
            }
        }
        return ret;
    }

    @Override
    public void insert(byte[] word) {
        throw new UnsupportedOperationException();
    }

    public void save(OutputStream os) throws IOException {
        int v;
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(this.size);
        dos.writeInt(this.base.length);
        int[] nArray = this.base;
        int n = this.base.length;
        int n2 = 0;
        while (n2 < n) {
            v = nArray[n2];
            dos.writeInt(v);
            ++n2;
        }
        nArray = this.check;
        n = this.check.length;
        n2 = 0;
        while (n2 < n) {
            v = nArray[n2];
            dos.writeInt(v);
            ++n2;
        }
        dos.flush();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this.term);
        oos.flush();
        dos.writeInt(this.firstEmptyCheck);
        dos.writeInt(this.chars.size());
        for (byte c : this.chars) {
            dos.write(c);
        }
        dos.flush();
        bos.flush();
    }

    public void load(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        this.size = dis.readInt();
        int len = dis.readInt();
        this.base = new int[len];
        int i = 0;
        while (i < len) {
            this.base[i] = dis.readInt();
            ++i;
        }
        this.check = new int[len];
        i = 0;
        while (i < len) {
            this.check[i] = dis.readInt();
            ++i;
        }
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            this.term = (BitSet)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.firstEmptyCheck = dis.readInt();
        int n = dis.readInt();
        int i2 = 0;
        while (i2 < n) {
            byte c = dis.readByte();
            this.chars.add(c);
            ++i2;
        }
    }

    @Override
    public void trimToSize() {
        int sz = this.last + 1 + 65535;
        this.base = Arrays.copyOf(this.base, sz);
        this.check = Arrays.copyOf(this.check, sz);
    }

    @Override
    public void dump(Writer w) {
        PrintWriter writer = new PrintWriter(w);
        try {
            writer.println("array size: " + this.base.length);
            writer.print("      |");
            int i = 0;
            while (i < 16) {
                writer.print(String.format("%3d|", i));
                ++i;
            }
            writer.println();
            writer.print("|base |");
            i = 0;
            while (i < 16) {
                if (this.base[i] == Integer.MAX_VALUE) {
                    writer.print("N/A|");
                } else {
                    writer.print(String.format("%3d|", this.base[i]));
                }
                ++i;
            }
            writer.println();
            writer.print("|check|");
            i = 0;
            while (i < 16) {
                if (this.check[i] < 0) {
                    writer.print("N/A|");
                } else {
                    writer.print(String.format("%3d|", this.check[i]));
                }
                ++i;
            }
            writer.println();
            writer.print("|term |");
            i = 0;
            while (i < 16) {
                writer.print(String.format("%3d|", this.term.get(i) ? 1 : 0));
                ++i;
            }
            writer.println();
            writer.print("chars: ");
            int c = 0;
            for (byte e : this.chars) {
                writer.print(String.format("%c:%d,", e, (int)e));
                if (++c > 16) break;
            }
            writer.println();
            writer.println("chars count: " + this.chars.size());
            writer.println();
        }
        finally {
            writer.flush();
        }
    }

    @Override
    public void freeze() {
    }

    private void build(Node node, int nodeIndex) {
        int offset;
        Node[] children2;
        int childrenLen;
        byte[] letters = node.getLetters();
        int lettersLen = letters.length;
        int i = 1;
        while (i < lettersLen) {
            byte cid = letters[i];
            int empty = this.findFirstEmptyCheck();
            this.setCheck(empty, nodeIndex);
            this.base[nodeIndex] = empty - cid;
            nodeIndex = empty;
            ++i;
        }
        if (node.isTerminate()) {
            this.term.set(nodeIndex);
        }
        if ((childrenLen = (children2 = node.getChildren()).length) == 0) {
            return;
        }
        int[] heads = new int[childrenLen];
        int maxHead = 0;
        int minHead = Integer.MAX_VALUE;
        int i2 = 0;
        while (i2 < childrenLen) {
            heads[i2] = children2[i2].getLetters()[0];
            maxHead = Math.max(maxHead, heads[i2]);
            minHead = Math.min(minHead, heads[i2]);
            ++i2;
        }
        this.base[nodeIndex] = offset = this.findInsertOffset(heads, minHead, maxHead);
        int[] nArray = heads;
        int n = heads.length;
        int n2 = 0;
        while (n2 < n) {
            int cid = nArray[n2];
            this.setCheck(offset + cid, nodeIndex);
            ++n2;
        }
        TreeMap<Integer, ArrayList<Pair<Node, Integer>>> nodes = new TreeMap<Integer, ArrayList<Pair<Node, Integer>>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg1 - arg0;
            }
        });
        int i3 = 0;
        while (i3 < children2.length) {
            ArrayList<Pair<Node, Integer>> p;
            Node[] c = children2[i3].getChildren();
            int n3 = 0;
            if (c != null) {
                n3 = c.length;
            }
            if ((p = (ArrayList<Pair<Node, Integer>>)nodes.get(n3)) == null) {
                p = new ArrayList<Pair<Node, Integer>>();
                nodes.put(n3, p);
            }
            p.add(Pair.create(children2[i3], heads[i3]));
            ++i3;
        }
        for (Map.Entry e : nodes.entrySet()) {
            for (Pair e2 : (List)e.getValue()) {
                this.build((Node)e2.getFirst(), (Integer)e2.getSecond() + offset);
            }
        }
    }

    private int findInsertOffset(int[] heads, int minHead, int maxHead) {
        int empty = this.findFirstEmptyCheck();
        while (true) {
            int offset;
            if ((offset = empty - minHead) + maxHead >= this.check.length) {
                this.extend(offset + maxHead);
            }
            boolean found = true;
            int[] nArray = heads;
            int n = heads.length;
            int n2 = 0;
            while (n2 < n) {
                int cid = nArray[n2];
                if (this.check[offset + cid] >= 0) {
                    found = false;
                    break;
                }
                ++n2;
            }
            if (found) {
                return offset;
            }
            empty = this.findNextEmptyCheck(empty);
        }
    }

    private void extend(int i) {
        int sz = this.base.length;
        int nsz = Math.max(i + 65535, (int)((double)sz * 1.5));
        this.base = Arrays.copyOf(this.base, nsz);
        Arrays.fill(this.base, sz, nsz, Integer.MAX_VALUE);
        this.check = Arrays.copyOf(this.check, nsz);
        Arrays.fill(this.check, sz, nsz, -1);
    }

    private int findFirstEmptyCheck() {
        int i = this.firstEmptyCheck;
        while (this.check[i] >= 0 || this.base[i] != Integer.MAX_VALUE) {
            ++i;
        }
        this.firstEmptyCheck = i;
        return i;
    }

    private int findNextEmptyCheck(int i) {
        int d = this.check[i] * -1;
        if (d <= 0) {
            throw new RuntimeException();
        }
        int prev = i;
        if (this.check.length <= (i += d)) {
            this.extend(i);
            return i;
        }
        if (this.check[i] < 0) {
            return i;
        }
        ++i;
        while (i < this.check.length) {
            if (this.check[i] < 0) {
                this.check[prev] = prev - i;
                return i;
            }
            ++i;
        }
        this.extend(i);
        this.check[prev] = prev - i;
        return i;
    }

    private void setCheck(int index, int id) {
        if (this.firstEmptyCheck == index) {
            this.firstEmptyCheck = this.findNextEmptyCheck(this.firstEmptyCheck);
        }
        this.check[index] = id;
        this.last = Math.max(this.last, index);
    }

    private class DoubleArrayNode
    implements Node {
        private byte firstChar = 0;
        private int nodeId;

        public DoubleArrayNode(int nodeId) {
            this.nodeId = nodeId;
        }

        public DoubleArrayNode(int nodeId, byte firstChar) {
            this.nodeId = nodeId;
            this.firstChar = firstChar;
        }

        @Override
        public boolean isTerminate() {
            int nid = this.nodeId;
            byte[] children2;
            int n;
            while ((n = (children2 = this.listupChildChars(nid)).length) != 0) {
                int b = DoubleArray.this.base[nid];
                byte firstChar = children2[0];
                int firstNid = b + firstChar;
                if (n > 1) {
                    return DoubleArray.this.term.get(nid);
                }
                if (DoubleArray.this.term.get(firstNid)) {
                    return true;
                }
                nid = firstNid;
            }
            return DoubleArray.this.term.get(nid);
        }

        @Override
        public byte[] getLetters() {
            ByteArrayOutputStream ret = new ByteArrayOutputStream();
            if (this.firstChar != 0) {
                ret.write(this.firstChar);
            }
            int nid = this.nodeId;
            while (!DoubleArray.this.term.get(nid)) {
                byte[] children2 = this.listupChildChars(nid);
                int n = children2.length;
                if (n == 0 || n > 1) {
                    return ret.toByteArray();
                }
                byte c = children2[0];
                ret.write(c);
                nid = DoubleArray.this.base[nid] + c;
            }
            return ret.toByteArray();
        }

        @Override
        public Node[] getChildren() {
            int nid = this.nodeId;
            byte[] children2;
            int n;
            while ((n = (children2 = this.listupChildChars(nid)).length) != 0) {
                int b = DoubleArray.this.base[nid];
                if (n > 1 || DoubleArray.this.term.get(nid)) {
                    return this.listupChildNodes(b, children2);
                }
                nid = b + children2[0];
            }
            return emptyNodes;
        }

        @Override
        public Node getChild(byte c) {
            byte code = c;
            if (code == -1) {
                return null;
            }
            int nid = DoubleArray.this.base[this.nodeId] + c;
            if (nid >= 0 && nid < DoubleArray.this.check.length && DoubleArray.this.check[nid] == this.nodeId) {
                return new DoubleArrayNode(nid, c);
            }
            return null;
        }

        @Override
        public void visit(TrieVisitor visitor, int nest) {
        }

        private byte[] listupChildChars(int nodeId) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            int bs = DoubleArray.this.base[nodeId];
            Iterator iterator2 = DoubleArray.this.chars.iterator();
            while (iterator2.hasNext()) {
                byte c = (Byte)iterator2.next();
                int nid = bs + c;
                if (nid < 0 || nid >= DoubleArray.this.check.length || DoubleArray.this.check[nid] != nodeId) continue;
                b.write(c);
            }
            return b.toByteArray();
        }

        private Node[] listupChildNodes(int base, byte[] chars) {
            int n = chars.length;
            Node[] ret = new Node[n];
            int i = 0;
            while (i < n) {
                byte c;
                byte code = c = chars[i];
                ret[i] = new DoubleArrayNode(base + code, c);
                ++i;
            }
            return ret;
        }
    }
}

