/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv2;

import java.util.Arrays;
import org.trie4j.bv2.BytesOperations;
import org.trie4j.bv2.BytesRank1;

public class BytesCachedRank1
implements BytesRank1 {
    private int bitsInCache = 64;
    private int bitsSize;
    private int[] countCache0;

    public BytesCachedRank1() {
        this(64);
    }

    public BytesCachedRank1(int cacheSize) {
        this.bitsInCache = cacheSize;
    }

    @Override
    public void append0() {
        int ci = this.bitsSize / this.bitsInCache;
        if (ci >= this.countCache0.length) {
            this.extend();
        }
        if (this.bitsSize % this.bitsInCache == 0 && ci > 0) {
            this.countCache0[ci] = this.countCache0[ci - 1];
        }
        int n = ci;
        this.countCache0[n] = this.countCache0[n] + 1;
        ++this.bitsSize;
    }

    @Override
    public void append1() {
        int ci = this.bitsSize / this.bitsInCache;
        if (ci >= this.countCache0.length) {
            this.extend();
        }
        if (this.bitsSize % this.bitsInCache == 0 && ci > 0) {
            this.countCache0[ci] = this.countCache0[ci - 1];
        }
        ++this.bitsSize;
    }

    @Override
    public int rank1(byte[] bytes2, int pos) {
        int cn = pos / this.bitsInCache;
        int rest = pos % this.bitsInCache;
        if (rest == 0) {
            return this.countCache0[cn];
        }
        if (cn == 0) {
            return BytesOperations.rank1(bytes2, 0, pos / 8);
        }
        return pos - rest - this.countCache0[cn - 1] + BytesOperations.rank1(bytes2, cn * (this.bitsInCache / 8), pos / 8);
    }

    @Override
    public void trimToSize() {
        this.countCache0 = Arrays.copyOf(this.countCache0, this.bitsSize / this.bitsInCache + 1);
    }

    private void extend() {
        int sz = (int)((double)this.countCache0.length * 1.5);
        if (sz == 0) {
            sz = 16;
        }
        this.countCache0 = Arrays.copyOf(this.countCache0, sz);
    }
}

