/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.trie4j.bv.BitVector;

public class BytesBitVector
implements Externalizable,
BitVector {
    private byte[] bytes;
    private int size;
    private static final byte[] BITS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};

    public BytesBitVector() {
        this(16);
    }

    public BytesBitVector(int initialCapacity) {
        this.bytes = new byte[BytesBitVector.containerBytesCount(initialCapacity)];
    }

    public BytesBitVector(byte[] bytes2, int bitsSize) {
        this.bytes = Arrays.copyOf(bytes2, BytesBitVector.containerBytesCount(bitsSize));
        this.size = bitsSize;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int n = Math.min(this.size, 32);
        for (int i = 0; i < n; ++i) {
            b.append((this.bytes[i / 8] & 128 >> i % 8) != 0 ? "1" : "0");
        }
        return b.toString();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public boolean get(int pos) {
        return this.isOne(pos);
    }

    @Override
    public boolean isZero(int pos) {
        return (this.bytes[pos / 8] & BITS[pos % 8]) == 0;
    }

    @Override
    public boolean isOne(int pos) {
        return (this.bytes[pos / 8] & BITS[pos % 8]) != 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void trimToSize() {
        int newSize = BytesBitVector.containerBytesCount(this.size);
        if (newSize < this.bytes.length) {
            this.bytes = Arrays.copyOf(this.bytes, newSize);
        }
    }

    @Override
    public void append1() {
        int i = this.size / 8;
        if (i >= this.bytes.length) {
            this.extend();
        }
        int n = i;
        this.bytes[n] = (byte)(this.bytes[n] | BITS[this.size % 8]);
        ++this.size;
    }

    @Override
    public void append0() {
        int i = this.size / 8;
        if (i >= this.bytes.length) {
            this.extend();
        }
        ++this.size;
    }

    public void append(boolean bit) {
        if (bit) {
            this.append1();
        } else {
            this.append0();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.size = in.readInt();
        int vectorSize = in.readInt();
        this.bytes = new byte[vectorSize];
        in.readFully(this.bytes, 0, vectorSize);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        this.trimToSize();
        out.writeInt(this.bytes.length);
        out.write(this.bytes);
    }

    private void extend() {
        this.bytes = Arrays.copyOf(this.bytes, (int)((double)this.bytes.length * 1.2) + 1);
    }

    private static int containerBytesCount(int size2) {
        return size2 / 8 + (size2 % 8 != 0 ? 1 : 0);
    }
}

