/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.util.IntArray;
import sun.misc.Unsafe;

public class UnsafeBytesSuccinctBitVector
implements Externalizable,
SuccinctBitVector {
    private static final int CACHE_WIDTH = 64;
    private static final int BITS0_COUNT_IN_EACH_INDEX = 64;
    private byte[] bytes;
    private int size;
    private int size0;
    private int node1pos = -1;
    private int node2pos = -1;
    private int node3pos = -1;
    private int[] countCache0;
    private IntArray indexCache0;
    private static final int[] MASKS = new int[]{128, 192, 224, 240, 248, 252, 254, 255};
    private static final byte[] BITS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte[] BITCOUNTS1 = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final byte[] BITCOUNTS0 = new byte[]{8, 7, 7, 6, 7, 6, 6, 5, 7, 6, 6, 5, 6, 5, 5, 4, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 4, 3, 3, 2, 3, 2, 2, 1, 3, 2, 2, 1, 2, 1, 1, 0};
    private static final byte[][] BITPOS0 = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 7}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 6, 7}, {0, 1, 2, 3, 4, 6}, {0, 1, 2, 3, 4, 7}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 5, 6, 7}, {0, 1, 2, 3, 5, 6}, {0, 1, 2, 3, 5, 7}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 6, 7}, {0, 1, 2, 3, 6}, {0, 1, 2, 3, 7}, {0, 1, 2, 3}, {0, 1, 2, 4, 5, 6, 7}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 4, 5, 7}, {0, 1, 2, 4, 5}, {0, 1, 2, 4, 6, 7}, {0, 1, 2, 4, 6}, {0, 1, 2, 4, 7}, {0, 1, 2, 4}, {0, 1, 2, 5, 6, 7}, {0, 1, 2, 5, 6}, {0, 1, 2, 5, 7}, {0, 1, 2, 5}, {0, 1, 2, 6, 7}, {0, 1, 2, 6}, {0, 1, 2, 7}, {0, 1, 2}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6}, {0, 1, 3, 4, 5, 7}, {0, 1, 3, 4, 5}, {0, 1, 3, 4, 6, 7}, {0, 1, 3, 4, 6}, {0, 1, 3, 4, 7}, {0, 1, 3, 4}, {0, 1, 3, 5, 6, 7}, {0, 1, 3, 5, 6}, {0, 1, 3, 5, 7}, {0, 1, 3, 5}, {0, 1, 3, 6, 7}, {0, 1, 3, 6}, {0, 1, 3, 7}, {0, 1, 3}, {0, 1, 4, 5, 6, 7}, {0, 1, 4, 5, 6}, {0, 1, 4, 5, 7}, {0, 1, 4, 5}, {0, 1, 4, 6, 7}, {0, 1, 4, 6}, {0, 1, 4, 7}, {0, 1, 4}, {0, 1, 5, 6, 7}, {0, 1, 5, 6}, {0, 1, 5, 7}, {0, 1, 5}, {0, 1, 6, 7}, {0, 1, 6}, {0, 1, 7}, {0, 1}, {0, 2, 3, 4, 5, 6, 7}, {0, 2, 3, 4, 5, 6}, {0, 2, 3, 4, 5, 7}, {0, 2, 3, 4, 5}, {0, 2, 3, 4, 6, 7}, {0, 2, 3, 4, 6}, {0, 2, 3, 4, 7}, {0, 2, 3, 4}, {0, 2, 3, 5, 6, 7}, {0, 2, 3, 5, 6}, {0, 2, 3, 5, 7}, {0, 2, 3, 5}, {0, 2, 3, 6, 7}, {0, 2, 3, 6}, {0, 2, 3, 7}, {0, 2, 3}, {0, 2, 4, 5, 6, 7}, {0, 2, 4, 5, 6}, {0, 2, 4, 5, 7}, {0, 2, 4, 5}, {0, 2, 4, 6, 7}, {0, 2, 4, 6}, {0, 2, 4, 7}, {0, 2, 4}, {0, 2, 5, 6, 7}, {0, 2, 5, 6}, {0, 2, 5, 7}, {0, 2, 5}, {0, 2, 6, 7}, {0, 2, 6}, {0, 2, 7}, {0, 2}, {0, 3, 4, 5, 6, 7}, {0, 3, 4, 5, 6}, {0, 3, 4, 5, 7}, {0, 3, 4, 5}, {0, 3, 4, 6, 7}, {0, 3, 4, 6}, {0, 3, 4, 7}, {0, 3, 4}, {0, 3, 5, 6, 7}, {0, 3, 5, 6}, {0, 3, 5, 7}, {0, 3, 5}, {0, 3, 6, 7}, {0, 3, 6}, {0, 3, 7}, {0, 3}, {0, 4, 5, 6, 7}, {0, 4, 5, 6}, {0, 4, 5, 7}, {0, 4, 5}, {0, 4, 6, 7}, {0, 4, 6}, {0, 4, 7}, {0, 4}, {0, 5, 6, 7}, {0, 5, 6}, {0, 5, 7}, {0, 5}, {0, 6, 7}, {0, 6}, {0, 7}, {0}, {1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6}, {1, 2, 3, 4, 5, 7}, {1, 2, 3, 4, 5}, {1, 2, 3, 4, 6, 7}, {1, 2, 3, 4, 6}, {1, 2, 3, 4, 7}, {1, 2, 3, 4}, {1, 2, 3, 5, 6, 7}, {1, 2, 3, 5, 6}, {1, 2, 3, 5, 7}, {1, 2, 3, 5}, {1, 2, 3, 6, 7}, {1, 2, 3, 6}, {1, 2, 3, 7}, {1, 2, 3}, {1, 2, 4, 5, 6, 7}, {1, 2, 4, 5, 6}, {1, 2, 4, 5, 7}, {1, 2, 4, 5}, {1, 2, 4, 6, 7}, {1, 2, 4, 6}, {1, 2, 4, 7}, {1, 2, 4}, {1, 2, 5, 6, 7}, {1, 2, 5, 6}, {1, 2, 5, 7}, {1, 2, 5}, {1, 2, 6, 7}, {1, 2, 6}, {1, 2, 7}, {1, 2}, {1, 3, 4, 5, 6, 7}, {1, 3, 4, 5, 6}, {1, 3, 4, 5, 7}, {1, 3, 4, 5}, {1, 3, 4, 6, 7}, {1, 3, 4, 6}, {1, 3, 4, 7}, {1, 3, 4}, {1, 3, 5, 6, 7}, {1, 3, 5, 6}, {1, 3, 5, 7}, {1, 3, 5}, {1, 3, 6, 7}, {1, 3, 6}, {1, 3, 7}, {1, 3}, {1, 4, 5, 6, 7}, {1, 4, 5, 6}, {1, 4, 5, 7}, {1, 4, 5}, {1, 4, 6, 7}, {1, 4, 6}, {1, 4, 7}, {1, 4}, {1, 5, 6, 7}, {1, 5, 6}, {1, 5, 7}, {1, 5}, {1, 6, 7}, {1, 6}, {1, 7}, {1}, {2, 3, 4, 5, 6, 7}, {2, 3, 4, 5, 6}, {2, 3, 4, 5, 7}, {2, 3, 4, 5}, {2, 3, 4, 6, 7}, {2, 3, 4, 6}, {2, 3, 4, 7}, {2, 3, 4}, {2, 3, 5, 6, 7}, {2, 3, 5, 6}, {2, 3, 5, 7}, {2, 3, 5}, {2, 3, 6, 7}, {2, 3, 6}, {2, 3, 7}, {2, 3}, {2, 4, 5, 6, 7}, {2, 4, 5, 6}, {2, 4, 5, 7}, {2, 4, 5}, {2, 4, 6, 7}, {2, 4, 6}, {2, 4, 7}, {2, 4}, {2, 5, 6, 7}, {2, 5, 6}, {2, 5, 7}, {2, 5}, {2, 6, 7}, {2, 6}, {2, 7}, {2}, {3, 4, 5, 6, 7}, {3, 4, 5, 6}, {3, 4, 5, 7}, {3, 4, 5}, {3, 4, 6, 7}, {3, 4, 6}, {3, 4, 7}, {3, 4}, {3, 5, 6, 7}, {3, 5, 6}, {3, 5, 7}, {3, 5}, {3, 6, 7}, {3, 6}, {3, 7}, {3}, {4, 5, 6, 7}, {4, 5, 6}, {4, 5, 7}, {4, 5}, {4, 6, 7}, {4, 6}, {4, 7}, {4}, {5, 6, 7}, {5, 6}, {5, 7}, {5}, {6, 7}, {6}, {7}, new byte[0]};
    private static final Unsafe unsafe;
    private static final long serialVersionUID = -7658605229245494623L;

    public UnsafeBytesSuccinctBitVector() {
        this(16);
    }

    public UnsafeBytesSuccinctBitVector(int initialCapacity) {
        this.bytes = new byte[UnsafeBytesSuccinctBitVector.bytesSize(initialCapacity)];
        this.countCache0 = new int[UnsafeBytesSuccinctBitVector.countCache0Size(initialCapacity)];
        this.indexCache0 = new IntArray(UnsafeBytesSuccinctBitVector.initialIndexCache0Size(initialCapacity));
    }

    public UnsafeBytesSuccinctBitVector(byte[] bytes2, int bitsSize) {
        this.bytes = Arrays.copyOf(bytes2, UnsafeBytesSuccinctBitVector.bytesSize(bitsSize));
        this.size = bitsSize;
        this.countCache0 = new int[UnsafeBytesSuccinctBitVector.countCache0Size(bitsSize)];
        this.indexCache0 = new IntArray(UnsafeBytesSuccinctBitVector.initialIndexCache0Size(bitsSize));
        int n = bytes2.length;
        for (int i = 0; i < n; ++i) {
            int b = bytes2[i] & 0xFF;
            byte[] zeroPosInB = BITPOS0[b];
            int rest = bitsSize - i * 8;
            if (rest < 8) {
                int nz = zeroPosInB.length;
                for (int j = 0; j < nz; ++j) {
                    if (zeroPosInB[j] < rest) continue;
                    zeroPosInB = Arrays.copyOf(zeroPosInB, j);
                    break;
                }
            }
            int zeroCount = zeroPosInB.length;
            if (this.size0 < 3 && zeroCount > 0) {
                if (this.size0 == 0) {
                    this.node1pos = zeroPosInB[0] + 8 * i;
                    if (zeroPosInB.length > 1) {
                        this.node2pos = zeroPosInB[1] + 8 * i;
                    }
                    if (zeroPosInB.length > 2) {
                        this.node3pos = zeroPosInB[2] + 8 * i;
                    }
                } else if (this.size0 == 1) {
                    this.node2pos = zeroPosInB[0] + 8 * i;
                    if (zeroPosInB.length > 1) {
                        this.node3pos = zeroPosInB[1] + 8 * i;
                    }
                } else {
                    this.node3pos = zeroPosInB[0] + 8 * i;
                }
            }
            int prevSize0 = this.size0;
            this.size0 += zeroCount;
            if ((i + 1) % 8 == 0) {
                this.countCache0[i / 8] = this.size0;
            }
            int indexOfIndexBlock = this.size0 / 64;
            if (zeroCount > 0 && indexOfIndexBlock != prevSize0 / 64) {
                this.indexCache0.set(indexOfIndexBlock, i * 8 + zeroPosInB[zeroPosInB.length - this.size0 % 64 - 1]);
            }
            if (rest < 8) break;
        }
        this.countCache0[(this.size - 1) / 64] = this.size0;
    }

    public UnsafeBytesSuccinctBitVector(byte[] bytes2, int size2, int size0, int node1pos, int node2pos, int node3pos, int[] countCache0, IntArray indexCache0) {
        this.bytes = bytes2;
        this.size = size2;
        this.size0 = size0;
        this.node1pos = node1pos;
        this.node2pos = node2pos;
        this.node3pos = node3pos;
        this.countCache0 = countCache0;
        this.indexCache0 = indexCache0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int n = Math.min(this.size, 32);
        for (int i = 0; i < n; ++i) {
            b.append((this.bytes[i / 8] & 128 >> i % 8) != 0 ? "1" : "0");
        }
        return b.toString();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int[] getCountCache0() {
        return this.countCache0;
    }

    public IntArray getIndexCache0() {
        return this.indexCache0;
    }

    @Override
    public boolean get(int pos) {
        return this.isOne(pos);
    }

    @Override
    public boolean isZero(int pos) {
        return (this.bytes[pos / 8] & BITS[pos % 8]) == 0;
    }

    @Override
    public boolean isOne(int pos) {
        return (this.bytes[pos / 8] & BITS[pos % 8]) != 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getSize0() {
        return this.size0;
    }

    public int getNode1pos() {
        return this.node1pos;
    }

    public int getNode2pos() {
        return this.node2pos;
    }

    public int getNode3pos() {
        return this.node3pos;
    }

    @Override
    public void trimToSize() {
        int size2;
        int vectorSize = this.size / 8 + 1;
        this.bytes = Arrays.copyOf(this.bytes, Math.min(this.bytes.length, vectorSize));
        int blockSize = 8;
        int countCacheSize0 = size2 = vectorSize / blockSize + (vectorSize % blockSize != 0 ? 1 : 0);
        this.countCache0 = Arrays.copyOf(this.countCache0, Math.min(this.countCache0.length, countCacheSize0));
        this.indexCache0.trimToSize();
    }

    @Override
    public void append0() {
        int i = this.size / 8;
        int ci = this.size / 64;
        if (i >= this.bytes.length) {
            this.extend();
        }
        if (this.size % 64 == 0 && ci > 0) {
            this.countCache0[ci] = this.countCache0[ci - 1];
        }
        ++this.size0;
        switch (this.size0) {
            case 1: {
                this.node1pos = this.size;
                break;
            }
            case 2: {
                this.node2pos = this.size;
                break;
            }
            case 3: {
                this.node3pos = this.size;
            }
        }
        if (this.size0 % 64 == 0) {
            this.indexCache0.set(this.size0 / 64, this.size);
        }
        int n = ci;
        this.countCache0[n] = this.countCache0[n] + 1;
        ++this.size;
    }

    @Override
    public void append1() {
        int i = this.size / 8;
        int ci = this.size / 64;
        if (i >= this.bytes.length) {
            this.extend();
        }
        if (this.size % 64 == 0 && ci > 0) {
            this.countCache0[ci] = this.countCache0[ci - 1];
        }
        int r = this.size % 8;
        int n = i;
        this.bytes[n] = (byte)(this.bytes[n] | BITS[r]);
        ++this.size;
    }

    public void append(boolean bit) {
        if (bit) {
            this.append1();
        } else {
            this.append0();
        }
    }

    @Override
    public int rank0(int pos) {
        int ret;
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return this.countCache0[cn];
        }
        ret = cn > 0 ? (ret = this.countCache0[cn - 1]) : 0;
        int n = pos / 8;
        for (int i = cn * 8; i < n; ++i) {
            ret += BITCOUNTS0[this.bytes[i] & 0xFF];
        }
        return ret + BITCOUNTS0[(this.bytes[n] | ~MASKS[pos % 8]) & 0xFF];
    }

    @Override
    public int rank1(int pos) {
        int ret = 0;
        int cn = pos / 64;
        if (cn > 0) {
            ret = cn * 64 - this.countCache0[cn - 1];
        }
        int n = pos / 8;
        for (int i = cn * 8; i < n; ++i) {
            ret += BITCOUNTS1[this.bytes[i] & 0xFF];
        }
        return ret + BITCOUNTS1[this.bytes[n] & MASKS[pos % 8]];
    }

    public int rank(int pos, boolean b) {
        if (b) {
            return this.rank1(pos);
        }
        return this.rank0(pos);
    }

    public int select0_(int count2) {
        if (count2 <= 2) {
            if (count2 == 1) {
                return this.node1pos;
            }
            return this.node2pos;
        }
        int block = count2 / 64;
        int i = this.indexCache0.get(block) / 8;
        if (i > 0) {
            count2 -= this.countCache0[(i - 1) / 64 * 8];
        }
        if (count2 > 0) {
            while (i < this.bytes.length) {
                if (i * 8 >= this.size) {
                    return -1;
                }
                byte c = BITCOUNTS0[this.bytes[i] & 0xFF];
                if (count2 <= c) {
                    int v = this.bytes[i] & 0xFF;
                    for (int j = 0; j < 8; ++j) {
                        if (i * 8 + j >= this.size) {
                            return -1;
                        }
                        if ((v & 0x80) == 0 && --count2 == 0) {
                            return i * 8 + j;
                        }
                        v <<= 1;
                    }
                }
                count2 -= c;
                ++i;
            }
        } else {
            --count2;
            int v = this.bytes[i / 8] & 0xFF;
            v >>= 8 - i % 8 - 1;
            for (i = Math.min((i + 1) * 64 - 1, this.size - 1); i >= 0; --i) {
                if ((v & 1) == 0 && ++count2 == 0) {
                    return i;
                }
                if (i % 8 == 0) {
                    v = this.bytes[(i - 1) / 8] & 0xFF;
                    continue;
                }
                v >>= 1;
            }
        }
        return -1;
    }

    @Override
    public int select0(int count2) {
        if (count2 > this.size0) {
            return -1;
        }
        if (count2 <= 3) {
            if (count2 == 1) {
                return this.node1pos;
            }
            if (count2 == 2) {
                return this.node2pos;
            }
            if (count2 == 3) {
                return this.node3pos;
            }
            return -1;
        }
        int idx = count2 / 64;
        int start = 0;
        int end = 0;
        if (idx < this.indexCache0.size()) {
            start = this.indexCache0.get(idx);
            if (count2 % 64 == 0) {
                return start;
            }
            start /= 64;
            end = idx + 1 < this.indexCache0.size() ? this.indexCache0.get(idx + 1) / 64 + 1 : UnsafeBytesSuccinctBitVector.countCache0Size(this.size);
        } else if (idx > 0) {
            start = this.indexCache0.get(idx - 1) / 64;
            end = Math.min(start + 64, UnsafeBytesSuccinctBitVector.countCache0Size(this.size));
        }
        long m = -1 * Unsafe.ARRAY_INT_INDEX_SCALE + Unsafe.ARRAY_INT_BASE_OFFSET;
        int d = 0;
        long startOffset = start * Unsafe.ARRAY_INT_INDEX_SCALE + Unsafe.ARRAY_INT_BASE_OFFSET;
        long endOffset = end * Unsafe.ARRAY_INT_INDEX_SCALE + Unsafe.ARRAY_INT_BASE_OFFSET;
        if (startOffset != endOffset) {
            do {
                if ((d = count2 - unsafe.getInt(this.countCache0, m = (startOffset + endOffset) / 2L & 0xFFFFFFFFFFFFFFFCL)) < 0) {
                    endOffset = m;
                    continue;
                }
                if (d <= 0 || startOffset == m) break;
                startOffset = m;
            } while (endOffset - startOffset >= 4L);
            if (d > 0) {
                count2 = d;
            } else {
                while (m >= (long)Unsafe.ARRAY_INT_BASE_OFFSET && count2 <= unsafe.getInt(this.countCache0, m)) {
                    m -= (long)Unsafe.ARRAY_INT_INDEX_SCALE;
                }
                if (m >= (long)Unsafe.ARRAY_INT_BASE_OFFSET) {
                    count2 -= unsafe.getInt(this.countCache0, m);
                }
            }
        }
        int n = this.bytes.length;
        for (int i = ((int)(m - (long)Unsafe.ARRAY_INT_BASE_OFFSET) / Unsafe.ARRAY_INT_INDEX_SCALE + 1) * 64 / 8; i < n; ++i) {
            int bits2 = this.bytes[i] & 0xFF;
            byte c = BITCOUNTS0[bits2];
            if (count2 <= c) {
                return i * 8 + BITPOS0[bits2][count2 - 1];
            }
            count2 -= c;
        }
        return -1;
    }

    @Override
    public int select1(int count2) {
        for (int i = 0; i < this.bytes.length; ++i) {
            if (i * 8 >= this.size) {
                return -1;
            }
            byte c = BITCOUNTS1[this.bytes[i] & 0xFF];
            if (count2 <= c) {
                int v = this.bytes[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if (i * 8 + j >= this.size) {
                        return -1;
                    }
                    if ((v & 0x80) != 0 && --count2 == 0) {
                        return i * 8 + j;
                    }
                    v <<= 1;
                }
            }
            count2 -= c;
        }
        return -1;
    }

    public int select(int count2, boolean b) {
        if (b) {
            return this.select1(count2);
        }
        return this.select0(count2);
    }

    @Override
    public int next0(int pos) {
        if (pos >= this.size) {
            return -1;
        }
        if (pos <= this.node3pos) {
            if (pos <= this.node1pos) {
                return this.node1pos;
            }
            if (pos <= this.node2pos) {
                return this.node2pos;
            }
            return this.node3pos;
        }
        int i = pos / 8;
        int s2 = pos % 8;
        if (s2 != 0) {
            for (byte b : BITPOS0[this.bytes[i] & 0xFF]) {
                if (s2 > b) continue;
                return i * 8 + b;
            }
            ++i;
        }
        int n = this.size / 8 + 1;
        while (i < n) {
            byte[] poss = BITPOS0[this.bytes[i] & 0xFF];
            if (poss.length > 0) {
                return poss[0] + i * 8;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.size = in.readInt();
        this.size0 = in.readInt();
        this.node1pos = in.readInt();
        this.node2pos = in.readInt();
        this.node3pos = in.readInt();
        int vectorSize = in.readInt();
        this.bytes = new byte[vectorSize];
        in.readFully(this.bytes, 0, vectorSize);
        int size2 = in.readInt();
        this.countCache0 = new int[size2];
        for (int i = 0; i < size2; ++i) {
            this.countCache0[i] = in.readInt();
        }
        this.indexCache0 = (IntArray)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.size0);
        out.writeInt(this.node1pos);
        out.writeInt(this.node2pos);
        out.writeInt(this.node3pos);
        this.trimToSize();
        out.writeInt(this.bytes.length);
        out.write(this.bytes);
        out.writeInt(this.countCache0.length);
        for (int e : this.countCache0) {
            out.writeInt(e);
        }
        out.writeObject(this.indexCache0);
    }

    private void extend() {
        int vectorSize = (int)((double)this.bytes.length * 1.2) + 1;
        this.bytes = Arrays.copyOf(this.bytes, vectorSize);
        this.countCache0 = Arrays.copyOf(this.countCache0, UnsafeBytesSuccinctBitVector.countCache0Size(vectorSize * 8));
    }

    private static int bytesSize(int bitSize) {
        if (bitSize == 0) {
            return 0;
        }
        return (bitSize - 1) / 8 + 1;
    }

    private static int countCache0Size(int bitSize) {
        return (bitSize - 1) / 64 + 1;
    }

    private static int initialIndexCache0Size(int bitSize) {
        if (bitSize == 0) {
            return 0;
        }
        return bitSize / 2 / 64;
    }

    public static void main(String[] args) throws Exception {
        int b;
        int count2;
        int i;
        System.out.println("\tprivate static final byte[][] BITPOS0 = {");
        for (i = 0; i < 256; ++i) {
            count2 = 0;
            System.out.print("\t\t{");
            for (b = 128; b > 0; b >>= 1) {
                if ((i & b) == 0) {
                    System.out.print(count2);
                    System.out.print(", ");
                }
                ++count2;
            }
            System.out.println("}, // " + String.format("%d(%1$x)", i));
        }
        System.out.println("\t};");
        System.out.println("\tprivate static final byte[][] BITPOS1 = {");
        for (i = 0; i < 256; ++i) {
            count2 = 0;
            System.out.print("\t\t{");
            for (b = 128; b > 0; b >>= 1) {
                if ((i & b) != 0) {
                    System.out.print(count2);
                    System.out.print(", ");
                }
                ++count2;
            }
            System.out.println("}, // " + String.format("%d(%1$x)", i));
        }
        System.out.println("\t};");
    }

    static {
        try {
            Field field2 = Unsafe.class.getDeclaredField("theUnsafe");
            field2.setAccessible(true);
            unsafe = (Unsafe)field2.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

