/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import java.io.Serializable;
import java.util.Arrays;
import org.trie4j.bv.LongsRank1OnlySuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;

public class LongsConstantTimeSelect0SuccinctBitVector
implements Serializable,
SuccinctBitVector {
    static final int BITS_IN_BLOCK = 64;
    static final int BITS_IN_COUNTCACHE0 = 64;
    private long[] longs;
    private int size;
    private int size0;
    private int node1pos = -1;
    private int node2pos = -1;
    private int node3pos = -1;
    private int[] countCache0;
    private SuccinctBitVector bvD;
    private boolean first0bitInBlock = true;
    private boolean prevBsC;
    private boolean currentBsC;
    private SuccinctBitVector bvR;
    private int[] arS;
    private int arSSize;
    private static final byte[][] BITPOS0 = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 7}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 6, 7}, {0, 1, 2, 3, 4, 6}, {0, 1, 2, 3, 4, 7}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 5, 6, 7}, {0, 1, 2, 3, 5, 6}, {0, 1, 2, 3, 5, 7}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 6, 7}, {0, 1, 2, 3, 6}, {0, 1, 2, 3, 7}, {0, 1, 2, 3}, {0, 1, 2, 4, 5, 6, 7}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 4, 5, 7}, {0, 1, 2, 4, 5}, {0, 1, 2, 4, 6, 7}, {0, 1, 2, 4, 6}, {0, 1, 2, 4, 7}, {0, 1, 2, 4}, {0, 1, 2, 5, 6, 7}, {0, 1, 2, 5, 6}, {0, 1, 2, 5, 7}, {0, 1, 2, 5}, {0, 1, 2, 6, 7}, {0, 1, 2, 6}, {0, 1, 2, 7}, {0, 1, 2}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6}, {0, 1, 3, 4, 5, 7}, {0, 1, 3, 4, 5}, {0, 1, 3, 4, 6, 7}, {0, 1, 3, 4, 6}, {0, 1, 3, 4, 7}, {0, 1, 3, 4}, {0, 1, 3, 5, 6, 7}, {0, 1, 3, 5, 6}, {0, 1, 3, 5, 7}, {0, 1, 3, 5}, {0, 1, 3, 6, 7}, {0, 1, 3, 6}, {0, 1, 3, 7}, {0, 1, 3}, {0, 1, 4, 5, 6, 7}, {0, 1, 4, 5, 6}, {0, 1, 4, 5, 7}, {0, 1, 4, 5}, {0, 1, 4, 6, 7}, {0, 1, 4, 6}, {0, 1, 4, 7}, {0, 1, 4}, {0, 1, 5, 6, 7}, {0, 1, 5, 6}, {0, 1, 5, 7}, {0, 1, 5}, {0, 1, 6, 7}, {0, 1, 6}, {0, 1, 7}, {0, 1}, {0, 2, 3, 4, 5, 6, 7}, {0, 2, 3, 4, 5, 6}, {0, 2, 3, 4, 5, 7}, {0, 2, 3, 4, 5}, {0, 2, 3, 4, 6, 7}, {0, 2, 3, 4, 6}, {0, 2, 3, 4, 7}, {0, 2, 3, 4}, {0, 2, 3, 5, 6, 7}, {0, 2, 3, 5, 6}, {0, 2, 3, 5, 7}, {0, 2, 3, 5}, {0, 2, 3, 6, 7}, {0, 2, 3, 6}, {0, 2, 3, 7}, {0, 2, 3}, {0, 2, 4, 5, 6, 7}, {0, 2, 4, 5, 6}, {0, 2, 4, 5, 7}, {0, 2, 4, 5}, {0, 2, 4, 6, 7}, {0, 2, 4, 6}, {0, 2, 4, 7}, {0, 2, 4}, {0, 2, 5, 6, 7}, {0, 2, 5, 6}, {0, 2, 5, 7}, {0, 2, 5}, {0, 2, 6, 7}, {0, 2, 6}, {0, 2, 7}, {0, 2}, {0, 3, 4, 5, 6, 7}, {0, 3, 4, 5, 6}, {0, 3, 4, 5, 7}, {0, 3, 4, 5}, {0, 3, 4, 6, 7}, {0, 3, 4, 6}, {0, 3, 4, 7}, {0, 3, 4}, {0, 3, 5, 6, 7}, {0, 3, 5, 6}, {0, 3, 5, 7}, {0, 3, 5}, {0, 3, 6, 7}, {0, 3, 6}, {0, 3, 7}, {0, 3}, {0, 4, 5, 6, 7}, {0, 4, 5, 6}, {0, 4, 5, 7}, {0, 4, 5}, {0, 4, 6, 7}, {0, 4, 6}, {0, 4, 7}, {0, 4}, {0, 5, 6, 7}, {0, 5, 6}, {0, 5, 7}, {0, 5}, {0, 6, 7}, {0, 6}, {0, 7}, {0}, {1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6}, {1, 2, 3, 4, 5, 7}, {1, 2, 3, 4, 5}, {1, 2, 3, 4, 6, 7}, {1, 2, 3, 4, 6}, {1, 2, 3, 4, 7}, {1, 2, 3, 4}, {1, 2, 3, 5, 6, 7}, {1, 2, 3, 5, 6}, {1, 2, 3, 5, 7}, {1, 2, 3, 5}, {1, 2, 3, 6, 7}, {1, 2, 3, 6}, {1, 2, 3, 7}, {1, 2, 3}, {1, 2, 4, 5, 6, 7}, {1, 2, 4, 5, 6}, {1, 2, 4, 5, 7}, {1, 2, 4, 5}, {1, 2, 4, 6, 7}, {1, 2, 4, 6}, {1, 2, 4, 7}, {1, 2, 4}, {1, 2, 5, 6, 7}, {1, 2, 5, 6}, {1, 2, 5, 7}, {1, 2, 5}, {1, 2, 6, 7}, {1, 2, 6}, {1, 2, 7}, {1, 2}, {1, 3, 4, 5, 6, 7}, {1, 3, 4, 5, 6}, {1, 3, 4, 5, 7}, {1, 3, 4, 5}, {1, 3, 4, 6, 7}, {1, 3, 4, 6}, {1, 3, 4, 7}, {1, 3, 4}, {1, 3, 5, 6, 7}, {1, 3, 5, 6}, {1, 3, 5, 7}, {1, 3, 5}, {1, 3, 6, 7}, {1, 3, 6}, {1, 3, 7}, {1, 3}, {1, 4, 5, 6, 7}, {1, 4, 5, 6}, {1, 4, 5, 7}, {1, 4, 5}, {1, 4, 6, 7}, {1, 4, 6}, {1, 4, 7}, {1, 4}, {1, 5, 6, 7}, {1, 5, 6}, {1, 5, 7}, {1, 5}, {1, 6, 7}, {1, 6}, {1, 7}, {1}, {2, 3, 4, 5, 6, 7}, {2, 3, 4, 5, 6}, {2, 3, 4, 5, 7}, {2, 3, 4, 5}, {2, 3, 4, 6, 7}, {2, 3, 4, 6}, {2, 3, 4, 7}, {2, 3, 4}, {2, 3, 5, 6, 7}, {2, 3, 5, 6}, {2, 3, 5, 7}, {2, 3, 5}, {2, 3, 6, 7}, {2, 3, 6}, {2, 3, 7}, {2, 3}, {2, 4, 5, 6, 7}, {2, 4, 5, 6}, {2, 4, 5, 7}, {2, 4, 5}, {2, 4, 6, 7}, {2, 4, 6}, {2, 4, 7}, {2, 4}, {2, 5, 6, 7}, {2, 5, 6}, {2, 5, 7}, {2, 5}, {2, 6, 7}, {2, 6}, {2, 7}, {2}, {3, 4, 5, 6, 7}, {3, 4, 5, 6}, {3, 4, 5, 7}, {3, 4, 5}, {3, 4, 6, 7}, {3, 4, 6}, {3, 4, 7}, {3, 4}, {3, 5, 6, 7}, {3, 5, 6}, {3, 5, 7}, {3, 5}, {3, 6, 7}, {3, 6}, {3, 7}, {3}, {4, 5, 6, 7}, {4, 5, 6}, {4, 5, 7}, {4, 5}, {4, 6, 7}, {4, 6}, {4, 7}, {4}, {5, 6, 7}, {5, 6}, {5, 7}, {5}, {6, 7}, {6}, {7}, new byte[0]};
    private static final long serialVersionUID = -7658605229245494623L;

    public LongsConstantTimeSelect0SuccinctBitVector() {
        this(16);
    }

    public LongsConstantTimeSelect0SuccinctBitVector(int initialCapacity) {
        if (initialCapacity == 0) {
            this.longs = new long[0];
            this.countCache0 = new int[0];
        } else {
            this.longs = new long[LongsConstantTimeSelect0SuccinctBitVector.longsSize(initialCapacity)];
            this.countCache0 = new int[LongsConstantTimeSelect0SuccinctBitVector.countCache0Size(initialCapacity)];
        }
        this.bvD = new LongsRank1OnlySuccinctBitVector();
        this.bvR = new LongsRank1OnlySuccinctBitVector();
        this.arS = new int[]{0};
        this.arSSize = 1;
    }

    public LongsConstantTimeSelect0SuccinctBitVector(byte[] bytes2, int bitsSize) {
        this.size = bitsSize;
        this.longs = new long[LongsConstantTimeSelect0SuccinctBitVector.longsSize(bitsSize)];
        this.countCache0 = new int[LongsConstantTimeSelect0SuccinctBitVector.countCache0Size(bitsSize)];
        this.bvD = new LongsRank1OnlySuccinctBitVector();
        this.bvR = new LongsRank1OnlySuccinctBitVector();
        this.arS = new int[]{0};
        this.arSSize = 1;
        int n = bytes2.length;
        for (int i = 0; i < n; ++i) {
            int j;
            int b = bytes2[i] & 0xFF;
            int n2 = i / 8;
            this.longs[n2] = this.longs[n2] | (long)b << (7 - i % 8) * 8;
            byte[] zeroPosInB = BITPOS0[b];
            int rest = bitsSize - i * 8;
            if (rest < 8) {
                int nz = zeroPosInB.length;
                for (j = 0; j < nz; ++j) {
                    if (zeroPosInB[j] < rest) continue;
                    zeroPosInB = Arrays.copyOf(zeroPosInB, j);
                    break;
                }
            }
            int zeroCount = zeroPosInB.length;
            if (this.size0 < 3 && zeroCount > 0) {
                if (this.size0 == 0) {
                    this.node1pos = zeroPosInB[0] + 8 * i;
                    if (zeroPosInB.length > 1) {
                        this.node2pos = zeroPosInB[1] + 8 * i;
                    }
                    if (zeroPosInB.length > 2) {
                        this.node3pos = zeroPosInB[2] + 8 * i;
                    }
                } else if (this.size0 == 1) {
                    this.node2pos = zeroPosInB[0] + 8 * i;
                    if (zeroPosInB.length > 1) {
                        this.node3pos = zeroPosInB[1] + 8 * i;
                    }
                } else {
                    this.node3pos = zeroPosInB[0] + 8 * i;
                }
            }
            this.prevBsC = this.currentBsC;
            if (zeroPosInB.length > 0) {
                this.bvD.append1();
                for (j = 1; j < zeroPosInB.length; ++j) {
                    this.bvD.append0();
                }
                this.currentBsC = true;
                if (this.prevBsC) {
                    this.bvR.append0();
                } else {
                    this.bvR.append1();
                    this.addArS();
                }
            } else {
                this.currentBsC = false;
                int n3 = this.arSSize - 1;
                this.arS[n3] = this.arS[n3] + 1;
            }
            this.size0 += zeroCount;
            if ((i + 1) % 8 == 0) {
                this.countCache0[i / 8] = this.size0;
            }
            if (rest < 8) break;
        }
        this.countCache0[(this.size - 1) / 64] = this.size0;
    }

    public LongsConstantTimeSelect0SuccinctBitVector(long[] longs, int size2, int size0, int node1pos, int node2pos, int node3pos, int[] countCache0, SuccinctBitVector bvD, boolean first0bitInBlock, boolean prevBsC, boolean currentBsC, SuccinctBitVector bvR, int[] arS, int arSSize) {
        this.longs = longs;
        this.size = size2;
        this.size0 = size0;
        this.node1pos = node1pos;
        this.node2pos = node2pos;
        this.node3pos = node3pos;
        this.countCache0 = countCache0;
        this.bvD = bvD;
        this.first0bitInBlock = first0bitInBlock;
        this.prevBsC = prevBsC;
        this.currentBsC = currentBsC;
        this.bvR = bvR;
        this.arS = arS;
        this.arSSize = arSSize;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int n = Math.min(this.size, 64);
        for (int i = 0; i < n; ++i) {
            long m = Long.MIN_VALUE >>> i % 64;
            long bi = this.longs[i / 64] & m;
            b.append(bi != 0L ? "1" : "0");
        }
        return b.toString();
    }

    public long[] getLongs() {
        return this.longs;
    }

    public int[] getCountCache0() {
        return this.countCache0;
    }

    public SuccinctBitVector getBvD() {
        return this.bvD;
    }

    public SuccinctBitVector getBvR() {
        return this.bvR;
    }

    public int[] getArS() {
        return this.arS;
    }

    public int getArSSize() {
        return this.arSSize;
    }

    @Override
    public boolean get(int pos) {
        return this.isOne(pos);
    }

    @Override
    public boolean isZero(int pos) {
        return (this.longs[pos / 64] & Long.MIN_VALUE >>> pos % 64) == 0L;
    }

    @Override
    public boolean isOne(int pos) {
        return (this.longs[pos / 64] & Long.MIN_VALUE >>> pos % 64) != 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getSize0() {
        return this.size0;
    }

    public int getNode1pos() {
        return this.node1pos;
    }

    public int getNode2pos() {
        return this.node2pos;
    }

    public int getNode3pos() {
        return this.node3pos;
    }

    @Override
    public void trimToSize() {
        this.longs = Arrays.copyOf(this.longs, LongsConstantTimeSelect0SuccinctBitVector.longsSize(this.size));
        this.countCache0 = Arrays.copyOf(this.countCache0, LongsConstantTimeSelect0SuccinctBitVector.countCache0Size(this.size));
        this.bvD.trimToSize();
        this.bvR.trimToSize();
        this.arS = Arrays.copyOf(this.arS, this.arSSize);
    }

    @Override
    public void append0() {
        int blockIndex = this.size / 64;
        int cacheBlockIndex = this.size / 64;
        int indexInCacheBlock = this.size % 64;
        if (blockIndex >= this.longs.length) {
            this.extendLongsAndCountCache0();
        }
        if (indexInCacheBlock == 0 && cacheBlockIndex > 0) {
            this.countCache0[cacheBlockIndex] = this.countCache0[cacheBlockIndex - 1];
        }
        ++this.size0;
        switch (this.size0) {
            case 1: {
                this.node1pos = this.size;
                break;
            }
            case 2: {
                this.node2pos = this.size;
                break;
            }
            case 3: {
                this.node3pos = this.size;
            }
        }
        int n = cacheBlockIndex;
        this.countCache0[n] = this.countCache0[n] + 1;
        if (this.first0bitInBlock) {
            this.bvD.append1();
            this.first0bitInBlock = false;
        } else {
            this.bvD.append0();
        }
        if (this.size % 8 == 0) {
            if (this.bvR.size() == 0 || !this.currentBsC) {
                this.bvR.append1();
                this.addArS();
            } else {
                this.bvR.append0();
            }
            this.prevBsC = this.currentBsC;
            this.currentBsC = true;
        } else if (!this.currentBsC) {
            if (this.bvR.size() == 0 || !this.prevBsC) {
                this.bvR.append1();
            } else {
                this.bvR.append0();
            }
            int n2 = this.arSSize - 1;
            this.arS[n2] = this.arS[n2] - 1;
            if (!this.prevBsC) {
                this.addArS();
            }
            this.currentBsC = true;
        }
        ++this.size;
        if (this.size % 8 == 0) {
            this.first0bitInBlock = true;
        }
    }

    @Override
    public void append1() {
        int blockIndex = this.size / 64;
        int cacheBlockIndex = this.size / 64;
        if (blockIndex >= this.longs.length) {
            this.extendLongsAndCountCache0();
        }
        if (this.size % 64 == 0 && cacheBlockIndex > 0) {
            this.countCache0[cacheBlockIndex] = this.countCache0[cacheBlockIndex - 1];
        }
        int n = blockIndex;
        this.longs[n] = this.longs[n] | Long.MIN_VALUE >>> this.size % 64;
        if (this.size % 8 == 0) {
            this.prevBsC = this.currentBsC;
            this.currentBsC = false;
            int n2 = this.arSSize - 1;
            this.arS[n2] = this.arS[n2] + 1;
        }
        ++this.size;
        if (this.size % 8 == 0) {
            this.first0bitInBlock = true;
        }
    }

    public void append(boolean bit) {
        if (bit) {
            this.append1();
        } else {
            this.append0();
        }
    }

    @Override
    public int rank0(int pos) {
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return this.countCache0[cn];
        }
        int ret = cn > 0 ? this.countCache0[cn - 1] : 0;
        int n = pos / 64;
        for (int i = cn * 64 / 64; i < n; ++i) {
            ret += Long.bitCount(this.longs[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return ret + Long.bitCount((this.longs[n] ^ 0xFFFFFFFFFFFFFFFFL) & Long.MIN_VALUE >> pos % 64);
    }

    @Override
    public int rank1(int pos) {
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return (cn + 1) * 64 - this.countCache0[cn];
        }
        int ret = cn > 0 ? cn * 64 - this.countCache0[cn - 1] : 0;
        int n = pos / 64;
        for (int i = cn * 64 / 64; i < n; ++i) {
            ret += Long.bitCount(this.longs[i]);
        }
        return ret + Long.bitCount(this.longs[n] & Long.MIN_VALUE >> pos % 64);
    }

    public int rank(int pos, boolean b) {
        if (b) {
            return this.rank1(pos);
        }
        return this.rank0(pos);
    }

    @Override
    public int select0(int count2) {
        if (count2 > this.size0) {
            return -1;
        }
        if (count2 <= 3) {
            if (count2 == 1) {
                return this.node1pos;
            }
            if (count2 == 2) {
                return this.node2pos;
            }
            if (count2 == 3) {
                return this.node3pos;
            }
            return -1;
        }
        int c = count2 - 1;
        int ci = this.bvD.rank1(c) - 1;
        int u = ci + this.arS[this.bvR.rank1(ci) - 1];
        if (u != 0) {
            int ui = u * 8;
            int r = this.rank0(ui - 1);
            int bi = u % 8;
            return ui + BITPOS0[(int)(this.longs[u / 8] >>> (7 - bi) * 8 & 0xFFL)][c - r];
        }
        return BITPOS0[(int)(this.longs[0] >>> 56 & 0xFFL)][c];
    }

    @Override
    public int select1(int count2) {
        for (int i = 0; i < this.longs.length; ++i) {
            if (i * 64 >= this.size) {
                return -1;
            }
            long v = this.longs[i];
            int c = Long.bitCount(v);
            if (count2 <= c) {
                for (int j = 0; j < 64; ++j) {
                    if (i * 64 + j >= this.size) {
                        return -1;
                    }
                    if ((v & Long.MIN_VALUE) != 0L && --count2 == 0) {
                        return i * 64 + j;
                    }
                    v <<= 1;
                }
                return -1;
            }
            count2 -= c;
        }
        return -1;
    }

    public int select(int count2, boolean b) {
        if (b) {
            return this.select1(count2);
        }
        return this.select0(count2);
    }

    @Override
    public int next0(int pos) {
        long v;
        if (pos >= this.size) {
            return -1;
        }
        if (pos <= this.node3pos) {
            if (pos <= this.node1pos) {
                return this.node1pos;
            }
            if (pos <= this.node2pos) {
                return this.node2pos;
            }
            return this.node3pos;
        }
        int longsi = pos / 64;
        int s2 = pos % 64;
        int n = this.longs.length - 1;
        if (longsi < n) {
            int i;
            v = this.longs[longsi] << s2;
            for (i = s2; i < 64; ++i) {
                if (v >= 0L) {
                    return longsi * 64 + i;
                }
                v <<= 1;
            }
            ++longsi;
            s2 = 0;
            while (longsi < n) {
                v = this.longs[longsi];
                if (Long.bitCount(v) != 64) {
                    for (i = 0; i < 64; ++i) {
                        if (v >= 0L) {
                            return longsi * 64 + i;
                        }
                        v <<= 1;
                    }
                }
                ++longsi;
            }
        }
        if (Long.bitCount(v = this.longs[longsi] << s2) != 64 - s2) {
            int in = this.size % 64;
            for (int i = s2; i < in; ++i) {
                if (v >= 0L) {
                    return longsi * 64 + i;
                }
                v <<= 1;
            }
        }
        return -1;
    }

    private void extendLongsAndCountCache0() {
        int longsSize = (int)((double)this.longs.length * 1.2) + 1;
        this.longs = Arrays.copyOf(this.longs, longsSize);
        this.countCache0 = Arrays.copyOf(this.countCache0, LongsConstantTimeSelect0SuccinctBitVector.countCache0Size(longsSize * 64));
    }

    private void addArS() {
        if (this.arSSize == this.arS.length) {
            this.arS = Arrays.copyOf(this.arS, (int)((double)this.arSSize * 1.2) + 1);
        }
        if (this.arSSize > 0) {
            this.arS[this.arSSize] = this.arS[this.arSSize - 1];
        }
        ++this.arSSize;
    }

    private static int longsSize(int bitSize) {
        return (bitSize - 1) / 64 + 1;
    }

    private static int countCache0Size(int bitSize) {
        return (bitSize - 1) / 64 + 1;
    }
}

