/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.trie4j.bv.BytesRank1OnlySuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;

public class BytesConstantTimeSelect0SuccinctBitVector
implements Externalizable,
SuccinctBitVector {
    private static final int BITS_IN_BYTE = 8;
    private static final int CACHE_WIDTH = 64;
    private byte[] bytes;
    private int size;
    private int size0;
    private int node1pos = -1;
    private int node2pos = -1;
    private int node3pos = -1;
    private int[] countCache0;
    private SuccinctBitVector bvD;
    private boolean first0bitInBlock = true;
    private boolean prevBsC;
    private boolean currentBsC;
    private SuccinctBitVector bvR;
    private int[] arS;
    private int arSSize;
    private static final int[] MASKS = new int[]{128, 192, 224, 240, 248, 252, 254, 255};
    private static final byte[] BITS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte[] BITCOUNTS1 = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final byte[] BITCOUNTS0 = new byte[]{8, 7, 7, 6, 7, 6, 6, 5, 7, 6, 6, 5, 6, 5, 5, 4, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 4, 3, 3, 2, 3, 2, 2, 1, 3, 2, 2, 1, 2, 1, 1, 0};
    private static final byte[][] BITPOS0 = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 7}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 6, 7}, {0, 1, 2, 3, 4, 6}, {0, 1, 2, 3, 4, 7}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 5, 6, 7}, {0, 1, 2, 3, 5, 6}, {0, 1, 2, 3, 5, 7}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 6, 7}, {0, 1, 2, 3, 6}, {0, 1, 2, 3, 7}, {0, 1, 2, 3}, {0, 1, 2, 4, 5, 6, 7}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 4, 5, 7}, {0, 1, 2, 4, 5}, {0, 1, 2, 4, 6, 7}, {0, 1, 2, 4, 6}, {0, 1, 2, 4, 7}, {0, 1, 2, 4}, {0, 1, 2, 5, 6, 7}, {0, 1, 2, 5, 6}, {0, 1, 2, 5, 7}, {0, 1, 2, 5}, {0, 1, 2, 6, 7}, {0, 1, 2, 6}, {0, 1, 2, 7}, {0, 1, 2}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6}, {0, 1, 3, 4, 5, 7}, {0, 1, 3, 4, 5}, {0, 1, 3, 4, 6, 7}, {0, 1, 3, 4, 6}, {0, 1, 3, 4, 7}, {0, 1, 3, 4}, {0, 1, 3, 5, 6, 7}, {0, 1, 3, 5, 6}, {0, 1, 3, 5, 7}, {0, 1, 3, 5}, {0, 1, 3, 6, 7}, {0, 1, 3, 6}, {0, 1, 3, 7}, {0, 1, 3}, {0, 1, 4, 5, 6, 7}, {0, 1, 4, 5, 6}, {0, 1, 4, 5, 7}, {0, 1, 4, 5}, {0, 1, 4, 6, 7}, {0, 1, 4, 6}, {0, 1, 4, 7}, {0, 1, 4}, {0, 1, 5, 6, 7}, {0, 1, 5, 6}, {0, 1, 5, 7}, {0, 1, 5}, {0, 1, 6, 7}, {0, 1, 6}, {0, 1, 7}, {0, 1}, {0, 2, 3, 4, 5, 6, 7}, {0, 2, 3, 4, 5, 6}, {0, 2, 3, 4, 5, 7}, {0, 2, 3, 4, 5}, {0, 2, 3, 4, 6, 7}, {0, 2, 3, 4, 6}, {0, 2, 3, 4, 7}, {0, 2, 3, 4}, {0, 2, 3, 5, 6, 7}, {0, 2, 3, 5, 6}, {0, 2, 3, 5, 7}, {0, 2, 3, 5}, {0, 2, 3, 6, 7}, {0, 2, 3, 6}, {0, 2, 3, 7}, {0, 2, 3}, {0, 2, 4, 5, 6, 7}, {0, 2, 4, 5, 6}, {0, 2, 4, 5, 7}, {0, 2, 4, 5}, {0, 2, 4, 6, 7}, {0, 2, 4, 6}, {0, 2, 4, 7}, {0, 2, 4}, {0, 2, 5, 6, 7}, {0, 2, 5, 6}, {0, 2, 5, 7}, {0, 2, 5}, {0, 2, 6, 7}, {0, 2, 6}, {0, 2, 7}, {0, 2}, {0, 3, 4, 5, 6, 7}, {0, 3, 4, 5, 6}, {0, 3, 4, 5, 7}, {0, 3, 4, 5}, {0, 3, 4, 6, 7}, {0, 3, 4, 6}, {0, 3, 4, 7}, {0, 3, 4}, {0, 3, 5, 6, 7}, {0, 3, 5, 6}, {0, 3, 5, 7}, {0, 3, 5}, {0, 3, 6, 7}, {0, 3, 6}, {0, 3, 7}, {0, 3}, {0, 4, 5, 6, 7}, {0, 4, 5, 6}, {0, 4, 5, 7}, {0, 4, 5}, {0, 4, 6, 7}, {0, 4, 6}, {0, 4, 7}, {0, 4}, {0, 5, 6, 7}, {0, 5, 6}, {0, 5, 7}, {0, 5}, {0, 6, 7}, {0, 6}, {0, 7}, {0}, {1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6}, {1, 2, 3, 4, 5, 7}, {1, 2, 3, 4, 5}, {1, 2, 3, 4, 6, 7}, {1, 2, 3, 4, 6}, {1, 2, 3, 4, 7}, {1, 2, 3, 4}, {1, 2, 3, 5, 6, 7}, {1, 2, 3, 5, 6}, {1, 2, 3, 5, 7}, {1, 2, 3, 5}, {1, 2, 3, 6, 7}, {1, 2, 3, 6}, {1, 2, 3, 7}, {1, 2, 3}, {1, 2, 4, 5, 6, 7}, {1, 2, 4, 5, 6}, {1, 2, 4, 5, 7}, {1, 2, 4, 5}, {1, 2, 4, 6, 7}, {1, 2, 4, 6}, {1, 2, 4, 7}, {1, 2, 4}, {1, 2, 5, 6, 7}, {1, 2, 5, 6}, {1, 2, 5, 7}, {1, 2, 5}, {1, 2, 6, 7}, {1, 2, 6}, {1, 2, 7}, {1, 2}, {1, 3, 4, 5, 6, 7}, {1, 3, 4, 5, 6}, {1, 3, 4, 5, 7}, {1, 3, 4, 5}, {1, 3, 4, 6, 7}, {1, 3, 4, 6}, {1, 3, 4, 7}, {1, 3, 4}, {1, 3, 5, 6, 7}, {1, 3, 5, 6}, {1, 3, 5, 7}, {1, 3, 5}, {1, 3, 6, 7}, {1, 3, 6}, {1, 3, 7}, {1, 3}, {1, 4, 5, 6, 7}, {1, 4, 5, 6}, {1, 4, 5, 7}, {1, 4, 5}, {1, 4, 6, 7}, {1, 4, 6}, {1, 4, 7}, {1, 4}, {1, 5, 6, 7}, {1, 5, 6}, {1, 5, 7}, {1, 5}, {1, 6, 7}, {1, 6}, {1, 7}, {1}, {2, 3, 4, 5, 6, 7}, {2, 3, 4, 5, 6}, {2, 3, 4, 5, 7}, {2, 3, 4, 5}, {2, 3, 4, 6, 7}, {2, 3, 4, 6}, {2, 3, 4, 7}, {2, 3, 4}, {2, 3, 5, 6, 7}, {2, 3, 5, 6}, {2, 3, 5, 7}, {2, 3, 5}, {2, 3, 6, 7}, {2, 3, 6}, {2, 3, 7}, {2, 3}, {2, 4, 5, 6, 7}, {2, 4, 5, 6}, {2, 4, 5, 7}, {2, 4, 5}, {2, 4, 6, 7}, {2, 4, 6}, {2, 4, 7}, {2, 4}, {2, 5, 6, 7}, {2, 5, 6}, {2, 5, 7}, {2, 5}, {2, 6, 7}, {2, 6}, {2, 7}, {2}, {3, 4, 5, 6, 7}, {3, 4, 5, 6}, {3, 4, 5, 7}, {3, 4, 5}, {3, 4, 6, 7}, {3, 4, 6}, {3, 4, 7}, {3, 4}, {3, 5, 6, 7}, {3, 5, 6}, {3, 5, 7}, {3, 5}, {3, 6, 7}, {3, 6}, {3, 7}, {3}, {4, 5, 6, 7}, {4, 5, 6}, {4, 5, 7}, {4, 5}, {4, 6, 7}, {4, 6}, {4, 7}, {4}, {5, 6, 7}, {5, 6}, {5, 7}, {5}, {6, 7}, {6}, {7}, new byte[0]};
    private static final long serialVersionUID = -7658605229245494623L;

    public BytesConstantTimeSelect0SuccinctBitVector() {
        this(16);
    }

    public BytesConstantTimeSelect0SuccinctBitVector(int initialCapacity) {
        this.bytes = new byte[BytesConstantTimeSelect0SuccinctBitVector.bytesSize(initialCapacity)];
        this.countCache0 = new int[BytesConstantTimeSelect0SuccinctBitVector.countCache0Size(initialCapacity)];
        this.bvD = new BytesRank1OnlySuccinctBitVector();
        this.bvR = new BytesRank1OnlySuccinctBitVector();
        this.arS = new int[]{0};
        this.arSSize = 1;
    }

    public BytesConstantTimeSelect0SuccinctBitVector(byte[] bytes2, int bitsSize) {
        this.size = bitsSize;
        this.bytes = Arrays.copyOf(bytes2, BytesConstantTimeSelect0SuccinctBitVector.bytesSize(bitsSize));
        this.countCache0 = new int[BytesConstantTimeSelect0SuccinctBitVector.countCache0Size(bitsSize)];
        this.bvD = new BytesRank1OnlySuccinctBitVector();
        this.bvR = new BytesRank1OnlySuccinctBitVector();
        this.arS = new int[]{0};
        this.arSSize = 1;
        int n = bytes2.length;
        for (int i = 0; i < n; ++i) {
            int j;
            int b = bytes2[i] & 0xFF;
            byte[] zeroPosInB = BITPOS0[b];
            int rest = bitsSize - i * 8;
            if (rest < 8) {
                int nz = zeroPosInB.length;
                for (j = 0; j < nz; ++j) {
                    if (zeroPosInB[j] < rest) continue;
                    zeroPosInB = Arrays.copyOf(zeroPosInB, j);
                    break;
                }
            }
            int zeroCount = zeroPosInB.length;
            if (this.size0 < 3 && zeroCount > 0) {
                if (this.size0 == 0) {
                    this.node1pos = zeroPosInB[0] + 8 * i;
                    if (zeroPosInB.length > 1) {
                        this.node2pos = zeroPosInB[1] + 8 * i;
                    }
                    if (zeroPosInB.length > 2) {
                        this.node3pos = zeroPosInB[2] + 8 * i;
                    }
                } else if (this.size0 == 1) {
                    this.node2pos = zeroPosInB[0] + 8 * i;
                    if (zeroPosInB.length > 1) {
                        this.node3pos = zeroPosInB[1] + 8 * i;
                    }
                } else {
                    this.node3pos = zeroPosInB[0] + 8 * i;
                }
            }
            this.prevBsC = this.currentBsC;
            if (zeroPosInB.length > 0) {
                this.bvD.append1();
                for (j = 1; j < zeroPosInB.length; ++j) {
                    this.bvD.append0();
                }
                this.currentBsC = true;
                if (this.prevBsC) {
                    this.bvR.append0();
                } else {
                    this.bvR.append1();
                    this.addArS();
                }
            } else {
                this.currentBsC = false;
                int n2 = this.arSSize - 1;
                this.arS[n2] = this.arS[n2] + 1;
            }
            this.size0 += zeroCount;
            if ((i + 1) % 8 == 0) {
                this.countCache0[i / 8] = this.size0;
            }
            if (rest < 8) break;
        }
        this.countCache0[(this.size - 1) / 64] = this.size0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int n = Math.min(this.size, 32);
        for (int i = 0; i < n; ++i) {
            b.append((this.bytes[i / 8] & 128 >> i % 8) != 0 ? "1" : "0");
        }
        return b.toString();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int[] getCountCache0() {
        return this.countCache0;
    }

    @Override
    public boolean get(int pos) {
        return this.isOne(pos);
    }

    @Override
    public boolean isZero(int pos) {
        return (this.bytes[pos / 8] & BITS[pos % 8]) == 0;
    }

    @Override
    public boolean isOne(int pos) {
        return (this.bytes[pos / 8] & BITS[pos % 8]) != 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getSize0() {
        return this.size0;
    }

    public BytesConstantTimeSelect0SuccinctBitVector(byte[] bytes2, int size2, int size0, int node1pos, int node2pos, int node3pos, int[] countCache0, SuccinctBitVector bvD, SuccinctBitVector bvR, boolean first0bitInBlock, boolean prevBsC, boolean currentBsC, int[] arS, int arSSize) {
        this.bytes = bytes2;
        this.size = size2;
        this.size0 = size0;
        this.node1pos = node1pos;
        this.node2pos = node2pos;
        this.node3pos = node3pos;
        this.countCache0 = countCache0;
        this.bvD = bvD;
        this.bvR = bvR;
        this.first0bitInBlock = first0bitInBlock;
        this.prevBsC = prevBsC;
        this.currentBsC = currentBsC;
        this.arS = arS;
        this.arSSize = arSSize;
    }

    public int getNode1pos() {
        return this.node1pos;
    }

    public int getNode2pos() {
        return this.node2pos;
    }

    public int getNode3pos() {
        return this.node3pos;
    }

    public SuccinctBitVector getBvD() {
        return this.bvD;
    }

    public SuccinctBitVector getBvR() {
        return this.bvR;
    }

    public int[] getArS() {
        return this.arS;
    }

    public int getArSSize() {
        return this.arSSize;
    }

    @Override
    public void trimToSize() {
        this.bytes = Arrays.copyOf(this.bytes, BytesConstantTimeSelect0SuccinctBitVector.bytesSize(this.size));
        this.countCache0 = Arrays.copyOf(this.countCache0, BytesConstantTimeSelect0SuccinctBitVector.countCache0Size(this.size));
        this.bvD.trimToSize();
        this.bvR.trimToSize();
        this.arS = Arrays.copyOf(this.arS, this.arSSize);
    }

    @Override
    public void append1() {
        int blockIndex = this.size / 8;
        int indexInBlock = this.size % 8;
        int cacheBlockIndex = this.size / 64;
        if (blockIndex >= this.bytes.length) {
            this.extend();
        }
        if (this.size % 64 == 0 && cacheBlockIndex > 0) {
            this.countCache0[cacheBlockIndex] = this.countCache0[cacheBlockIndex - 1];
        }
        int n = blockIndex;
        this.bytes[n] = (byte)(this.bytes[n] | BITS[indexInBlock]);
        if (indexInBlock == 0) {
            this.prevBsC = this.currentBsC;
            this.currentBsC = false;
            int n2 = this.arSSize - 1;
            this.arS[n2] = this.arS[n2] + 1;
        }
        ++this.size;
        if (this.size % 8 == 0) {
            this.first0bitInBlock = true;
        }
    }

    @Override
    public void append0() {
        int blockIndex = this.size / 8;
        int indexInBlock = this.size % 8;
        int cacheBlockIndex = this.size / 64;
        int indexInCacheBlock = this.size % 64;
        if (blockIndex >= this.bytes.length) {
            this.extend();
        }
        if (indexInCacheBlock == 0 && cacheBlockIndex > 0) {
            this.countCache0[cacheBlockIndex] = this.countCache0[cacheBlockIndex - 1];
        }
        ++this.size0;
        switch (this.size0) {
            case 1: {
                this.node1pos = this.size;
                break;
            }
            case 2: {
                this.node2pos = this.size;
                break;
            }
            case 3: {
                this.node3pos = this.size;
            }
        }
        int n = cacheBlockIndex;
        this.countCache0[n] = this.countCache0[n] + 1;
        if (this.first0bitInBlock) {
            this.bvD.append1();
            this.first0bitInBlock = false;
        } else {
            this.bvD.append0();
        }
        if (indexInBlock == 0) {
            if (this.bvR.size() == 0 || !this.currentBsC) {
                this.bvR.append1();
                this.addArS();
            } else {
                this.bvR.append0();
            }
            this.prevBsC = this.currentBsC;
            this.currentBsC = true;
        } else if (!this.currentBsC) {
            if (this.bvR.size() == 0 || !this.prevBsC) {
                this.bvR.append1();
            } else {
                this.bvR.append0();
            }
            int n2 = this.arSSize - 1;
            this.arS[n2] = this.arS[n2] - 1;
            if (!this.prevBsC) {
                this.addArS();
            }
            this.currentBsC = true;
        }
        ++this.size;
        if (this.size % 8 == 0) {
            this.first0bitInBlock = true;
        }
    }

    public void append(boolean bit) {
        if (bit) {
            this.append1();
        } else {
            this.append0();
        }
    }

    @Override
    public int rank1(int pos) {
        int ret;
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return (cn + 1) * 64 - this.countCache0[cn];
        }
        ret = cn > 0 ? (ret = cn * 64 - this.countCache0[cn - 1]) : 0;
        int n = pos / 8;
        for (int i = cn * 8; i < n; ++i) {
            ret += BITCOUNTS1[this.bytes[i] & 0xFF];
        }
        return ret + BITCOUNTS1[this.bytes[n] & MASKS[pos % 8]];
    }

    @Override
    public int rank0(int pos) {
        int ret;
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return this.countCache0[cn];
        }
        ret = cn > 0 ? (ret = this.countCache0[cn - 1]) : 0;
        int n = pos / 8;
        for (int i = cn * 8; i < n; ++i) {
            ret += BITCOUNTS0[this.bytes[i] & 0xFF];
        }
        return ret + BITCOUNTS0[(this.bytes[n] | ~MASKS[pos % 8]) & 0xFF];
    }

    public int rank(int pos, boolean b) {
        if (b) {
            return this.rank1(pos);
        }
        return this.rank0(pos);
    }

    @Override
    public int select0(int count2) {
        if (count2 > this.size0) {
            return -1;
        }
        if (count2 <= 3) {
            if (count2 == 1) {
                return this.node1pos;
            }
            if (count2 == 2) {
                return this.node2pos;
            }
            if (count2 == 3) {
                return this.node3pos;
            }
            return -1;
        }
        int c = count2 - 1;
        int ci = this.bvD.rank1(c) - 1;
        int u = ci + this.arS[this.bvR.rank1(ci) - 1];
        if (u != 0) {
            int ui = u * 8;
            int r = this.rank0(ui - 1);
            return ui + BITPOS0[this.bytes[u] & 0xFF][c - r];
        }
        return BITPOS0[this.bytes[0] & 0xFF][c];
    }

    @Override
    public int select1(int count2) {
        for (int i = 0; i < this.bytes.length; ++i) {
            if (i * 8 >= this.size) {
                return -1;
            }
            byte c = BITCOUNTS1[this.bytes[i] & 0xFF];
            if (count2 <= c) {
                int v = this.bytes[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if (i * 8 + j >= this.size) {
                        return -1;
                    }
                    if ((v & 0x80) != 0 && --count2 == 0) {
                        return i * 8 + j;
                    }
                    v <<= 1;
                }
            }
            count2 -= c;
        }
        return -1;
    }

    public int select(int count2, boolean b) {
        if (b) {
            return this.select1(count2);
        }
        return this.select0(count2);
    }

    @Override
    public int next0(int pos) {
        if (pos >= this.size) {
            return -1;
        }
        if (pos <= this.node3pos) {
            if (pos <= this.node1pos) {
                return this.node1pos;
            }
            if (pos <= this.node2pos) {
                return this.node2pos;
            }
            return this.node3pos;
        }
        int i = pos / 8;
        int s2 = pos % 8;
        if (s2 != 0) {
            for (byte b : BITPOS0[this.bytes[i] & 0xFF]) {
                if (s2 > b) continue;
                return i * 8 + b;
            }
            ++i;
        }
        int n = this.size / 8 + 1;
        while (i < n) {
            byte[] poss = BITPOS0[this.bytes[i] & 0xFF];
            if (poss.length > 0) {
                return poss[0] + i * 8;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.size = in.readInt();
        this.size0 = in.readInt();
        this.node1pos = in.readInt();
        this.node2pos = in.readInt();
        this.node3pos = in.readInt();
        int vectorSize = in.readInt();
        this.bytes = new byte[vectorSize];
        in.readFully(this.bytes, 0, vectorSize);
        this.countCache0 = (int[])in.readObject();
        this.bvD = (SuccinctBitVector)in.readObject();
        this.first0bitInBlock = in.readBoolean();
        this.bvR = (SuccinctBitVector)in.readObject();
        this.arS = (int[])in.readObject();
        this.arSSize = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.size0);
        out.writeInt(this.node1pos);
        out.writeInt(this.node2pos);
        out.writeInt(this.node3pos);
        this.trimToSize();
        out.writeInt(this.bytes.length);
        out.write(this.bytes);
        out.writeObject(this.countCache0);
        out.writeObject(this.bvD);
        out.writeBoolean(this.first0bitInBlock);
        out.writeObject(this.bvR);
        out.writeObject(this.arS);
        out.writeInt(this.arSSize);
    }

    private void extend() {
        int vectorSize = (int)((double)this.bytes.length * 1.2) + 1;
        this.bytes = Arrays.copyOf(this.bytes, vectorSize);
        int blockSize = 8;
        int size2 = vectorSize / blockSize + (vectorSize % blockSize != 0 ? 1 : 0);
        this.countCache0 = Arrays.copyOf(this.countCache0, size2);
    }

    private void addArS() {
        if (this.arSSize == this.arS.length) {
            this.arS = Arrays.copyOf(this.arS, (int)((double)this.arSSize * 1.2) + 1);
        }
        if (this.arSSize > 0) {
            this.arS[this.arSSize] = this.arS[this.arSSize - 1];
        }
        ++this.arSSize;
    }

    private static int bytesSize(int bitSize) {
        return (bitSize - 1) / 8 + 1;
    }

    private static int countCache0Size(int bitSize) {
        return (bitSize - 1) / 64 + 1;
    }
}

