/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.trie4j.Node;
import org.trie4j.NodeVisitor;
import org.trie4j.util.Pair;

public class Algorithms {
    public static void traverseByBreadth(Node root, NodeVisitor visitor) {
        LinkedList<Pair<Node, Integer>> nodeAndNests = new LinkedList<Pair<Node, Integer>>();
        nodeAndNests.offer(Pair.create(root, 0));
        Pair nodeAndNest = null;
        while ((nodeAndNest = (Pair)nodeAndNests.poll()) != null) {
            int nest;
            Node node = (Node)nodeAndNest.getFirst();
            if (!visitor.visit(node, nest = ((Integer)nodeAndNest.getSecond()).intValue())) {
                return;
            }
            ++nest;
            for (Node child : node.getChildren()) {
                nodeAndNests.offer(Pair.create(child, nest));
            }
        }
    }

    public static void traverseByDepth(Node root, NodeVisitor visitor) {
        LinkedList<Pair<Node, Integer>> nodeAndNests = new LinkedList<Pair<Node, Integer>>();
        nodeAndNests.offer(Pair.create(root, 0));
        Pair nodeAndNest = null;
        while ((nodeAndNest = (Pair)nodeAndNests.poll()) != null) {
            int nest;
            Node node = (Node)nodeAndNest.getFirst();
            if (!visitor.visit(node, nest = ((Integer)nodeAndNest.getSecond()).intValue())) {
                return;
            }
            ++nest;
            Node[] children2 = node.getChildren();
            int n = children2.length;
            for (int i = n - 1; i >= 0; --i) {
                nodeAndNests.offerFirst(Pair.create(children2[i], nest));
            }
        }
    }

    public static void dump(Node root, Writer writer) {
        final PrintWriter w = new PrintWriter(writer);
        final AtomicInteger c = new AtomicInteger();
        Algorithms.traverseByDepth(root, new NodeVisitor(){

            @Override
            public boolean visit(Node node, int nest) {
                for (int i = 0; i < nest; ++i) {
                    w.print(" ");
                }
                if (c.incrementAndGet() > 100) {
                    w.println("... over 100 nodes");
                    return false;
                }
                char[] letters = node.getLetters();
                if (letters != null && letters.length > 0) {
                    w.print(letters);
                }
                if (node.isTerminate()) {
                    w.print("*");
                }
                w.println();
                return true;
            }
        });
        w.flush();
    }

    public static boolean contains(Node root, String text) {
        if (text.length() == 0) {
            return root.getLetters().length == 0 && root.isTerminate();
        }
        int i = 0;
        for (Node node = root; node != null; node = node.getChild(text.charAt(i))) {
            char[] letters = node.getLetters();
            if (letters.length <= 0) continue;
            for (char c : letters) {
                if (c == text.charAt(i++)) continue;
                return false;
            }
            if (i != text.length()) continue;
            return node.isTerminate();
        }
        return false;
    }

    public Iterable<String> commonPrefixSearch(Node root, String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] queryChars = query.toCharArray();
        int cur = 0;
        for (Node node = root; node != null; node = node.getChild(queryChars[cur])) {
            char[] letters = node.getLetters();
            if (letters.length > queryChars.length - cur) {
                return ret;
            }
            for (int i = 0; i < letters.length; ++i) {
                if (letters[i] == queryChars[cur + i]) continue;
                return ret;
            }
            if (node.isTerminate()) {
                ret.add(new String(queryChars, 0, cur + letters.length));
            }
            if (queryChars.length != (cur += letters.length)) continue;
            return ret;
        }
        return ret;
    }
}

