/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.util.Map;
import java.util.NoSuchElementException;
import org.trie4j.MapNode;
import org.trie4j.MapTrie;
import org.trie4j.TermIdNode;
import org.trie4j.TermIdTrie;
import org.trie4j.util.Pair;

public abstract class AbstractTermIdMapTrie<T>
implements Externalizable,
MapTrie<T> {
    private TermIdTrie trie;
    private Object[] values = new Object[0];

    protected AbstractTermIdMapTrie() {
    }

    protected AbstractTermIdMapTrie(TermIdTrie trie) {
        this.trie = trie;
    }

    @Override
    public int nodeSize() {
        return this.trie.nodeSize();
    }

    @Override
    public boolean contains(String word) {
        return this.trie.contains(word);
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        return this.trie.commonPrefixSearch(query);
    }

    @Override
    public int findWord(CharSequence chars, int start, int end, StringBuilder word) {
        return this.trie.findWord(chars, start, end, word);
    }

    @Override
    public Iterable<String> predictiveSearch(String prefix) {
        return this.trie.predictiveSearch(prefix);
    }

    @Override
    public void insert(String word) {
        this.trie.insert(word);
    }

    @Override
    public int size() {
        return this.trie.size();
    }

    @Override
    public void trimToSize() {
        this.trie.trimToSize();
    }

    @Override
    public void dump(Writer writer) throws IOException {
        this.trie.dump(writer);
    }

    @Override
    public void freeze() {
        this.trie.freeze();
    }

    @Override
    public MapNode<T> getRoot() {
        return new MapNodeAdapter(this.trie.getRoot());
    }

    @Override
    public T get(String text) {
        int id = this.trie.getTermId(text);
        if (id < 0) {
            return null;
        }
        return (T)this.values[id];
    }

    @Override
    public T put(String text, T value) {
        int id = this.trie.getTermId(text);
        if (id < 0) {
            throw new NoSuchElementException();
        }
        Object ret = this.values[id];
        this.values[id] = value;
        return (T)ret;
    }

    @Override
    public T insert(String word, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Map.Entry<String, T>> commonPrefixSearchEntries(String query) {
        return new IterableAdapter(this.trie.commonPrefixSearchWithTermId(query));
    }

    @Override
    public Iterable<Map.Entry<String, T>> predictiveSearchEntries(String prefix) {
        return new IterableAdapter(this.trie.predictiveSearchWithTermId(prefix));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.trie = (TermIdTrie)in.readObject();
        this.values = (Object[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.trie);
        out.writeObject(this.values);
    }

    public TermIdTrie getTrie() {
        return this.trie;
    }

    protected void setTrie(TermIdTrie trie) {
        this.trie = trie;
    }

    public Object[] getValues() {
        return this.values;
    }

    protected void setValues(Object[] values) {
        this.values = values;
    }

    private class IterableAdapter
    extends org.trie4j.util.IterableAdapter<Pair<String, Integer>, Map.Entry<String, T>> {
        public IterableAdapter(Iterable<Pair<String, Integer>> iterable) {
            super(iterable);
        }

        @Override
        protected Map.Entry<String, T> convert(final Pair<String, Integer> value) {
            return new Map.Entry<String, T>(){

                @Override
                public String getKey() {
                    return (String)value.getFirst();
                }

                @Override
                public T getValue() {
                    return AbstractTermIdMapTrie.this.values[(Integer)value.getSecond()];
                }

                @Override
                public T setValue(T v) {
                    Object ret = this.getValue();
                    ((AbstractTermIdMapTrie)AbstractTermIdMapTrie.this).values[((Integer)value.getSecond()).intValue()] = v;
                    return ret;
                }
            };
        }
    }

    public class MapNodeAdapter
    implements MapNode<T> {
        private TermIdNode orig;

        public MapNodeAdapter(TermIdNode orig) {
            this.orig = orig;
        }

        @Override
        public char[] getLetters() {
            return this.orig.getLetters();
        }

        @Override
        public boolean isTerminate() {
            return this.orig.isTerminate();
        }

        @Override
        public MapNode<T> getChild(char c) {
            return new MapNodeAdapter(this.orig.getChild(c));
        }

        public MapNode<T>[] getChildren() {
            TermIdNode[] origArray = this.orig.getChildren();
            MapNode[] ret = new MapNode[origArray.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new MapNodeAdapter(origArray[i]);
            }
            return ret;
        }

        @Override
        public T getValue() {
            return AbstractTermIdMapTrie.this.values[this.orig.getTermId()];
        }

        @Override
        public void setValue(T value) {
            ((AbstractTermIdMapTrie)AbstractTermIdMapTrie.this).values[this.orig.getTermId()] = value;
        }
    }
}

