/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.seunjeon;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.bitbucket.eunjeon.seunjeon.ConnectionCostDict;
import org.bitbucket.eunjeon.seunjeon.LexiconDict;
import scala.Predef$;
import scala.StringContext;
import scala.collection.mutable.StringBuilder;
import scala.reflect.io.File$;
import scala.reflect.io.Path$;

public final class DictBuilder$ {
    public static final DictBuilder$ MODULE$;
    private final String workingDirectory;
    private final String MECAB_KO_DIC_PATH;
    private final String RESOURCE_PATH;
    private final String DICT_PATHNAME;
    private final String DICT_PATH;
    private final String TERM_DICT_FILENAME;
    private final String TERM_DICT;
    private final String DICT_MAPPER_FILENAME;
    private final String DICT_MAPPER;
    private final String TERM_TRIE_FILENAME;
    private final String TERM_TRIE;
    private final String CONNECTION_COST_FILENAME;
    private final String CONNECTION_COST;
    private final String UNK_DEF_FILENAME;
    private final String UNK_DEF;
    private final String LEFT_ID_DEF_FILENAME;
    private final String LEFT_ID_DEF;
    private final String RIGHT_ID_DEF_FILENAME;
    private final String RIGHT_ID_DEF;

    static {
        new DictBuilder$();
    }

    public String workingDirectory() {
        return this.workingDirectory;
    }

    public String MECAB_KO_DIC_PATH() {
        return this.MECAB_KO_DIC_PATH;
    }

    public String RESOURCE_PATH() {
        return this.RESOURCE_PATH;
    }

    public String DICT_PATHNAME() {
        return this.DICT_PATHNAME;
    }

    public String DICT_PATH() {
        return this.DICT_PATH;
    }

    public String TERM_DICT_FILENAME() {
        return this.TERM_DICT_FILENAME;
    }

    public String TERM_DICT() {
        return this.TERM_DICT;
    }

    public String DICT_MAPPER_FILENAME() {
        return this.DICT_MAPPER_FILENAME;
    }

    public String DICT_MAPPER() {
        return this.DICT_MAPPER;
    }

    public String TERM_TRIE_FILENAME() {
        return this.TERM_TRIE_FILENAME;
    }

    public String TERM_TRIE() {
        return this.TERM_TRIE;
    }

    public String CONNECTION_COST_FILENAME() {
        return this.CONNECTION_COST_FILENAME;
    }

    public String CONNECTION_COST() {
        return this.CONNECTION_COST;
    }

    public String UNK_DEF_FILENAME() {
        return this.UNK_DEF_FILENAME;
    }

    public String UNK_DEF() {
        return this.UNK_DEF;
    }

    public String LEFT_ID_DEF_FILENAME() {
        return this.LEFT_ID_DEF_FILENAME;
    }

    public String LEFT_ID_DEF() {
        return this.LEFT_ID_DEF;
    }

    public String RIGHT_ID_DEF_FILENAME() {
        return this.RIGHT_ID_DEF_FILENAME;
    }

    public String RIGHT_ID_DEF() {
        return this.RIGHT_ID_DEF;
    }

    public void main(String[] args) {
        this.clear();
        this.copyUnkDef();
        this.copyLeftIdDef();
        this.copyRightIdDef();
        Predef$.MODULE$.println("compiling lexicon dictionary...");
        this.buildLexiconDict();
        Predef$.MODULE$.println("compiling connection-cost dictionary...");
        this.buildConnectionCostDict();
        Predef$.MODULE$.println("complete");
    }

    private void copyUnkDef() {
        this.copyDefFile(this.UNK_DEF_FILENAME());
    }

    private void copyLeftIdDef() {
        this.copyDefFile(this.LEFT_ID_DEF_FILENAME());
    }

    private void copyRightIdDef() {
        this.copyDefFile(this.RIGHT_ID_DEF_FILENAME());
    }

    private void copyDefFile(String defFileName) {
        Files.copy(Paths.get(new StringBuilder().append((Object)this.MECAB_KO_DIC_PATH()).append((Object)File$.MODULE$.separator()).append((Object)defFileName).toString(), new String[0]), Paths.get(new StringBuilder().append((Object)this.RESOURCE_PATH()).append((Object)File$.MODULE$.separator()).append((Object)this.DICT_PATHNAME()).append((Object)File$.MODULE$.separator()).append((Object)defFileName).toString(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    private void buildConnectionCostDict() {
        ConnectionCostDict connectionCostDict = new ConnectionCostDict();
        connectionCostDict.loadFromFile(new StringBuilder().append((Object)this.MECAB_KO_DIC_PATH()).append((Object)File$.MODULE$.separator()).append((Object)"matrix.def").toString());
        connectionCostDict.save(new StringBuilder().append((Object)this.RESOURCE_PATH()).append((Object)File$.MODULE$.separator()).append((Object)this.DICT_PATHNAME()).append((Object)File$.MODULE$.separator()).append((Object)this.CONNECTION_COST_FILENAME()).toString());
        Predef$.MODULE$.println(new StringBuilder().append((Object)"building connection cost dictionary OK. ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{connectionCostDict.getDictionaryInfo()}))).toString());
    }

    private void buildLexiconDict() {
        String dictPath = new StringBuilder().append((Object)this.RESOURCE_PATH()).append((Object)File$.MODULE$.separator()).append((Object)this.DICT_PATHNAME()).toString();
        LexiconDict lexiconDict = new LexiconDict();
        lexiconDict.loadFromDir(this.MECAB_KO_DIC_PATH());
        lexiconDict.save(new StringBuilder().append((Object)dictPath).append((Object)File$.MODULE$.separator()).append((Object)this.TERM_DICT_FILENAME()).toString(), new StringBuilder().append((Object)dictPath).append((Object)File$.MODULE$.separator()).append((Object)this.DICT_MAPPER_FILENAME()).toString(), new StringBuilder().append((Object)dictPath).append((Object)File$.MODULE$.separator()).append((Object)this.TERM_TRIE_FILENAME()).toString());
        Predef$.MODULE$.println(new StringBuilder().append((Object)"building LexiconDict OK. ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{lexiconDict.getDictionaryInfo()}))).toString());
    }

    private void clear() {
        String dictPath = new StringBuilder().append((Object)this.RESOURCE_PATH()).append((Object)File$.MODULE$.separator()).append((Object)this.DICT_PATHNAME()).toString();
        Path$.MODULE$.apply(dictPath).deleteRecursively();
        new File(dictPath).mkdirs();
    }

    private DictBuilder$() {
        MODULE$ = this;
        this.workingDirectory = System.getProperty("user.dir");
        this.MECAB_KO_DIC_PATH = new StringBuilder().append((Object)this.workingDirectory()).append((Object)"/mecab-ko-dic").toString();
        this.RESOURCE_PATH = new StringBuilder().append((Object)this.workingDirectory()).append((Object)"/src/main/resources").toString();
        this.DICT_PATHNAME = "/dictionary";
        this.DICT_PATH = this.DICT_PATHNAME();
        this.TERM_DICT_FILENAME = "/termDict.dat";
        this.TERM_DICT = new StringBuilder().append((Object)this.DICT_PATH()).append((Object)this.TERM_DICT_FILENAME()).toString();
        this.DICT_MAPPER_FILENAME = "/dictMapper.dat";
        this.DICT_MAPPER = new StringBuilder().append((Object)this.DICT_PATH()).append((Object)this.DICT_MAPPER_FILENAME()).toString();
        this.TERM_TRIE_FILENAME = "/trie.dat";
        this.TERM_TRIE = new StringBuilder().append((Object)this.DICT_PATH()).append((Object)this.TERM_TRIE_FILENAME()).toString();
        this.CONNECTION_COST_FILENAME = "/connection_cost.dat";
        this.CONNECTION_COST = new StringBuilder().append((Object)this.DICT_PATH()).append((Object)this.CONNECTION_COST_FILENAME()).toString();
        this.UNK_DEF_FILENAME = "/unk.def";
        this.UNK_DEF = new StringBuilder().append((Object)this.DICT_PATH()).append((Object)this.UNK_DEF_FILENAME()).toString();
        this.LEFT_ID_DEF_FILENAME = "/left-id.def";
        this.LEFT_ID_DEF = new StringBuilder().append((Object)this.DICT_PATH()).append((Object)this.LEFT_ID_DEF_FILENAME()).toString();
        this.RIGHT_ID_DEF_FILENAME = "/right-id.def";
        this.RIGHT_ID_DEF = new StringBuilder().append((Object)this.DICT_PATH()).append((Object)this.RIGHT_ID_DEF_FILENAME()).toString();
    }
}

