/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.framework.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.birchframework.dto.payload.Payload;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class PayloadSerializer
implements Serializer<Payload<?>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LogManager.getLogger(PayloadSerializer.class);
    private static final @UnknownKeyFor @NonNull @Initialized Jackson2ObjectMapperBuilder objectMapperBuilder = Jackson2ObjectMapperBuilder.json();

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serialize(@UnknownKeyFor @NonNull @Initialized String theTopic, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Payload<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> theData) {
        ObjectMapper anObjectMapper = objectMapperBuilder.build();
        if (theData == null) {
            return null;
        }
        byte[] aSerializedPayload = null;
        try {
            aSerializedPayload = anObjectMapper.writeValueAsBytes(theData);
            if (log.isDebugEnabled()) {
                log.debug("Data: {}", (Object)ToStringBuilder.reflectionToString(theData, (ToStringStyle)ToStringStyle.JSON_STYLE));
                log.debug("Serialized payload: {}", (Object)aSerializedPayload);
            }
        }
        catch (JsonProcessingException e) {
            log.error("An error occurred.", (Throwable)e);
        }
        return aSerializedPayload == null ? new byte[]{} : aSerializedPayload;
    }
}

