/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.framework.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.birchframework.dto.payload.Payload;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class PayloadDeserializer
implements Deserializer<Payload<?>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LogManager.getLogger(PayloadDeserializer.class);
    private static final @UnknownKeyFor @NonNull @Initialized Jackson2ObjectMapperBuilder objectMapperBuilder = Jackson2ObjectMapperBuilder.json();

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Payload<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> deserialize(@UnknownKeyFor @NonNull @Initialized String theTopic, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] theData) {
        ObjectMapper anObjectMapper = objectMapperBuilder.build();
        if (theData != null && theData.length > 0) {
            Payload aPayload = null;
            try {
                aPayload = (Payload)anObjectMapper.readValue(theData, Payload.class);
                if (log.isDebugEnabled()) {
                    log.debug("Data: {}", (Object)new String(theData));
                    log.debug("Deserialized payload: {}", (Object)ToStringBuilder.reflectionToString((Object)aPayload, (ToStringStyle)ToStringStyle.JSON_STYLE));
                }
            }
            catch (IOException e) {
                log.error("An error occurred.", (Throwable)e);
            }
            return aPayload;
        }
        return null;
    }
}

