/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.framework.kafka;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.birchframework.configuration.BirchProperties;
import org.birchframework.framework.kafka.KafkaSendResult;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SuccessCallback;

@Component
@ConditionalOnClass(value={KafkaTemplate.class})
@EnableConfigurationProperties(value={BirchProperties.class})
public class KafkaSender<@UnknownKeyFor K extends @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor V extends @UnknownKeyFor @NonNull @Initialized Serializable> {
    private final @UnknownKeyFor @NonNull @Initialized KafkaTemplate<K, V> kafkaTemplate;
    private final @UnknownKeyFor @NonNull @Initialized long waitTimeMillis;

    public KafkaSender(@UnknownKeyFor @NonNull @Initialized KafkaTemplate<K, V> theTemplate, @UnknownKeyFor @NonNull @Initialized BirchProperties theProperties) {
        this.kafkaTemplate = theTemplate;
        BirchProperties.Kafka.Sender aSenderProperties = theProperties.getKafka().getSender();
        this.waitTimeMillis = aSenderProperties.getWaitTime().toMillis();
        this.kafkaTemplate.setAllowNonTransactional(aSenderProperties.isAllowNonTransactional());
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized KafkaSendResult<K, V>> send(@UnknownKeyFor @NonNull @Initialized String topic, K key, V data) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return this.send(topic, null, key, data);
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized KafkaSendResult<K, V>> send(@UnknownKeyFor @NonNull @Initialized String topic, V data) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return this.send(topic, null, null, data);
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized KafkaSendResult<K, V>> send(@Nonnull @UnknownKeyFor @NonNull @Initialized String topic, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer partition, @Nullable @org.checkerframework.checker.nullness.qual.Nullable K key, @Nonnull @NonNull V data) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        KafkaSendResult aResult = new KafkaSendResult();
        try {
            aResult.result = (SendResult)this.kafkaTemplate.send(topic, partition, key, data).get(this.waitTimeMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            aResult.hasError = true;
            aResult.exception = e;
            throw e;
        }
        catch (ExecutionException | TimeoutException e) {
            aResult.hasError = true;
            aResult.exception = e;
        }
        return Optional.ofNullable(aResult);
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized KafkaSendResult<K, V>> sendTransactional(@Nonnull @UnknownKeyFor @NonNull @Initialized String topic, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer partition, @Nullable @org.checkerframework.checker.nullness.qual.Nullable K key, @Nonnull @NonNull V data) {
        KafkaSendResult aReturnValue = new KafkaSendResult();
        aReturnValue.result = (SendResult)this.kafkaTemplate.executeInTransaction(operations -> {
            SendResult aResult;
            try {
                aResult = (SendResult)operations.send(topic, partition, (Object)key, (Object)data).get(this.waitTimeMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                aReturnValue.hasError = true;
                aReturnValue.exception = e;
                aResult = new SendResult(null, null);
                Thread.currentThread().interrupt();
            }
            return aResult;
        });
        return Optional.of(aReturnValue);
    }

    public void sendAsync(@UnknownKeyFor @NonNull @Initialized String topic, V data) {
        this.sendAsync(topic, null, null, data, r -> {}, e -> {});
    }

    public void sendAsync(@UnknownKeyFor @NonNull @Initialized String topic, V data, @UnknownKeyFor @NonNull @Initialized SuccessCallback<@UnknownKeyFor @NonNull @Initialized SendResult<K, V>> successCallback, @UnknownKeyFor @NonNull @Initialized FailureCallback failureCallback) {
        this.sendAsync(topic, null, null, data, successCallback, failureCallback);
    }

    public void sendAsync(@UnknownKeyFor @NonNull @Initialized String topic, K key, V data) {
        this.sendAsync(topic, key, data, r -> {}, e -> {});
    }

    public void sendAsync(@UnknownKeyFor @NonNull @Initialized String topic, K key, V data, @UnknownKeyFor @NonNull @Initialized SuccessCallback<@UnknownKeyFor @NonNull @Initialized SendResult<K, V>> successCallback, @UnknownKeyFor @NonNull @Initialized FailureCallback failureCallback) {
        this.sendAsync(topic, null, key, data, successCallback, failureCallback);
    }

    public void sendAsync(@Nonnull @UnknownKeyFor @NonNull @Initialized String topic, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer partition, @Nullable @org.checkerframework.checker.nullness.qual.Nullable K key, @Nonnull @NonNull V data, @Nonnull @UnknownKeyFor @NonNull @Initialized SuccessCallback<@UnknownKeyFor @NonNull @Initialized SendResult<K, V>> successCallback, @UnknownKeyFor @NonNull @Initialized FailureCallback failureCallback) {
        ListenableFuture aFuture = this.kafkaTemplate.send(topic, partition, key, data);
        aFuture.addCallback(successCallback, failureCallback);
    }

    public void sendAsyncTransactional(@Nonnull @UnknownKeyFor @NonNull @Initialized String topic, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer partition, @Nullable @org.checkerframework.checker.nullness.qual.Nullable K key, @Nonnull @NonNull V data, @Nonnull @UnknownKeyFor @NonNull @Initialized SuccessCallback<@UnknownKeyFor @NonNull @Initialized SendResult<K, V>> successCallback, @UnknownKeyFor @NonNull @Initialized FailureCallback failureCallback) {
        ListenableFuture aFuture = (ListenableFuture)this.kafkaTemplate.executeInTransaction(operations -> operations.send(topic, partition, key, data));
        Assert.notNull((Object)aFuture, (String)"Future returned by Kafka Template is null");
        aFuture.addCallback(successCallback, failureCallback);
    }
}

