/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.framework.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.kafka.common.serialization.Serializer;
import org.birchframework.framework.bridge.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class PayloadSerializer
implements Serializer<Payload<?>> {
    private static final Logger log = LoggerFactory.getLogger(PayloadSerializer.class);
    private static final Jackson2ObjectMapperBuilder objectMapperBuilder = Jackson2ObjectMapperBuilder.json();

    public byte[] serialize(String theTopic, Payload<?> theData) {
        ObjectMapper anObjectMapper = objectMapperBuilder.build();
        if (theData == null) {
            return null;
        }
        byte[] aSerializedPayload = null;
        try {
            aSerializedPayload = anObjectMapper.writeValueAsBytes(theData);
            if (log.isDebugEnabled()) {
                log.debug("Data: {}", (Object)ToStringBuilder.reflectionToString(theData, (ToStringStyle)ToStringStyle.JSON_STYLE));
                log.debug("Serialized payload: {}", (Object)aSerializedPayload);
            }
        }
        catch (JsonProcessingException e) {
            log.error("An error occurred.", (Throwable)e);
        }
        return aSerializedPayload == null ? new byte[]{} : aSerializedPayload;
    }
}

