/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.framework.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.kafka.common.serialization.Deserializer;
import org.birchframework.framework.bridge.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class PayloadDeserializer
implements Deserializer<Payload<?>> {
    private static final Logger log = LoggerFactory.getLogger(PayloadDeserializer.class);
    private static final Jackson2ObjectMapperBuilder objectMapperBuilder = Jackson2ObjectMapperBuilder.json();

    public Payload<?> deserialize(String theTopic, byte[] theData) {
        ObjectMapper anObjectMapper = objectMapperBuilder.build();
        if (theData != null && theData.length > 0) {
            Payload aPayload = null;
            try {
                aPayload = (Payload)anObjectMapper.readValue(theData, Payload.class);
                if (log.isDebugEnabled()) {
                    log.debug("Data: {}", (Object)new String(theData));
                    log.debug("Deserialized payload: {}", (Object)ToStringBuilder.reflectionToString((Object)aPayload, (ToStringStyle)ToStringStyle.JSON_STYLE));
                }
            }
            catch (IOException e) {
                log.error("An error occurred.", (Throwable)e);
            }
            return aPayload;
        }
        return null;
    }
}

