/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.EquivalenceGrouper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetEquivalenceChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SetEquivalenceChecker.class);

    public static <T extends BioPAXElement> boolean isEquivalent(Set<? extends T> set1, Set<? extends T> set2) {
        int size;
        if (set1 != null && !set1.isEmpty() && set2 != null && !set2.isEmpty() && (size = set1.size()) == set2.size()) {
            EquivalenceGrouper<T> grouper = new EquivalenceGrouper<T>();
            grouper.addAll(set1);
            if (grouper.getBuckets().size() == size) {
                grouper.addAll(set2);
                return grouper.getBuckets().size() == size;
            }
        }
        return set1 == null && set2 == null || set1 != null && set1.isEmpty() && set2 != null && set2.isEmpty();
    }

    public static boolean containsEquivalent(Set<? extends BioPAXElement> set, BioPAXElement query) {
        if (set != null && query != null) {
            for (BioPAXElement bioPAXElement : set) {
                if (!query.isEquivalent(bioPAXElement)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends BioPAXElement> Set<T> findEquivalentIntersection(Set<? extends T> set1, Set<? extends T> set2) {
        HashSet<BioPAXElement> value = new HashSet<BioPAXElement>();
        if (set1 != null && !set1.isEmpty() && set2 != null && !set2.isEmpty()) {
            EquivalenceGrouper<T> grouper = new EquivalenceGrouper<T>();
            grouper.addAll(set1);
            if (grouper.getBuckets().size() < set1.size()) {
                throw new IllegalArgumentException("There should not be equivalent elements in a set");
            }
            grouper.addAll(set2);
            for (List ts : grouper.getBuckets()) {
                if (ts.size() <= 1) continue;
                for (BioPAXElement t : ts) {
                    if (!set1.contains(t)) continue;
                    value.add(t);
                }
            }
        }
        return value;
    }

    public static <T extends BioPAXElement> boolean hasEquivalentIntersection(Set<? extends T> set1, Set<? extends T> set2) {
        if (!set1.isEmpty() && !set2.isEmpty()) {
            EquivalenceGrouper<T> grouper1 = new EquivalenceGrouper<T>(set1);
            int size1 = grouper1.getBuckets().size();
            if (set1.size() > size1) {
                LOG.warn("hasEquivalentIntersection: the first set already contains equivalent objects");
            }
            EquivalenceGrouper<T> grouper2 = new EquivalenceGrouper<T>(set2);
            int size2 = grouper2.getBuckets().size();
            if (set2.size() > size2) {
                LOG.warn("hasEquivalentIntersection: the second set already contains equivalent objects");
            }
            EquivalenceGrouper<T> grouper = new EquivalenceGrouper<T>();
            grouper.addAll(set1);
            grouper.addAll(set2);
            return grouper.getBuckets().size() < size1 + size2;
        }
        return !(set1.isEmpty() ^ set2.isEmpty());
    }
}

