/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.BPCollections;

public class BiopaxSafeSet<E extends BioPAXElement>
extends AbstractSet<E>
implements Serializable {
    private static final Map empty = Collections.emptyMap();
    private Map<String, E> map = empty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Map<String, E> map = this.map;
        synchronized (map) {
            return this.map.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<String, E> map = this.map;
        synchronized (map) {
            return this.map == empty ? 0 : this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E bpe) {
        String uri = bpe.getUri();
        Map<String, E> map = this.map;
        synchronized (map) {
            if (this.map == empty) {
                this.map = BPCollections.I.createMap();
                this.map.put(uri, bpe);
                return true;
            }
            if (!this.map.containsKey(uri)) {
                this.map.put(uri, bpe);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (o == null || !(o instanceof BioPAXElement) || ((BioPAXElement)o).getUri() == null) {
            return false;
        }
        Map<String, E> map = this.map;
        synchronized (map) {
            return this.map == empty ? false : this.map.get(((BioPAXElement)o).getUri()) == o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Map<String, E> map = this.map;
        synchronized (map) {
            if (this.contains(o)) {
                return this.map.remove(((BioPAXElement)o).getUri()) != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(String uri) {
        if (this.map == empty) {
            return null;
        }
        Map<String, E> map = this.map;
        synchronized (map) {
            return (E)((BioPAXElement)this.map.get(uri));
        }
    }
}

