/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.biopax.paxtools.impl.level3.EntityImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalEntityImpl
extends EntityImpl
implements PhysicalEntity {
    private CellularLocationVocabulary cellularLocation;
    private Set<PhysicalEntity> memberPhysicalEntity;
    private Set<Complex> componentOf;
    private Set<EntityFeature> feature = BPCollections.I.createSafeSet();
    private Set<EntityFeature> notFeature = BPCollections.I.createSafeSet();
    private Set<Control> controllerOf = BPCollections.I.createSafeSet();
    private static final Logger log = LoggerFactory.getLogger(PhysicalEntityImpl.class);
    private Set<PhysicalEntity> memberPhysicalEntityOf;

    public PhysicalEntityImpl() {
        this.componentOf = BPCollections.I.createSafeSet();
        this.memberPhysicalEntityOf = BPCollections.I.createSafeSet();
        this.memberPhysicalEntity = BPCollections.I.createSafeSet();
    }

    @Override
    public Class<? extends PhysicalEntity> getModelInterface() {
        return PhysicalEntity.class;
    }

    @Override
    public Set<Complex> getComponentOf() {
        return this.componentOf;
    }

    @Override
    public CellularLocationVocabulary getCellularLocation() {
        return this.cellularLocation;
    }

    @Override
    public void setCellularLocation(CellularLocationVocabulary location) {
        this.cellularLocation = location;
    }

    @Override
    public Set<EntityFeature> getFeature() {
        return this.feature;
    }

    @Override
    public void addFeature(EntityFeature feature) {
        if (feature != null) {
            this.feature.add(feature);
            feature.getFeatureOf().add(this);
        }
    }

    @Override
    public void removeFeature(EntityFeature feature) {
        if (feature != null) {
            this.feature.remove(feature);
            feature.getFeatureOf().remove(this);
        }
    }

    @Override
    public Set<EntityFeature> getNotFeature() {
        return this.notFeature;
    }

    @Override
    public void addNotFeature(EntityFeature feature) {
        if (feature != null) {
            this.notFeature.add(feature);
            feature.getNotFeatureOf().add(this);
        }
    }

    @Override
    public void removeNotFeature(EntityFeature feature) {
        if (feature != null) {
            this.notFeature.remove(feature);
            feature.getNotFeatureOf().remove(this);
        }
    }

    @Override
    public Set<PhysicalEntity> getMemberPhysicalEntity() {
        return this.memberPhysicalEntity;
    }

    @Override
    public void addMemberPhysicalEntity(PhysicalEntity mpe) {
        if (mpe != null) {
            if (this.getModelInterface().isInstance(mpe)) {
                this.memberPhysicalEntity.add(mpe);
                mpe.getMemberPhysicalEntityOf().add(this);
            } else {
                String c = this.getModelInterface().getSimpleName();
                throw new IllegalBioPAXArgumentException(String.format("Value:%s violates class and property restriction: %s.memberPhysycalEntity only %s", mpe.getUri(), c, c));
            }
        }
    }

    @Override
    public void removeMemberPhysicalEntity(PhysicalEntity oldMember) {
        if (oldMember != null) {
            this.memberPhysicalEntity.remove(oldMember);
            oldMember.getMemberPhysicalEntityOf().remove(this);
        }
    }

    @Override
    public Set<PhysicalEntity> getMemberPhysicalEntityOf() {
        return this.memberPhysicalEntityOf;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof PhysicalEntity)) {
            return false;
        }
        PhysicalEntity that = (PhysicalEntity)element;
        return this.hasEquivalentCellularLocation(that) && this.hasEquivalentFeatures(that) && SetEquivalenceChecker.isEquivalent(this.getMemberPhysicalEntity(), that.getMemberPhysicalEntity()) && super.semanticallyEquivalent(element);
    }

    @Override
    public int equivalenceCode() {
        return this.hashCode();
    }

    @Override
    public boolean hasEquivalentCellularLocation(PhysicalEntity that) {
        boolean equivalency = false;
        if (that != null) {
            equivalency = this.cellularLocation != null ? this.cellularLocation.isEquivalent(that.getCellularLocation()) : that.getCellularLocation() == null;
        }
        return equivalency;
    }

    @Override
    public boolean hasEquivalentFeatures(PhysicalEntity that) {
        boolean equivalency = false;
        if (that != null) {
            equivalency = SetEquivalenceChecker.isEquivalent(this.getFeature(), that.getFeature()) && SetEquivalenceChecker.isEquivalent(this.getNotFeature(), that.getNotFeature());
        }
        return equivalency;
    }

    protected int locationAndFeatureCode() {
        int result = this.cellularLocation != null ? this.cellularLocation.hashCode() : 0;
        result = 31 * result + (this.feature != null ? this.feature.hashCode() : 0);
        result = 31 * result + (this.notFeature != null ? this.notFeature.hashCode() : 0);
        return result;
    }

    @Override
    public Set<Control> getControllerOf() {
        return this.controllerOf;
    }
}

