/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.biopax.paxtools.impl.level3.ControlImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.biopax.paxtools.util.SetEquivalenceChecker;

public class CatalysisImpl
extends ControlImpl
implements Catalysis {
    private CatalysisDirectionType catalysisDirection;
    private Set<PhysicalEntity> cofactor = BPCollections.I.createSafeSet();

    public Class<? extends Catalysis> getModelInterface() {
        return Catalysis.class;
    }

    @Override
    public CatalysisDirectionType getCatalysisDirection() {
        return this.catalysisDirection;
    }

    @Override
    public void setCatalysisDirection(CatalysisDirectionType catalysisDirection) {
        this.catalysisDirection = catalysisDirection;
    }

    @Override
    public Set<PhysicalEntity> getCofactor() {
        return this.cofactor;
    }

    @Override
    public void addCofactor(PhysicalEntity cofactor) {
        if (cofactor != null) {
            this.cofactor.add(cofactor);
            super.addParticipant(cofactor);
        }
    }

    @Override
    public void removeCofactor(PhysicalEntity cofactor) {
        if (cofactor != null) {
            super.removeParticipant(cofactor);
            this.cofactor.remove(cofactor);
        }
    }

    @Override
    public void addController(Controller controller) {
        if (!(controller instanceof PhysicalEntity)) {
            throw new IllegalBioPAXArgumentException("Catalysis can only be controlled with a Physical Entity");
        }
        super.addController(controller);
    }

    @Override
    protected boolean checkControlled(Process controlled) {
        return controlled instanceof Conversion;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        boolean equivalence = false;
        if (element instanceof Catalysis && super.semanticallyEquivalent(element)) {
            Catalysis other = (Catalysis)element;
            equivalence = this.getControlType() == other.getControlType() && this.getCatalysisDirection() == other.getCatalysisDirection() && SetEquivalenceChecker.isEquivalent(this.getCofactor(), other.getCofactor()) && SetEquivalenceChecker.isEquivalent(this.getController(), other.getController()) && SetEquivalenceChecker.isEquivalent(this.getControlled(), other.getControlled());
        }
        return equivalence;
    }
}

