/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.biopax.paxtools.model.BioPAXElement;

public abstract class BioPAXElementImpl
implements BioPAXElement {
    private String uri;
    private Map<String, Object> annotations = Collections.emptyMap();

    @Override
    public boolean isEquivalent(BioPAXElement element) {
        return this.equals(element) || this.semanticallyEquivalent(element);
    }

    protected boolean semanticallyEquivalent(BioPAXElement element) {
        return false;
    }

    @Override
    public int equivalenceCode() {
        return this.uri.hashCode();
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    private void setUri(String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            throw new IllegalArgumentException("Blank or null URI is not allowed");
        }
        this.uri = uri;
    }

    public String toString() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAnnotations() {
        Map<String, Object> map = this.annotations;
        synchronized (map) {
            if (this.annotations.isEmpty()) {
                this.annotations = new HashMap<String, Object>(2);
            }
            return this.annotations;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof BioPAXElement && new EqualsBuilder().append(this.getModelInterface(), ((BioPAXElement)obj).getModelInterface()).append((Object)this.uri, (Object)((BioPAXElement)obj).getUri()).build() != false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getModelInterface()).append((Object)this.uri).hashCode();
    }
}

