/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.ConversionScore;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.PEPScore;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Direction;
import org.biopax.paxtools.model.level2.SpontaneousType;
import org.biopax.paxtools.model.level2.biochemicalReaction;
import org.biopax.paxtools.model.level2.catalysis;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.complexAssembly;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.openControlledVocabulary;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.sequenceFeature;
import org.biopax.paxtools.model.level2.sequenceParticipant;
import org.biopax.paxtools.model.level2.smallMolecule;
import org.biopax.paxtools.model.level2.transport;
import org.biopax.paxtools.model.level2.xref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Integrator {
    private static final Logger log = LoggerFactory.getLogger(Integrator.class);
    private EditorMap editorMap;
    private Merger merger;
    private Model target;
    private Model mergedSources = null;
    private boolean onlyMapping = false;
    private boolean selfRemove = false;
    private boolean normalizeModels = false;
    private Map<physicalEntityParticipant, Map<physicalEntityParticipant, Double>> pepScoreMatrix = new HashMap<physicalEntityParticipant, Map<physicalEntityParticipant, Double>>();
    private List<ConversionScore> similarConversions;
    private final String[][] dbChanges = new String[][]{{"Chemical Entities of Biological Interest", "ChEBI"}};
    private Set<Set<String>> relatedTerms = new HashSet<Set<String>>();
    private String[][] termLists = new String[][]{{"active", "active1", "active2", "phosphorylation", "phosphate group", "phosphorylation site"}, {"inactive", "phosphorylation", "phosphate group", "phosphorylation site"}};
    private String[][] locLists = new String[][]{{"cytoplasm", "cytosol"}};
    private final double SIZE_MISMATCH_PENALTY = 0.7;
    private final double BASE_SCORE = 0.4;
    private double SCORES_OVER = 100.0;
    private final double MAX_PEP_SCORE = 3.5;
    private final double STATS_OVER = 1000.0;
    private double threshold = this.SCORES_OVER;

    public Integrator(EditorMap editorMap, Model target, Model ... sources) {
        this.editorMap = editorMap;
        this.merger = new Merger(editorMap);
        this.target = target;
        log.info(sources.length + " source model(s) will be merged.");
        for (Model source : sources) {
            if (this.mergedSources == null) {
                this.mergedSources = source;
                continue;
            }
            this.merger.merge(this.mergedSources, source);
        }
        log.info("Merging finished.");
        if (this.isNormalizeModels()) {
            log.info("Normaling XREFs.");
            this.normalizeXrefs(target);
            this.normalizeXrefs(this.mergedSources);
            log.info("Normaling OCVs.");
            this.normalizeOpenControlledVocabulary(this.mergedSources);
            log.info("Normaling cellular locations.");
            this.normalizeCellularLocations(this.mergedSources);
        }
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public void setOnlyMapping(boolean mapping) {
        this.onlyMapping = mapping;
    }

    boolean isOnlyMapping() {
        return this.onlyMapping;
    }

    public void setSelfRemove(boolean selfRemove) {
        this.selfRemove = selfRemove;
    }

    boolean isSelfRemove() {
        return this.selfRemove;
    }

    public void setNormalizeModels(boolean normalizeModels) {
        this.normalizeModels = normalizeModels;
    }

    boolean isNormalizeModels() {
        return this.normalizeModels;
    }

    double getScoresOver() {
        return this.SCORES_OVER;
    }

    public void setScoresOver(double scoresOver) {
        this.SCORES_OVER = scoresOver;
    }

    public List<ConversionScore> integrate() {
        return this.integrate(null);
    }

    public List<ConversionScore> integrate(List<ConversionScore> alternativeScores) {
        Map<physicalEntityParticipant, Map<physicalEntityParticipant, Double>> pepScoreMatrix = this.pepScoreMatrix;
        if (this.mergedSources == null) {
            log.warn("Either target or source is empty, skipping integration.");
            return null;
        }
        log.info("Scoring all the PEPs.");
        if (pepScoreMatrix.isEmpty()) {
            this.createPEPScoreMatrix(this.target.getObjects(physicalEntityParticipant.class), this.mergedSources.getObjects(physicalEntityParticipant.class));
            log.info("Scoring PEPs finished.");
            log.info("Scoring conversions");
            this.similarConversions = this.createConversionScoreMap(pepScoreMatrix, this.target.getObjects(conversion.class), this.mergedSources.getObjects(conversion.class));
            log.info("Scoring conversions finished.");
        }
        if (this.similarConversions == null) {
            this.similarConversions = new ArrayList<ConversionScore>();
        }
        log.info("Creating a copy of the PEP scores.");
        HashMap<physicalEntityParticipant, Map<physicalEntityParticipant, Double>> copyMatrix = new HashMap<physicalEntityParticipant, Map<physicalEntityParticipant, Double>>();
        for (physicalEntityParticipant pepKey : pepScoreMatrix.keySet()) {
            copyMatrix.put(pepKey, new HashMap<physicalEntityParticipant, Double>(pepScoreMatrix.get(pepKey)));
        }
        pepScoreMatrix = copyMatrix;
        log.info("PEP scores copied.");
        ArrayList<ConversionScore> similarConversions = alternativeScores == null ? new ArrayList<ConversionScore>(this.similarConversions) : alternativeScores;
        log.info("Conversion scores copied.");
        log.info("Mapping conversions/PEPs with a threshold: " + this.getThreshold());
        this.mapConversions(similarConversions, pepScoreMatrix);
        log.info("Mapping finished.");
        log.info("Sorting scores (" + similarConversions.size() + " scores).");
        Collections.sort(similarConversions);
        Collections.reverse(similarConversions);
        log.info("Sorting finished.");
        if (this.isOnlyMapping()) {
            log.info("Skipping model integration.");
        } else {
            log.info("Entities of similar conversions are being eqalized.");
            this.equalizeEntities(similarConversions);
            log.info("Merging integrated models.");
            this.merger.merge(this.target, this.mergedSources);
            log.info("Merging finished.");
        }
        log.info("Integration completed.");
        return similarConversions;
    }

    private void equalizeEntities(List<ConversionScore> similarConversions) {
        HashSet<conversion> doNotModifySet = new HashSet<conversion>();
        HashSet<ConversionScore> containsSelfRemoved = new HashSet<ConversionScore>();
        for (ConversionScore convScore : similarConversions) {
            if (convScore.getScore() < this.getThreshold()) break;
            conversion conv1 = convScore.getConversion1();
            conversion conv2 = convScore.getConversion2();
            if (conv1.getUri().equals(conv2.getUri())) continue;
            if (doNotModifySet.contains(conv2)) {
                log.info(conv2.getUri() + " has already been modified. Skipped.");
                continue;
            }
            if (this.isSelfRemove()) {
                BioPAXElement eqBPE = this.target.getByID(conv2.getUri());
                if (eqBPE != null) {
                    this.target.remove(eqBPE);
                    log.info("Self removing: " + eqBPE.getUri());
                    for (ConversionScore tempCS : similarConversions) {
                        if (!tempCS.getConversion1().equals(eqBPE)) continue;
                        containsSelfRemoved.add(tempCS);
                    }
                } else if (containsSelfRemoved.contains(convScore)) continue;
            }
            this.equalize(conv1, conv2);
            if (convScore.isReverseMatch()) {
                this.changeDirection(conv2);
            }
            for (physicalEntityParticipant pep1 : convScore.getMatchedPEPs()) {
                physicalEntityParticipant pep2 = convScore.getMatch(pep1);
                this.equalizePEP(pep1, pep2);
            }
            for (control control1 : conv1.isCONTROLLEDOf()) {
                for (control control2 : conv2.isCONTROLLEDOf()) {
                    boolean allSimilar = true;
                    for (physicalEntityParticipant controller1 : control1.getCONTROLLER()) {
                        for (physicalEntityParticipant controller2 : control2.getCONTROLLER()) {
                            if (this.getScore(controller1, controller2) > 0.4) {
                                this.equalizePEP(controller1, controller2);
                                continue;
                            }
                            allSimilar = false;
                        }
                    }
                    if (!allSimilar || control1.getCONTROLLER().size() == 0 ^ control2.getCONTROLLER().size() == 0) continue;
                    this.equalize(control1, control2);
                    if (!convScore.isReverseMatch() || !(control2 instanceof catalysis)) continue;
                    this.changeDirection((catalysis)control2);
                }
            }
            doNotModifySet.add(conv2);
        }
    }

    private void equalize(BioPAXElement e1, BioPAXElement e2) {
        ModelUtils.updateUri(null, e2, e1.getUri());
    }

    private void equalizePEP(physicalEntityParticipant controller1, physicalEntityParticipant controller2) {
        HashSet<physicalEntityParticipant> tempEqvPeps = new HashSet<physicalEntityParticipant>();
        tempEqvPeps.addAll(this.getEquivalentsOfPEP(controller1));
        tempEqvPeps.addAll(this.getEquivalentsOfPEP(controller2));
        for (physicalEntityParticipant eqPep : tempEqvPeps) {
            this.updatePepFields(eqPep, controller2);
        }
        for (physicalEntityParticipant eqPep : tempEqvPeps) {
            this.updatePepFields(controller2, eqPep);
        }
        this.equalize(controller1, controller2);
    }

    private Set<physicalEntityParticipant> getEquivalentsOfPEP(physicalEntityParticipant onePep) {
        HashSet<physicalEntityParticipant> eqGrp = new HashSet<physicalEntityParticipant>();
        for (physicalEntityParticipant aPep : onePep.getPHYSICAL_ENTITY().isPHYSICAL_ENTITYof()) {
            if (!aPep.isInEquivalentState(onePep)) continue;
            eqGrp.add(aPep);
        }
        return eqGrp;
    }

    private void changeDirection(conversion conv) {
        SpontaneousType st = conv.getSPONTANEOUS();
        if (st == SpontaneousType.L_R) {
            conv.setSPONTANEOUS(SpontaneousType.R_L);
        } else if (st == SpontaneousType.R_L) {
            conv.setSPONTANEOUS(SpontaneousType.L_R);
        }
    }

    private void changeDirection(catalysis cat) {
        Direction ct = cat.getDIRECTION();
        if (ct == Direction.IRREVERSIBLE_LEFT_TO_RIGHT) {
            cat.setDIRECTION(Direction.IRREVERSIBLE_RIGHT_TO_LEFT);
        } else if (ct == Direction.IRREVERSIBLE_RIGHT_TO_LEFT) {
            cat.setDIRECTION(Direction.IRREVERSIBLE_LEFT_TO_RIGHT);
        } else if (ct == Direction.PHYSIOL_LEFT_TO_RIGHT) {
            cat.setDIRECTION(Direction.PHYSIOL_RIGHT_TO_LEFT);
        } else if (ct == Direction.PHYSIOL_RIGHT_TO_LEFT) {
            cat.setDIRECTION(Direction.PHYSIOL_LEFT_TO_RIGHT);
        }
    }

    private void mapConversions(Collection<ConversionScore> similarConversions, Map<physicalEntityParticipant, Map<physicalEntityParticipant, Double>> pepScoreMatrix) {
        HashSet<ConversionScore> toBeUpdated = new HashSet<ConversionScore>();
        for (ConversionScore convScore : similarConversions) {
            if (convScore.getScore() < this.getThreshold()) continue;
            for (physicalEntityParticipant pep1 : convScore.getMatchedPEPs()) {
                physicalEntityParticipant pep2 = convScore.getMatch(pep1);
                pepScoreMatrix.get(pep1).put(pep2, 3.5);
            }
            toBeUpdated.add(convScore);
        }
        for (ConversionScore convScore : toBeUpdated) {
            similarConversions.remove(convScore);
            similarConversions.add(this.getScore(pepScoreMatrix, convScore.getConversion1(), convScore.getConversion2()));
        }
    }

    private List<ConversionScore> createConversionScoreMap(Map<physicalEntityParticipant, Map<physicalEntityParticipant, Double>> pepScoreMatrix, Collection<conversion> convSet1, Collection<conversion> convSet2) {
        ArrayList<ConversionScore> similarConversions = new ArrayList<ConversionScore>();
        double totalSize = convSet1.size() * convSet2.size();
        double convCnt = 0.0;
        for (conversion conv1 : convSet1) {
            for (conversion conv2 : convSet2) {
                if (!(conv1 instanceof biochemicalReaction && conv2 instanceof biochemicalReaction || conv1 instanceof complexAssembly && conv2 instanceof complexAssembly || conv1 instanceof transport && conv2 instanceof transport)) {
                    convCnt += 1.0;
                    continue;
                }
                if (conv1.getUri().equals(conv2.getUri())) {
                    convCnt += 1.0;
                    continue;
                }
                ConversionScore convScore = this.getScore(pepScoreMatrix, conv1, conv2);
                similarConversions.add(convScore);
                if (convCnt % Math.ceil(totalSize / 1000.0) == 0.0) {
                    log.info(" - " + convCnt / Math.ceil(totalSize / 1000.0) + "/1000.0 completed.");
                }
                convCnt += 1.0;
            }
        }
        return similarConversions;
    }

    private void createPEPScoreMatrix(Collection<physicalEntityParticipant> pepSet1, Collection<physicalEntityParticipant> pepSet2) {
        assert (this.pepScoreMatrix.isEmpty());
        double totalSize = pepSet1.size() * pepSet2.size();
        double pepCnt = 0.0;
        for (physicalEntityParticipant pep1 : pepSet1) {
            HashMap<physicalEntityParticipant, Double> pep1Row = new HashMap<physicalEntityParticipant, Double>();
            this.pepScoreMatrix.put(pep1, pep1Row);
            for (physicalEntityParticipant pep2 : pepSet2) {
                if (this.complexScoreHelper(pep1.getPHYSICAL_ENTITY(), pep2.getPHYSICAL_ENTITY())) {
                    Double score = this.getScore(pep1, pep2);
                    pep1Row.put(pep2, score);
                }
                if (pepCnt % Math.ceil(totalSize / 1000.0) == 0.0) {
                    log.info(" - " + pepCnt / Math.ceil(totalSize / 1000.0) + "/1000.0 completed.");
                }
                pepCnt += 1.0;
            }
        }
    }

    private boolean complexScoreHelper(physicalEntity cPe, physicalEntity pe) {
        if (cPe instanceof complex && pe instanceof complex) {
            for (physicalEntityParticipant tmpPep : ((complex)cPe).getCOMPONENTS()) {
                if (this.complexScoreHelper(pe, tmpPep.getPHYSICAL_ENTITY())) continue;
                return false;
            }
            return true;
        }
        if (cPe instanceof complex) {
            for (physicalEntityParticipant tmpPep : ((complex)cPe).getCOMPONENTS()) {
                if (!this.complexScoreHelper(tmpPep.getPHYSICAL_ENTITY(), pe)) continue;
                return true;
            }
            return false;
        }
        return cPe.equals(pe);
    }

    private Double getScore(physicalEntityParticipant pep1, physicalEntityParticipant pep2) {
        double totalScore = 0.0;
        if (!(!(pep1 instanceof sequenceParticipant ^ pep2 instanceof sequenceParticipant) || pep1.getPHYSICAL_ENTITY() instanceof smallMolecule && pep2.getPHYSICAL_ENTITY() instanceof smallMolecule)) {
            return 0.4;
        }
        if (pep1.getPHYSICAL_ENTITY().equals(pep2.getPHYSICAL_ENTITY())) {
            totalScore += 2.5;
        } else if (this.complexScoreHelper(pep1.getPHYSICAL_ENTITY(), pep2.getPHYSICAL_ENTITY()) && this.complexScoreHelper(pep2.getPHYSICAL_ENTITY(), pep1.getPHYSICAL_ENTITY())) {
            totalScore += 2.35;
        } else if (this.complexScoreHelper(pep1.getPHYSICAL_ENTITY(), pep2.getPHYSICAL_ENTITY()) || this.complexScoreHelper(pep2.getPHYSICAL_ENTITY(), pep1.getPHYSICAL_ENTITY())) {
            totalScore += 2.0;
        } else {
            return 0.4;
        }
        if (pep1.isInEquivalentState(pep2)) {
            totalScore += 1.0;
        } else if (this.isSeqParTermsSimilar(pep1, pep2)) {
            totalScore += 0.8;
        } else if (this.isCellularLocsSimilar(pep1, pep2)) {
            totalScore += 0.8;
        }
        return totalScore;
    }

    private boolean isCellularLocsTermsSimilar(Set<String> fTerms, Set<String> sTerms) {
        for (String[] locList : this.locLists) {
            for (String fterm : fTerms) {
                for (String sterm : sTerms) {
                    if (!Arrays.asList(locList).contains(fterm) || !Arrays.asList(locList).contains(sterm)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isCellularLocsSimilar(physicalEntityParticipant fPep, physicalEntityParticipant sPep) {
        return fPep.getCELLULAR_LOCATION() == null || sPep.getCELLULAR_LOCATION() == null || this.isCellularLocsTermsSimilar(fPep.getCELLULAR_LOCATION().getTERM(), sPep.getCELLULAR_LOCATION().getTERM());
    }

    private boolean isSeqParTermsSimilar(physicalEntityParticipant fPep, physicalEntityParticipant sPep) {
        if (this.relatedTerms.isEmpty()) {
            for (String[] termL : this.termLists) {
                HashSet termSet = new HashSet();
                termSet.addAll(Arrays.asList(termL));
                this.relatedTerms.add(termSet);
            }
        }
        if (fPep instanceof sequenceParticipant && sPep instanceof sequenceParticipant) {
            for (sequenceFeature fsf : ((sequenceParticipant)fPep).getSEQUENCE_FEATURE_LIST()) {
                for (sequenceFeature ssf : ((sequenceParticipant)sPep).getSEQUENCE_FEATURE_LIST()) {
                    for (Set<String> similarTerm : this.relatedTerms) {
                        if (fsf.getFEATURE_TYPE() == null || ssf.getFEATURE_TYPE() == null) continue;
                        for (String fterm : fsf.getFEATURE_TYPE().getTERM()) {
                            for (String sterm : ssf.getFEATURE_TYPE().getTERM()) {
                                if (!similarTerm.contains(fterm) || !similarTerm.contains(sterm)) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private PEPScore getScore(Map<physicalEntityParticipant, Map<physicalEntityParticipant, Double>> pepScoreMatrix, Set<physicalEntityParticipant> PEPs1, Set<physicalEntityParticipant> PEPs2) {
        Set<physicalEntityParticipant> secondSet;
        Set<physicalEntityParticipant> firstSet;
        boolean transposeMatrix;
        Double finalScore = 1.0;
        HashMap<physicalEntityParticipant, physicalEntityParticipant> pepMap = new HashMap<physicalEntityParticipant, physicalEntityParticipant>();
        if (PEPs2.size() > PEPs1.size()) {
            transposeMatrix = false;
            firstSet = PEPs1;
            secondSet = PEPs2;
        } else {
            transposeMatrix = true;
            firstSet = PEPs2;
            secondSet = PEPs1;
        }
        int sizeDiff = secondSet.size() - firstSet.size();
        int minSize = firstSet.size() == 0 ? secondSet.size() : firstSet.size();
        for (physicalEntityParticipant pep1 : firstSet) {
            HashMap<Double, physicalEntityParticipant> scoreSet = new HashMap<Double, physicalEntityParticipant>();
            for (physicalEntityParticipant pep2 : secondSet) {
                Double pepScore = (transposeMatrix ? this.complexScoreHelper(pep2.getPHYSICAL_ENTITY(), pep1.getPHYSICAL_ENTITY()) : this.complexScoreHelper(pep1.getPHYSICAL_ENTITY(), pep2.getPHYSICAL_ENTITY())) ? (transposeMatrix ? pepScoreMatrix.get(pep2).get(pep1) : pepScoreMatrix.get(pep1).get(pep2)) : Double.valueOf(this.BASE_SCORE);
                scoreSet.put(pepScore, pep2);
            }
            Double maxScore = (Double)Collections.max(scoreSet.keySet());
            finalScore = finalScore * maxScore;
            if (transposeMatrix) {
                pepMap.put((physicalEntityParticipant)scoreSet.get(maxScore), pep1);
                continue;
            }
            pepMap.put(pep1, (physicalEntityParticipant)scoreSet.get(maxScore));
        }
        finalScore = finalScore / Math.pow(3.5, minSize) * Math.pow(0.7, sizeDiff);
        return new PEPScore(finalScore, pepMap);
    }

    private ConversionScore getScore(Map<physicalEntityParticipant, Map<physicalEntityParticipant, Double>> pepScoreMatrix, conversion conv1, conversion conv2) {
        Double score;
        boolean reverseMatch;
        HashMap<physicalEntityParticipant, physicalEntityParticipant> pepMap = new HashMap<physicalEntityParticipant, physicalEntityParticipant>();
        PEPScore l_l = this.getScore(pepScoreMatrix, conv1.getLEFT(), conv2.getLEFT());
        PEPScore r_r = this.getScore(pepScoreMatrix, conv1.getRIGHT(), conv2.getRIGHT());
        Double straightScore = l_l.getScore() * r_r.getScore();
        PEPScore l_r = this.getScore(pepScoreMatrix, conv1.getLEFT(), conv2.getRIGHT());
        PEPScore r_l = this.getScore(pepScoreMatrix, conv1.getRIGHT(), conv2.getLEFT());
        Double reverseScore = l_r.getScore() * r_l.getScore();
        if (straightScore >= reverseScore) {
            reverseMatch = false;
            score = straightScore;
            pepMap.putAll(l_l.getPEPMap());
            pepMap.putAll(r_r.getPEPMap());
        } else {
            reverseMatch = true;
            score = reverseScore;
            pepMap.putAll(l_r.getPEPMap());
            pepMap.putAll(r_l.getPEPMap());
        }
        score = score * this.getScoresOver();
        return new ConversionScore(conv1, conv2, score, pepMap, reverseMatch);
    }

    private void updatePepFields(physicalEntityParticipant update, physicalEntityParticipant existing) {
        if (!(update instanceof sequenceParticipant ^ existing instanceof sequenceParticipant)) {
            this.updateObjectFields(update, existing);
        }
    }

    private void updateObjectFields(BioPAXElement update, BioPAXElement existing) {
        Set<PropertyEditor> editors = this.editorMap.getEditorsOf(update);
        for (PropertyEditor editor : editors) {
            if (editor.getProperty().equals("PHYSICAL-ENTITY")) continue;
            this.updateObjectFieldsForEditor(editor, update, existing);
        }
    }

    private void updateObjectFieldsForEditor(PropertyEditor editor, BioPAXElement update, BioPAXElement existing) {
        for (Object updateValue : editor.getValueFromBean(update)) {
            boolean notDuplicate;
            block4: {
                notDuplicate = true;
                try {
                    if (!(updateValue instanceof BioPAXElement)) break block4;
                    for (Object existingValue : editor.getValueFromBean(existing)) {
                        if (!((BioPAXElement)existingValue).isEquivalent((BioPAXElement)updateValue)) continue;
                        notDuplicate = false;
                        break;
                    }
                }
                catch (IllegalArgumentException e) {
                    log.info("Empty property on bean, skipping...");
                }
            }
            if (!notDuplicate) continue;
            this.updateField(editor, updateValue, existing);
        }
    }

    private void updateField(PropertyEditor editor, Object updateValue, BioPAXElement existing) {
        editor.setValueToBean(updateValue, existing);
    }

    private void normalizeXrefs(Model model) {
        for (xref oneXref : model.getObjects(xref.class)) {
            for (String[] dbChange : this.dbChanges) {
                if (oneXref.getDB() == null) continue;
                oneXref.setDB(oneXref.getDB().replace(dbChange[0], dbChange[1]));
            }
        }
    }

    private void normalizeOpenControlledVocabulary(Model model) {
        for (openControlledVocabulary ocv1 : this.target.getObjects(openControlledVocabulary.class)) {
            for (openControlledVocabulary ocv2 : model.getObjects(openControlledVocabulary.class)) {
                if (!this.isOCVsSemanticallyEquivalent(ocv1, ocv2)) continue;
                this.equalize(ocv1, ocv2);
            }
        }
        for (openControlledVocabulary ocv1 : model.getObjects(openControlledVocabulary.class)) {
            for (openControlledVocabulary ocv2 : model.getObjects(openControlledVocabulary.class)) {
                if (!this.isOCVsSemanticallyEquivalent(ocv1, ocv2)) continue;
                this.equalize(ocv1, ocv2);
            }
        }
    }

    private boolean isOCVsSemanticallyEquivalent(openControlledVocabulary ocv1, openControlledVocabulary ocv2) {
        return ocv1.equals(ocv2) || (ocv1.getXREF().isEmpty() || ocv2.getXREF().isEmpty() ? this.OCVsHaveCommonTerm(ocv1, ocv2) : !ocv1.findCommonUnifications(ocv2).isEmpty() || this.OCVsHaveCommonTerm(ocv1, ocv2));
    }

    private boolean OCVsHaveCommonTerm(openControlledVocabulary ocv1, openControlledVocabulary ocv2) {
        for (String s : ocv1.getTERM()) {
            if (!ocv2.getTERM().contains(s)) continue;
            return true;
        }
        return false;
    }

    private void normalizeCellularLocations(Model model) {
        openControlledVocabulary mostlyUsed = null;
        Integer maxOccurence = 0;
        HashMap<openControlledVocabulary, Integer> termCounter = new HashMap<openControlledVocabulary, Integer>();
        for (BioPAXElement bioPAXElement : this.target.getObjects(physicalEntityParticipant.class)) {
            openControlledVocabulary openControlledVocabulary2 = ((physicalEntityParticipant)bioPAXElement).getCELLULAR_LOCATION();
            if (openControlledVocabulary2 == null) continue;
            Integer cnt = (Integer)termCounter.get(openControlledVocabulary2);
            if (cnt == null) {
                cnt = 0;
                termCounter.put(openControlledVocabulary2, cnt);
            }
            if ((cnt = Integer.valueOf(cnt + 1)) <= maxOccurence) continue;
            mostlyUsed = openControlledVocabulary2;
        }
        if (mostlyUsed == null) {
            return;
        }
        ArrayList<physicalEntityParticipant> pepList = new ArrayList<physicalEntityParticipant>();
        pepList.addAll(model.getObjects(physicalEntityParticipant.class));
        for (BioPAXElement bioPAXElement : pepList) {
            openControlledVocabulary ov = ((physicalEntityParticipant)bioPAXElement).getCELLULAR_LOCATION();
            if (ov == null) {
                if (model.getByID(mostlyUsed.getUri()) == null) {
                    ov = model.addNew(openControlledVocabulary.class, mostlyUsed.getUri());
                    ov.setCOMMENT(mostlyUsed.getCOMMENT());
                    ov.setTERM(mostlyUsed.getTERM());
                    ov.setXREF(mostlyUsed.getXREF());
                } else {
                    ov = (openControlledVocabulary)model.getByID(mostlyUsed.getUri());
                }
                ((physicalEntityParticipant)bioPAXElement).setCELLULAR_LOCATION(ov);
                continue;
            }
            if (ov.getTERM().isEmpty()) {
                ov.setTERM(mostlyUsed.getTERM());
                continue;
            }
            if (!this.isCellularLocsTermsSimilar(ov.getTERM(), mostlyUsed.getTERM())) continue;
            ov.setTERM(mostlyUsed.getTERM());
            ov.setXREF(mostlyUsed.getXREF());
        }
    }
}

