/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.AbstractPropertyEditor;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.util.AbstractFilterSet;
import org.biopax.paxtools.util.CompositeIterator;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorMapImpl
implements EditorMap {
    protected final Map<String, Set<PropertyEditor>> propertyToEditorMap = new HashMap<String, Set<PropertyEditor>>();
    protected final Map<Class<? extends BioPAXElement>, Map<String, PropertyEditor>> classToEditorMap = new HashMap<Class<? extends BioPAXElement>, Map<String, PropertyEditor>>();
    protected final Map<Class<? extends BioPAXElement>, Set<ObjectPropertyEditor>> classToInverseEditorMap = new HashMap<Class<? extends BioPAXElement>, Set<ObjectPropertyEditor>>();
    protected final Map<Class<? extends BioPAXElement>, Set<PropertyEditor>> classToEditorSet = new HashMap<Class<? extends BioPAXElement>, Set<PropertyEditor>>();
    private static final Logger log = LoggerFactory.getLogger(EditorMapImpl.class);
    protected final BioPAXLevel level;

    public EditorMapImpl(BioPAXLevel level) {
        this.level = level;
    }

    @Override
    public Set<PropertyEditor> getEditorsOf(BioPAXElement bpe) {
        return this.getEditorsOf(bpe.getModelInterface());
    }

    @Override
    public Set<PropertyEditor> getEditorsOf(Class<? extends BioPAXElement> domain) {
        return this.classToEditorSet.get(domain);
    }

    @Override
    public Set<ObjectPropertyEditor> getInverseEditorsOf(BioPAXElement bpe) {
        return this.getInverseEditorsOf(bpe.getModelInterface());
    }

    @Override
    public Set<ObjectPropertyEditor> getInverseEditorsOf(Class<? extends BioPAXElement> domain) {
        return this.classToInverseEditorMap.get(domain);
    }

    @Override
    public <D extends BioPAXElement> PropertyEditor<? super D, ?> getEditorForProperty(String property, Class<D> javaClass) {
        Map<String, PropertyEditor> classEditors = this.classToEditorMap.get(javaClass);
        PropertyEditor result = null;
        if (classEditors != null && (result = classEditors.get(property)) == null && log.isDebugEnabled()) {
            log.debug("Could not locate controller for " + property + " | " + String.valueOf(javaClass));
        }
        return result;
    }

    @Override
    public <D extends BioPAXElement> Set<PropertyEditor<? extends D, ?>> getSubclassEditorsForProperty(String property, Class<D> domain) {
        return new SubDomainFilterSet<D>(this.getEditorsForProperty(property), domain);
    }

    @Override
    public Set<PropertyEditor> getEditorsForProperty(String property) {
        return this.propertyToEditorMap.get(property);
    }

    @Override
    public <E extends BioPAXElement> Set<? extends Class<E>> getKnownSubClassesOf(Class<E> javaClass) {
        return new SubClassFilterSet<E>(this.classToEditorMap.keySet(), javaClass);
    }

    protected boolean isInBioPAXNameSpace(String nameSpace) {
        return nameSpace != null && nameSpace.startsWith("http://www.biopax.org/release/");
    }

    protected PropertyEditor createAndRegisterBeanEditor(String pName, Class domain, Map<Class<? extends BioPAXElement>, Set<Class<? extends BioPAXElement>>> rRestrictions) {
        PropertyEditor editor = AbstractPropertyEditor.createPropertyEditor(domain, pName);
        if (editor instanceof ObjectPropertyEditor && rRestrictions != null) {
            ((ObjectPropertyEditor)editor).setRangeRestriction(rRestrictions);
        }
        if (editor != null) {
            Set<PropertyEditor> beanEditorsForProperty = this.propertyToEditorMap.get(pName);
            if (beanEditorsForProperty == null) {
                beanEditorsForProperty = new HashSet<PropertyEditor>();
                this.propertyToEditorMap.put(pName, beanEditorsForProperty);
            }
            beanEditorsForProperty.add(editor);
            this.registerEditorsWithSubClasses(editor, domain);
        } else if (log.isWarnEnabled()) {
            log.warn("property = " + pName + "\ndomain = " + String.valueOf(domain));
        }
        return editor;
    }

    protected void registerEditorsWithSubClasses(PropertyEditor editor, Class<? extends BioPAXElement> domain) {
        for (Class<? extends BioPAXElement> c : this.classToEditorMap.keySet()) {
            if (!domain.isAssignableFrom(c)) continue;
            if (editor.getProperty().equals("PARTICIPANTS") && (conversion.class.isAssignableFrom(c) || control.class.isAssignableFrom(c)) || editor.getProperty().equals("participant") && (Conversion.class.isAssignableFrom(c) || Control.class.isAssignableFrom(c))) {
                if (!log.isDebugEnabled()) continue;
                log.debug("skipping restricted participant property");
                continue;
            }
            this.classToEditorMap.get(c).put(editor.getProperty(), editor);
        }
        if (editor instanceof ObjectPropertyEditor) {
            this.registerInverseEditors((ObjectPropertyEditor)editor);
        }
    }

    private void registerInverseEditors(ObjectPropertyEditor editor) {
        if (editor.hasInverseLink()) {
            for (Class<? extends BioPAXElement> c : this.classToInverseEditorMap.keySet()) {
                if (!this.checkInverseRangeIsAssignable(editor, c)) continue;
                this.classToInverseEditorMap.get(c).add(editor);
            }
        }
    }

    private boolean checkInverseRangeIsAssignable(ObjectPropertyEditor editor, Class<? extends BioPAXElement> c) {
        if (editor.getRange().isAssignableFrom(c)) {
            Set<Class<BioPAXElement>> restrictedRanges = editor.getRestrictedRangesFor(editor.getDomain());
            if (restrictedRanges.isEmpty()) {
                return true;
            }
            for (Class<BioPAXElement> restrictedRange : restrictedRanges) {
                if (!restrictedRange.isAssignableFrom(c)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void registerModelClass(String localName) {
        block2: {
            try {
                Class<? extends BioPAXElement> domain = this.getLevel().getInterfaceForName(localName);
                HashMap peMap = new HashMap();
                this.classToEditorMap.put(domain, peMap);
                this.classToInverseEditorMap.put(domain, new HashSet());
                this.classToEditorSet.put(domain, new ValueSet(peMap.values()));
            }
            catch (IllegalBioPAXArgumentException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Skipping (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public Iterator<PropertyEditor> iterator() {
        return new CompositeIterator<PropertyEditor>(this.propertyToEditorMap.values());
    }

    @Override
    public BioPAXLevel getLevel() {
        return this.level;
    }

    private class SubDomainFilterSet<D extends BioPAXElement>
    extends AbstractFilterSet<PropertyEditor, PropertyEditor<? extends D, ?>> {
        private Class<D> domain;

        public SubDomainFilterSet(Set<PropertyEditor> baseSet, Class<D> domain) {
            super(baseSet);
            this.domain = domain;
        }

        @Override
        public boolean filter(PropertyEditor editor) {
            return this.domain.isAssignableFrom(editor.getDomain());
        }
    }

    private class SubClassFilterSet<E>
    extends AbstractFilterSet<Class<? extends BioPAXElement>, Class<E>> {
        private Class superClass;

        public SubClassFilterSet(Set<Class<? extends BioPAXElement>> baseSet, Class<E> superClass) {
            super(baseSet);
            this.superClass = superClass;
        }

        @Override
        public boolean filter(Class<? extends BioPAXElement> subClass) {
            return this.superClass.isAssignableFrom(subClass);
        }
    }

    private class ValueSet
    extends AbstractSet<PropertyEditor> {
        Collection values;

        public ValueSet(Collection<PropertyEditor> values) {
            this.values = values;
        }

        @Override
        public Iterator<PropertyEditor> iterator() {
            return this.values.iterator();
        }

        @Override
        public int size() {
            return this.values.size();
        }
    }
}

