/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.biopax.paxtools.impl.level3.NamedImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.SetEquivalenceChecker;

public abstract class EntityImpl
extends NamedImpl
implements Entity {
    private Set<Interaction> participantOf;
    private Set<String> availability = BPCollections.I.createSet();
    private Set<Provenance> dataSource = BPCollections.I.createSafeSet();
    private Set<Evidence> evidence;

    public EntityImpl() {
        this.participantOf = BPCollections.I.createSafeSet();
        this.evidence = BPCollections.I.createSafeSet();
    }

    @Override
    public Set<String> getAvailability() {
        return this.availability;
    }

    @Override
    public void addAvailability(String availability_text) {
        if (availability_text != null && availability_text.length() > 0) {
            this.availability.add(availability_text);
        }
    }

    @Override
    public void removeAvailability(String availability_text) {
        if (availability_text != null) {
            this.availability.remove(availability_text);
        }
    }

    @Override
    public Set<Provenance> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(Set<Provenance> dataSource2) {
        this.dataSource = dataSource2;
    }

    @Override
    public void addDataSource(Provenance dataSource2) {
        if (dataSource2 != null) {
            this.dataSource.add(dataSource2);
        }
    }

    @Override
    public void removeDataSource(Provenance dataSource2) {
        if (dataSource2 != null) {
            this.dataSource.remove(dataSource2);
        }
    }

    @Override
    public Set<Interaction> getParticipantOf() {
        return this.participantOf;
    }

    @Override
    public Set<Evidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void addEvidence(Evidence newEvidence) {
        if (newEvidence != null) {
            this.evidence.add(newEvidence);
        }
    }

    @Override
    public void removeEvidence(Evidence oldEvidence) {
        if (oldEvidence != null) {
            this.evidence.remove(oldEvidence);
        }
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        boolean equivalence = false;
        if (element instanceof Entity) {
            Entity otherEntity = (Entity)element;
            equivalence = SetEquivalenceChecker.hasEquivalentIntersection(this.dataSource, otherEntity.getDataSource()) && SetEquivalenceChecker.hasEquivalentIntersection(new ClassFilterSet<Xref, UnificationXref>(this.getXref(), UnificationXref.class), new ClassFilterSet<Xref, UnificationXref>(otherEntity.getXref(), UnificationXref.class)) && SetEquivalenceChecker.hasEquivalentIntersection(this.evidence, otherEntity.getEvidence());
        }
        return equivalence;
    }
}

